/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.VoidFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FluidUtil {
    private FluidUtil() {
    }

    @Nonnull
    public static FluidActionResult interactWithFluidHandler(@Nonnull afi stack, IFluidHandler fluidHandler, aax player) {
        if (stack.b() || fluidHandler == null || player == null) {
            return FluidActionResult.FAILURE;
        }
        InvWrapper playerInventory = new InvWrapper((rb)player.bs);
        FluidActionResult fillResult = FluidUtil.tryFillContainerAndStow(stack, fluidHandler, playerInventory, Integer.MAX_VALUE, player);
        if (fillResult.isSuccess()) {
            return fillResult;
        }
        return FluidUtil.tryEmptyContainerAndStow(stack, fluidHandler, playerInventory, Integer.MAX_VALUE, player);
    }

    @Nonnull
    public static FluidActionResult tryFillContainer(@Nonnull afi container, IFluidHandler fluidSource, int maxAmount, @Nullable aax player, boolean doFill) {
        FluidStack simulatedTransfer;
        afi containerCopy = container.l();
        containerCopy.e(1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler(containerCopy);
        if (containerFluidHandler != null && (simulatedTransfer = FluidUtil.tryFluidTransfer(containerFluidHandler, fluidSource, maxAmount, false)) != null) {
            if (doFill) {
                FluidUtil.tryFluidTransfer(containerFluidHandler, fluidSource, maxAmount, true);
                if (player != null) {
                    nm soundevent = simulatedTransfer.getFluid().getFillSound(simulatedTransfer);
                    player.a(soundevent, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.fill(simulatedTransfer, true);
            }
            afi resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainer(@Nonnull afi container, IFluidHandler fluidDestination, int maxAmount, @Nullable aax player, boolean doDrain) {
        FluidStack simulatedTransfer;
        afi containerCopy = container.l();
        containerCopy.e(1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler(containerCopy);
        if (containerFluidHandler != null && (simulatedTransfer = FluidUtil.tryFluidTransfer(fluidDestination, containerFluidHandler, maxAmount, false)) != null) {
            if (doDrain) {
                FluidUtil.tryFluidTransfer(fluidDestination, containerFluidHandler, maxAmount, true);
                if (player != null) {
                    nm soundevent = simulatedTransfer.getFluid().getEmptySound(simulatedTransfer);
                    player.a(soundevent, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.drain(simulatedTransfer, true);
            }
            afi resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryFillContainerAndStow(@Nonnull afi container, IFluidHandler fluidSource, IItemHandler inventory, int maxAmount, @Nullable aax player) {
        if (container.b()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.bK.d) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
            if (filledReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.E() == 1) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
            if (filledReal.isSuccess()) {
                return filledReal;
            }
        } else {
            afi remainder;
            FluidActionResult filledSimulated = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, filledSimulated.getResult(), true)).b() || player != null)) {
                FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, filledReal.getResult(), false);
                if (!remainder.b() && player != null) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                afi containerCopy = container.l();
                containerCopy.g(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainerAndStow(@Nonnull afi container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable aax player) {
        if (container.b()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.bK.d) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.E() == 1) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            afi remainder;
            FluidActionResult emptiedSimulated = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedSimulated.getResult(), true)).b() || player != null)) {
                FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedReal.getResult(), false);
                if (!remainder.b() && player != null) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                afi containerCopy = container.l();
                containerCopy.g(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nullable
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        int fillableAmount;
        FluidStack drainable = fluidSource.drain(maxAmount, false);
        if (drainable != null && drainable.amount > 0 && (fillableAmount = fluidDestination.fill(drainable, false)) > 0) {
            if (doTransfer) {
                FluidStack drained = fluidSource.drain(fillableAmount, true);
                if (drained != null) {
                    drained.amount = fluidDestination.fill(drained, true);
                    return drained;
                }
            } else {
                drainable.amount = fillableAmount;
                return drainable;
            }
        }
        return null;
    }

    @Nullable
    public static IFluidHandlerItem getFluidHandler(@Nonnull afi itemStack) {
        if (itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        }
        return null;
    }

    @Nullable
    public static FluidStack getFluidContained(@Nonnull afi container) {
        if (!container.b()) {
            container = container.l();
            container.e(1);
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler(container);
            if (fluidHandler != null) {
                return fluidHandler.drain(Integer.MAX_VALUE, false);
            }
        }
        return null;
    }

    @Nullable
    public static IFluidHandler getFluidHandler(ajq world, co blockPos, @Nullable cv side) {
        atj state = world.o(blockPos);
        als block = state.v();
        if (block.hasTileEntity(state)) {
            asa tileEntity = world.r(blockPos);
            if (tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
                return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            }
        } else {
            if (block instanceof IFluidBlock) {
                return new FluidBlockWrapper((IFluidBlock)block, world, blockPos);
            }
            if (block instanceof aoo) {
                return new BlockLiquidWrapper((aoo)block, world, blockPos);
            }
        }
        return null;
    }

    @Nonnull
    public static FluidActionResult tryPickUpFluid(@Nonnull afi emptyContainer, @Nullable aax playerIn, ajq worldIn, co pos, cv side) {
        FluidActionResult fluidActionResult;
        IFluidHandler targetFluidHandler;
        if (emptyContainer.b() || worldIn == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        atj state = worldIn.o(pos);
        als block = state.v();
        if ((block instanceof IFluidBlock || block instanceof aoo) && (targetFluidHandler = FluidUtil.getFluidHandler(worldIn, pos, side)) != null && (fluidActionResult = FluidUtil.tryFillContainer(emptyContainer, targetFluidHandler, Integer.MAX_VALUE, playerIn, true)).isSuccess()) {
            return fluidActionResult;
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryPlaceFluid(@Nullable aax player, ajq world, co pos, @Nonnull afi container, FluidStack resource) {
        als block;
        IFluidHandler handler;
        FluidActionResult result;
        if (world == null || resource == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        Fluid fluid = resource.getFluid();
        if (fluid == null || !fluid.canBePlacedInWorld()) {
            return FluidActionResult.FAILURE;
        }
        atj destBlockState = world.o(pos);
        azq destMaterial = destBlockState.a();
        boolean isDestNonSolid = !destMaterial.a();
        boolean isDestReplaceable = destBlockState.v().a((aju)world, pos);
        if (!(world.d(pos) || isDestNonSolid || isDestReplaceable)) {
            return FluidActionResult.FAILURE;
        }
        if (world.s.l() && fluid.doesVaporize(resource)) {
            fluid.vaporize(player, world, pos, resource);
            return FluidUtil.tryEmptyContainer(container, new VoidFluidHandler(), Integer.MAX_VALUE, player, true);
        }
        if (!world.E && (isDestNonSolid || isDestReplaceable) && !destMaterial.d()) {
            world.b(pos, true);
        }
        if ((result = FluidUtil.tryEmptyContainer(container, handler = (block = fluid.getBlock()) instanceof IFluidBlock ? new FluidBlockWrapper((IFluidBlock)block, world, pos) : (block instanceof aoo ? new BlockLiquidWrapper((aoo)block, world, pos) : new BlockWrapper(block, world, pos)), Integer.MAX_VALUE, player, true)).isSuccess()) {
            nm soundevent = fluid.getEmptySound(resource);
            world.a(player, pos, soundevent, no.e, 1.0f, 1.0f);
        }
        return result;
    }
}

