/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability;

import java.util.concurrent.Callable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class CapabilityFluidHandler {
    @CapabilityInject(value=IFluidHandler.class)
    public static Capability<IFluidHandler> FLUID_HANDLER_CAPABILITY = null;
    @CapabilityInject(value=IFluidHandlerItem.class)
    public static Capability<IFluidHandlerItem> FLUID_HANDLER_ITEM_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IFluidHandler.class, new DefaultFluidHandlerStorage(), new Callable<IFluidHandler>(){

            @Override
            public IFluidHandler call() throws Exception {
                return new FluidTank(1000);
            }
        });
        CapabilityManager.INSTANCE.register(IFluidHandlerItem.class, new DefaultFluidHandlerStorage(), new Callable<IFluidHandlerItem>(){

            @Override
            public IFluidHandlerItem call() throws Exception {
                return new FluidHandlerItemStack(new afi(afk.az), 1000);
            }
        });
    }

    private static class DefaultFluidHandlerStorage<T extends IFluidHandler>
    implements Capability.IStorage<T> {
        private DefaultFluidHandlerStorage() {
        }

        @Override
        public ei writeNBT(Capability<T> capability, T instance, cv side) {
            if (!(instance instanceof IFluidTank)) {
                throw new RuntimeException("IFluidHandler instance does not implement IFluidTank");
            }
            du nbt = new du();
            IFluidTank tank = (IFluidTank)instance;
            FluidStack fluid = tank.getFluid();
            if (fluid != null) {
                fluid.writeToNBT(nbt);
            } else {
                nbt.a("Empty", "");
            }
            nbt.a("Capacity", tank.getCapacity());
            return nbt;
        }

        @Override
        public void readNBT(Capability<T> capability, T instance, cv side, ei nbt) {
            if (!(instance instanceof IFluidTank)) {
                throw new RuntimeException("IFluidHandler instance is not instance of FluidTank");
            }
            du tags = (du)nbt;
            FluidTank tank = (FluidTank)instance;
            tank.setCapacity(tags.h("Capacity"));
            tank.readFromNBT(tags);
        }
    }
}

