/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.wrappers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidBucketWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    @Nonnull
    protected afi container;

    public FluidBucketWrapper(@Nonnull afi container) {
        this.container = container;
    }

    @Override
    @Nonnull
    public afi getContainer() {
        return this.container;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (fluid.getFluid() == FluidRegistry.WATER || fluid.getFluid() == FluidRegistry.LAVA || fluid.getFluid().getName().equals("milk")) {
            return true;
        }
        return FluidRegistry.isUniversalBucketEnabled() && FluidRegistry.getBucketFluids().contains(fluid.getFluid());
    }

    @Nullable
    public FluidStack getFluid() {
        afg item = this.container.c();
        if (item == afk.aA) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (item == afk.aB) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if (item == afk.aO) {
            return FluidRegistry.getFluidStack("milk", 1000);
        }
        if (item == ForgeModContainer.getInstance().universalBucket) {
            return ForgeModContainer.getInstance().universalBucket.getFluid(this.container);
        }
        return null;
    }

    protected void setFluid(Fluid fluid) {
        if (fluid == null) {
            this.container = new afi(afk.az);
        } else if (fluid == FluidRegistry.WATER) {
            this.container = new afi(afk.aA);
        } else if (fluid == FluidRegistry.LAVA) {
            this.container = new afi(afk.aB);
        } else if (fluid.getName().equals("milk")) {
            this.container = new afi(afk.aO);
        } else if (FluidRegistry.isUniversalBucketEnabled() && FluidRegistry.getBucketFluids().contains(fluid)) {
            this.container = UniversalBucket.getFilledBucket(ForgeModContainer.getInstance().universalBucket, fluid);
        }
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 1000)};
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.E() != 1 || resource == null || resource.amount < 1000 || this.container.c() instanceof afp || this.getFluid() != null || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (doFill) {
            this.setFluid(resource.getFluid());
        }
        return 1000;
    }

    @Override
    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.E() != 1 || resource == null || resource.amount < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null && fluidStack.isFluidEqual(resource)) {
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.E() != 1 || maxDrain < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }
        return null;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable cv facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable cv facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast(this);
        }
        return null;
    }
}

