/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

public class HoverChecker {
    private int top;
    private int bottom;
    private int left;
    private int right;
    private int threshold;
    private bfk button;
    private long hoverStart;

    public HoverChecker(int top, int bottom, int left, int right, int threshold) {
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
        this.threshold = threshold;
        this.hoverStart = -1L;
    }

    public HoverChecker(bfk button, int threshold) {
        this.button = button;
        this.threshold = threshold;
    }

    public void updateBounds(int top, int bottom, int left, int right) {
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
    }

    public boolean checkHover(int mouseX, int mouseY) {
        return this.checkHover(mouseX, mouseY, true);
    }

    public boolean checkHover(int mouseX, int mouseY, boolean canHover) {
        if (this.button != null) {
            this.top = this.button.i;
            this.bottom = this.button.i + this.button.g;
            this.left = this.button.h;
            this.right = this.button.h + this.button.f;
            boolean bl = canHover = canHover && this.button.m;
        }
        if (canHover && this.hoverStart == -1L && mouseY >= this.top && mouseY <= this.bottom && mouseX >= this.left && mouseX <= this.right) {
            this.hoverStart = System.currentTimeMillis();
        } else if (!canHover || mouseY < this.top || mouseY > this.bottom || mouseX < this.left || mouseX > this.right) {
            this.resetHoverTimer();
        }
        return canHover && this.hoverStart != -1L && System.currentTimeMillis() - this.hoverStart >= (long)this.threshold;
    }

    public void resetHoverTimer() {
        this.hoverStart = -1L;
    }
}

