/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.patcher;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.repackage.com.nothome.delta.Delta;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class GenDiffSet {
    private static final List<String> RESERVED_NAMES = Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9");

    public static void main(String[] args) throws IOException {
        String sourceJar = args[0];
        String targetDir = args[1];
        String deobfData = args[2];
        String outputDir = args[3];
        String killTarget = args[4];
        LogManager.getLogger((String)"GENDIFF").log(Level.INFO, String.format("Creating patches at %s for %s from %s", outputDir, sourceJar, targetDir));
        Delta delta = new Delta();
        FMLDeobfuscatingRemapper remapper = FMLDeobfuscatingRemapper.INSTANCE;
        remapper.setupLoadOnly(deobfData, false);
        JarFile sourceZip = new JarFile(sourceJar);
        boolean kill = killTarget.equalsIgnoreCase("true");
        File f2 = new File(outputDir);
        f2.mkdirs();
        Iterator<String> iterator = remapper.getObfedClasses().iterator();
        while (iterator.hasNext()) {
            String name;
            String fileName = name = iterator.next();
            String jarName = name;
            if (RESERVED_NAMES.contains(name.toUpperCase(Locale.ENGLISH))) {
                fileName = "_" + name;
            }
            File targetFile = new File(targetDir, fileName.replace('/', File.separatorChar) + ".class");
            jarName = jarName + ".class";
            if (!targetFile.exists()) continue;
            String sourceClassName = name.replace('/', '.');
            String targetClassName = remapper.map(name).replace('/', '.');
            JarEntry entry = sourceZip.getJarEntry(jarName);
            byte[] vanillaBytes = GenDiffSet.toByteArray(sourceZip, entry);
            byte[] patchedBytes = Files.toByteArray((File)targetFile);
            byte[] diff = delta.compute(vanillaBytes, patchedBytes);
            ByteArrayDataOutput diffOut = ByteStreams.newDataOutput((int)(diff.length + 50));
            diffOut.writeUTF(name);
            diffOut.writeUTF(sourceClassName);
            diffOut.writeUTF(targetClassName);
            diffOut.writeBoolean(entry != null);
            if (entry != null) {
                diffOut.writeInt(Hashing.adler32().hashBytes(vanillaBytes).asInt());
            }
            diffOut.writeInt(diff.length);
            diffOut.write(diff);
            File target = new File(outputDir, targetClassName + ".binpatch");
            target.getParentFile().mkdirs();
            Files.write((byte[])diffOut.toByteArray(), (File)target);
            Logger.getLogger("GENDIFF").info(String.format("Wrote patch for %s (%s) at %s", name, targetClassName, target.getAbsolutePath()));
            if (!kill) continue;
            targetFile.delete();
            Logger.getLogger("GENDIFF").info(String.format("  Deleted target: %s", targetFile.toString()));
        }
        sourceZip.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(JarFile sourceZip, @Nullable JarEntry entry) throws IOException {
        if (entry == null) {
            return new byte[0];
        }
        InputStream sourceZipInputStream = sourceZip.getInputStream(entry);
        try {
            byte[] byArray = ByteStreams.toByteArray((InputStream)sourceZipInputStream);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)sourceZipInputStream);
        }
    }
}

