/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private BiMap<Class<? extends sm>, EntityRegistration> entityClassRegistrations = HashBiMap.create();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
    }

    public static void registerModEntity(kq registryName, Class<? extends sm> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(registryName, entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    public static void registerModEntity(kq registryName, Class<? extends sm> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.instance().doModEntityRegistration(registryName, entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerEgg(registryName, eggPrimary, eggSecondary);
    }

    private void doModEntityRegistration(kq registryName, Class<? extends sm> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er2 = new EntityRegistration(mc, registryName, entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er2);
            if (!ForgeRegistries.ENTITIES.containsKey(registryName)) {
                EntityEntry entry = (EntityEntry)new EntityEntry(entityClass, entityName).setRegistryName(registryName);
                ForgeRegistries.ENTITIES.register(entry);
                FMLLog.finer("Automatically registered mod %s entity %s as %s", mc.getModId(), entityName, entry.getRegistryName());
            } else {
                FMLLog.fine("Skipping automatic mod %s entity registration for already registered entry %s class %s", mc.getModId(), registryName, entityClass.getName());
            }
        }
        catch (IllegalArgumentException e2) {
            FMLLog.log(Level.WARN, e2, "The mod %s tried to register the entity (registry,name,class) (%s,%s,%s) one or both of which are already registered", mc.getModId(), registryName, entityName, entityClass.getName());
            return;
        }
        this.entityRegistrations.put((Object)mc, (Object)er2);
    }

    public static void registerEgg(kq name, int primary, int secondary) {
        EntityEntry entry = ForgeRegistries.ENTITIES.getValue(name);
        if (entry == null) {
            FMLLog.bigWarning("Attempted to registry a entity egg for entity (%s) that is not in the Entity Registry", name);
            return;
        }
        entry.setEgg(new so.a(name, primary, secondary));
    }

    public static void addSpawn(Class<? extends sw> entityClass, int weightedProb, int min, int max, sx typeOfCreature, akd ... biomes) {
        for (akd biome : biomes) {
            List spawns = biome.a(typeOfCreature);
            boolean found = false;
            for (akd.c entry : spawns) {
                if (entry.b != entityClass) continue;
                entry.a = weightedProb;
                entry.c = min;
                entry.d = max;
                found = true;
                break;
            }
            if (found) continue;
            spawns.add(new akd.c(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, sx typeOfCreature, akd ... biomes) {
        Class<?> entityClazz = null;
        if (sw.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, typeOfCreature, biomes);
        }
    }

    public static void removeSpawn(Class<? extends sw> entityClass, sx typeOfCreature, akd ... biomes) {
        for (akd biome : biomes) {
            Iterator spawns = biome.a(typeOfCreature).iterator();
            while (spawns.hasNext()) {
                akd.c entry = (akd.c)spawns.next();
                if (entry.b != entityClass) continue;
                spawns.remove();
            }
        }
    }

    public static void removeSpawn(String entityName, sx typeOfCreature, akd ... biomes) {
        Class<?> entityClazz = null;
        if (sw.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, typeOfCreature, biomes);
        }
    }

    public EntityRegistration lookupModSpawn(Class<? extends sm> clazz, boolean keepLooking) {
        Class<? extends sm> localClazz = clazz;
        do {
            EntityRegistration er2;
            if ((er2 = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er2;
        } while (keepLooking &= !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    public EntityRegistration lookupModSpawn(ModContainer mc, int modEntityId) {
        for (EntityRegistration er2 : this.entityRegistrations.get((Object)mc)) {
            if (er2.getModEntityId() != modEntityId) continue;
            return er2;
        }
        return null;
    }

    public boolean tryTrackingEntity(lt entityTracker, sm entity) {
        EntityRegistration er2 = this.lookupModSpawn(entity.getClass(), true);
        if (er2 != null) {
            entityTracker.a(entity, er2.getTrackingRange(), er2.getUpdateFrequency(), er2.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    public static EntityEntry getEntry(Class<? extends sm> entry) {
        for (EntityEntry e2 : ForgeRegistries.ENTITIES) {
            if (e2.getEntityClass() != entry) continue;
            return e2;
        }
        return null;
    }

    public class EntityRegistration {
        private Class<? extends sm> entityClass;
        private ModContainer container;
        private kq regName;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;
        private Function<FMLMessage.EntitySpawnMessage, sm> customSpawnCallback;
        private boolean usesVanillaSpawning;

        public EntityRegistration(ModContainer mc, kq registryName, Class<? extends sm> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.container = mc;
            this.regName = registryName;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
        }

        public kq getRegistryName() {
            return this.regName;
        }

        public Class<? extends sm> getEntityClass() {
            return this.entityClass;
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }

        public boolean usesVanillaSpawning() {
            return this.usesVanillaSpawning;
        }

        public boolean hasCustomSpawning() {
            return this.customSpawnCallback != null;
        }

        public sm doCustomSpawning(FMLMessage.EntitySpawnMessage spawnMsg) throws Exception {
            return (sm)this.customSpawnCallback.apply((Object)spawnMsg);
        }

        public void setCustomSpawning(Function<FMLMessage.EntitySpawnMessage, sm> callable, boolean usesVanillaSpawning) {
            this.customSpawnCallback = callable;
            this.usesVanillaSpawning = usesVanillaSpawning;
        }
    }
}

