/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.functions.GenericIterableFactory;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.IncompatibleSubstitutionException;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Level;

public class FMLControlledNamespacedRegistry<I extends IForgeRegistryEntry<I>>
extends ct<kq, I>
implements IForgeRegistry<I> {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("fml.debugRegistryEntries", "false"));
    private final Class<I> superType;
    private final boolean isDelegated;
    private kq optionalDefaultKey;
    private I optionalDefaultObject;
    private int maxId;
    private int minId;
    private final Map<kq, kq> aliases = Maps.newHashMap();
    private final BiMap<kq, I> persistentSubstitutions = HashBiMap.create();
    private final BiMap<kq, I> substitutionOriginals = HashBiMap.create();
    private final BiMap<kq, I> activeSubstitutions = HashBiMap.create();
    private final Set<Integer> blockedIds = Sets.newHashSet();
    private final Set<kq> dummiedLocations = Sets.newHashSet();
    private final BitSet availabilityMap;
    private final Map<kq, ?> slaves = Maps.newHashMap();
    private final IForgeRegistry.AddCallback<I> addCallback;
    private final IForgeRegistry.ClearCallback<I> clearCallback;
    private final IForgeRegistry.CreateCallback<I> createCallback;
    private final IForgeRegistry.SubstitutionCallback<I> substitutionCallback;

    FMLControlledNamespacedRegistry(kq defaultKey, int minIdValue, int maxIdValue, Class<I> type, BiMap<kq, ? extends IForgeRegistry<?>> registries, IForgeRegistry.AddCallback<I> addCallback, IForgeRegistry.ClearCallback<I> clearCallback, IForgeRegistry.CreateCallback<I> createCallback, IForgeRegistry.SubstitutionCallback<I> substitutionCallback) {
        super((Object)defaultKey);
        this.superType = type;
        this.optionalDefaultKey = defaultKey;
        this.minId = minIdValue;
        this.maxId = maxIdValue;
        this.availabilityMap = new BitSet(Math.min(maxIdValue + 1, 65535));
        this.isDelegated = IForgeRegistryEntry.Impl.class.isAssignableFrom(type);
        this.addCallback = addCallback;
        this.clearCallback = clearCallback;
        this.createCallback = createCallback;
        this.substitutionCallback = substitutionCallback;
        if (createCallback != null) {
            createCallback.onCreate(this.slaves, registries);
        }
    }

    void validateContent(kq registryName) {
        try {
            ReflectionHelper.findMethod(BitSet.class, this.availabilityMap, new String[]{"trimToSize"}, new Class[0]).invoke((Object)this.availabilityMap, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (IForgeRegistryEntry obj : this.typeSafeIterable()) {
            int id = this.getId(obj);
            kq name = this.getNameForObject(obj);
            boolean isSubstituted = this.activeSubstitutions.containsKey((Object)name);
            if (name == null) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, doesn't yield a name.", registryName, obj, id));
            }
            if (!isSubstituted && id < 0) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s, doesn't yield an id.", registryName, obj, name));
            }
            if (id > this.maxId) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s uses the too large id %d.", registryName, obj, name, id));
            }
            if (isSubstituted) continue;
            if (this.getRaw(id) != obj) {
                throw new IllegalStateException(String.format("Registry entry for id %d, name %s, doesn't yield the expected %s %s.", id, name, registryName, obj));
            }
            if (this.getRaw(name) != obj) {
                throw new IllegalStateException(String.format("Registry entry for name %s, id %d, doesn't yield the expected %s %s.", name, id, registryName, obj));
            }
            if (this.getId(name) == id) continue;
            throw new IllegalStateException(String.format("Registry entry for name %s doesn't yield the expected id %d.", name, id));
        }
    }

    void set(FMLControlledNamespacedRegistry<I> otherRegistry) {
        if (this.superType != otherRegistry.superType) {
            throw new IllegalArgumentException("incompatible registry");
        }
        HashMap slaves = Maps.newHashMap(this.slaves);
        slaves.put(PersistentRegistryManager.SUBSTITUTION_ORIGINALS, this.substitutionOriginals);
        if (this.clearCallback != null) {
            this.clearCallback.onClear(this, slaves);
        }
        this.optionalDefaultKey = otherRegistry.optionalDefaultKey;
        this.maxId = otherRegistry.maxId;
        this.minId = otherRegistry.minId;
        this.aliases.clear();
        this.aliases.putAll(otherRegistry.aliases);
        this.persistentSubstitutions.clear();
        this.persistentSubstitutions.putAll(otherRegistry.getPersistentSubstitutions());
        this.activeSubstitutions.clear();
        this.dummiedLocations.clear();
        this.dummiedLocations.addAll(otherRegistry.dummiedLocations);
        this.a.a();
        this.c.clear();
        for (IForgeRegistryEntry thing : otherRegistry.typeSafeIterable()) {
            this.addObjectRaw(otherRegistry.getId(thing), otherRegistry.getNameForObject(thing), thing);
        }
        for (kq resloc : otherRegistry.activeSubstitutions.keySet()) {
            this.activateSubstitution(resloc);
        }
        this.substitutionOriginals.clear();
        this.substitutionOriginals.putAll(otherRegistry.substitutionOriginals);
    }

    @Deprecated
    public void register(int id, kq name, I thing) {
        this.add(id, name, thing);
    }

    @Deprecated
    public void putObject(kq name, I thing) {
        if (name == null) {
            throw new NullPointerException("Can't use a null-name for the registry.");
        }
        if (thing == null) {
            throw new NullPointerException("Can't add null-object to the registry.");
        }
        kq existingName = this.getNameForObject(thing);
        if (existingName == null) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), not resolvable", name, thing);
        } else if (existingName.equals((Object)name)) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), already added", name, thing);
        } else {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), adding alias to %s instead", name, thing, existingName);
            this.addAlias(name, existingName);
        }
    }

    public I getObject(kq name) {
        I object = this.getRaw(name);
        return object == null ? this.optionalDefaultObject : object;
    }

    public I getObjectById(int id) {
        I object = this.getRaw(id);
        return object == null ? this.optionalDefaultObject : object;
    }

    public int getId(I thing) {
        return this.getIDForObjectBypass(thing);
    }

    public I getRaw(int id) {
        return (I)((IForgeRegistryEntry)super.a(id));
    }

    private I getRaw(kq name) {
        IForgeRegistryEntry ret = (IForgeRegistryEntry)super.c((Object)name);
        if (ret == null && (name = this.aliases.get(name)) != null) {
            return this.getRaw(name);
        }
        return (I)ret;
    }

    @Override
    public boolean containsKey(kq name) {
        boolean ret = super.d((Object)name);
        if (!ret && (name = this.aliases.get(name)) != null) {
            return this.containsKey(name);
        }
        return ret;
    }

    public int getId(kq itemName) {
        I obj = this.getRaw(itemName);
        if (obj == null) {
            return -1;
        }
        return this.getId(obj);
    }

    public Iterable<I> typeSafeIterable() {
        return GenericIterableFactory.newCastingIterable(super.iterator(), this.superType);
    }

    public void serializeIds(Map<kq, Integer> idMapping) {
        for (IForgeRegistryEntry thing : this.typeSafeIterable()) {
            idMapping.put(this.getNameForObject(thing), this.getId(thing));
        }
    }

    public void serializeAliases(Map<kq, kq> map) {
        map.putAll(this.aliases);
    }

    public void serializeSubstitutions(Set<kq> set) {
        set.addAll(this.activeSubstitutions.keySet());
    }

    public void serializeDummied(Set<kq> set) {
        set.addAll(this.dummiedLocations);
    }

    public boolean isDummied(kq key) {
        return this.dummiedLocations.contains(key);
    }

    int add(int id, kq name, I thing) {
        if (name == null) {
            throw new NullPointerException(String.format("Can't use a null-name for the registry, object %s.", thing));
        }
        if (thing == null) {
            throw new NullPointerException(String.format("Can't add null-object to the registry, name %s.", name));
        }
        if (this.optionalDefaultKey != null && this.optionalDefaultKey.equals((Object)name) && this.optionalDefaultObject == null) {
            this.optionalDefaultObject = thing;
        }
        if (this.getPersistentSubstitutions().containsValue(thing)) {
            throw new IllegalArgumentException(String.format("The object %s (%s) cannot be added to the registry. It is already being used as a substitute for %s", thing.getClass(), name, this.getPersistentSubstitutions().inverse().get(thing)));
        }
        int idToUse = id;
        if (idToUse < 0 || this.availabilityMap.get(idToUse)) {
            idToUse = this.availabilityMap.nextClearBit(this.minId);
        }
        if (idToUse > this.maxId) {
            throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", idToUse));
        }
        if (this.getRaw(name) == thing) {
            FMLLog.bigWarning("The object %s has been registered twice for the same name %s.", thing, name);
            return this.getId(thing);
        }
        if (this.getRaw(name) != null) {
            throw new IllegalArgumentException(String.format("The name %s has been registered twice, for %s and %s.", name, this.getRaw(name), thing));
        }
        if (this.getId(thing) >= 0) {
            int foundId = this.getId(thing);
            I otherThing = this.getRaw(foundId);
            throw new IllegalArgumentException(String.format("The object %s{%x} has been registered twice, using the names %s and %s. (Other object at this id is %s{%x})", thing, System.identityHashCode(thing), this.getNameForObject(thing), name, otherThing, System.identityHashCode(otherThing)));
        }
        if (PersistentRegistryManager.isFrozen(this)) {
            FMLLog.bigWarning("The object %s (name %s) is being added too late.", thing, name);
        }
        if (this.activeSubstitutions.containsKey((Object)name)) {
            I oldThing = thing;
            thing = (IForgeRegistryEntry)this.activeSubstitutions.get((Object)name);
            if (DEBUG) {
                FMLLog.getLogger().log(Level.DEBUG, "Active substitution: {} {}@{} -> {}@{}", new Object[]{name, oldThing.getClass().getName(), System.identityHashCode(oldThing), thing.getClass().getName(), System.identityHashCode(thing)});
            }
        }
        this.addObjectRaw(idToUse, name, thing);
        if (this.isDelegated) {
            this.getExistingDelegate(thing).setName(name);
        }
        if (this.dummiedLocations.remove(name) && DEBUG) {
            FMLLog.fine("Registry Dummy Remove: %s", name);
        }
        if (DEBUG) {
            FMLLog.finer("Registry add: %s %d %s (req. id %d)", name, idToUse, thing, id);
        }
        return idToUse;
    }

    void markDummy(kq rl, Integer id, I thing) {
        if (DEBUG) {
            FMLLog.finer("Registry Dummy Add: %s %d -> %s", rl, id, thing);
        }
        this.dummiedLocations.add(rl);
        this.addObjectRaw(id, rl, thing);
    }

    void addAlias(kq from, kq to) {
        this.aliases.put(from, to);
        if (DEBUG) {
            FMLLog.finer("Registry alias: %s -> %s", from, to);
        }
    }

    Map<kq, Integer> getEntriesNotIn(FMLControlledNamespacedRegistry<I> registry) {
        HashMap<kq, Integer> ret = new HashMap<kq, Integer>();
        for (IForgeRegistryEntry thing : this.typeSafeIterable()) {
            if (registry.b.containsKey(thing) || registry.activeSubstitutions.containsKey((Object)this.getNameForObject(thing))) continue;
            ret.put(this.getNameForObject(thing), this.getId(thing));
        }
        return ret;
    }

    void dump(kq registryName) {
        if (!DEBUG) {
            return;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (IForgeRegistryEntry thing : this.typeSafeIterable()) {
            ids.add(this.getId(thing));
        }
        Collections.sort(ids);
        FMLLog.finer("Registry Name : {}", registryName);
        Iterator<Object> iterator = ids.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            I thing = this.getRaw(id);
            FMLLog.finer("Registry: %d %s %s", id, this.getNameForObject(thing), thing);
        }
    }

    private void addObjectRaw(int id, kq name, I thing) {
        if (name == null) {
            throw new NullPointerException("The name to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (thing == null) {
            throw new NullPointerException("The object to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (!this.superType.isInstance(thing)) {
            throw new IllegalArgumentException("The object to be added to the registry is not of the right type. Reflection/ASM hackery? Registry bug?");
        }
        this.a.a(thing, id);
        super.a((Object)name, thing);
        this.availabilityMap.set(id);
        if (this.addCallback != null) {
            this.addCallback.onAdd(thing, id, this.slaves);
        }
    }

    public I getDefaultValue() {
        return this.optionalDefaultObject;
    }

    public RegistryDelegate<I> getDelegate(I thing, Class<I> clazz) {
        return new RegistryDelegate.Delegate<I>(thing, clazz);
    }

    private RegistryDelegate.Delegate<I> getExistingDelegate(I thing) {
        if (this.isDelegated) {
            return (RegistryDelegate.Delegate)((IForgeRegistryEntry.Impl)thing).delegate;
        }
        return null;
    }

    I activateSubstitution(kq nameToReplace) {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace)) {
            I original = this.getRaw(nameToReplace);
            IForgeRegistryEntry sub = (IForgeRegistryEntry)this.getPersistentSubstitutions().get((Object)nameToReplace);
            this.getExistingDelegate(original).changeReference(sub);
            this.activeSubstitutions.put((Object)nameToReplace, (Object)sub);
            int id = this.getIDForObjectBypass(original);
            this.addObjectRaw(id, nameToReplace, sub);
            this.substitutionOriginals.put((Object)nameToReplace, original);
            if (this.substitutionCallback != null) {
                this.substitutionCallback.onSubstituteActivated(this.slaves, original, sub, nameToReplace);
            }
            return original;
        }
        return null;
    }

    void addSubstitutionAlias(String modId, kq nameToReplace, I replacement) throws ExistingSubstitutionException {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace) || this.getPersistentSubstitutions().containsValue(replacement)) {
            FMLLog.severe("The substitution of %s has already occurred. You cannot duplicate substitutions", nameToReplace);
            throw new ExistingSubstitutionException(nameToReplace, replacement);
        }
        I original = this.getRaw(nameToReplace);
        if (original == null) {
            throw new NullPointerException("The replacement target is not present. This won't work");
        }
        if (!original.getClass().isAssignableFrom(replacement.getClass())) {
            FMLLog.severe("The substitute %s for %s (type %s) is type incompatible. This won't work", replacement.getClass().getName(), nameToReplace, original.getClass().getName());
            throw new IncompatibleSubstitutionException(nameToReplace, replacement, original);
        }
        int existingId = this.getId(replacement);
        if (existingId != -1) {
            FMLLog.severe("The substitute %s for %s is registered into the game independently. This won't work", replacement.getClass().getName(), nameToReplace);
            throw new IllegalArgumentException("The object substitution is already registered. This won't work");
        }
        FMLLog.log(Level.DEBUG, "Adding substitution %s with %s (name %s)", original, replacement, nameToReplace);
        this.getPersistentSubstitutions().put((Object)nameToReplace, replacement);
    }

    BiMap<kq, I> getPersistentSubstitutions() {
        return this.persistentSubstitutions;
    }

    public void a() {
        if (this.optionalDefaultKey != null) {
            Validate.notNull(this.optionalDefaultObject);
        }
    }

    @Override
    public Iterator<I> iterator() {
        return Iterators.concat((Iterator)super.iterator(), this.getPersistentSubstitutions().values().iterator());
    }

    FMLControlledNamespacedRegistry<I> makeShallowCopy(BiMap<kq, ? extends IForgeRegistry<?>> registries) {
        return new FMLControlledNamespacedRegistry<I>(this.optionalDefaultKey, this.minId, this.maxId, this.superType, registries, this.addCallback, this.clearCallback, this.createCallback, this.substitutionCallback);
    }

    void resetSubstitutionDelegates() {
        if (!this.isDelegated) {
            return;
        }
        for (IForgeRegistryEntry obj : this.typeSafeIterable()) {
            RegistryDelegate.Delegate<IForgeRegistryEntry> delegate = this.getExistingDelegate(obj);
            delegate.changeReference(obj);
        }
    }

    public <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> asType(Class<? extends T> type) {
        return this;
    }

    public void serializeBlockList(Set<Integer> blocked) {
        blocked.addAll(this.blockedIds);
    }

    public Set<? extends kq> getActiveSubstitutions() {
        return this.activeSubstitutions.keySet();
    }

    public void loadAliases(Map<kq, kq> aliases) {
        for (Map.Entry<kq, kq> alias : aliases.entrySet()) {
            this.addAlias(alias.getKey(), alias.getValue());
        }
    }

    public void loadSubstitutions(Set<kq> substitutions) {
        for (kq rl : substitutions) {
            this.activateSubstitution(rl);
        }
    }

    public void loadBlocked(Set<Integer> blocked) {
        for (Integer id : blocked) {
            this.blockedIds.add(id);
            this.availabilityMap.set(id);
        }
    }

    public void loadDummied(Set<kq> dummied) {
        if (DEBUG && dummied.size() > 0) {
            FMLLog.fine("Registry Dummy Load: [%s]", Joiner.on((String)", ").join(dummied));
        }
        this.dummiedLocations.addAll(dummied);
    }

    public void loadIds(Map<kq, Integer> ids, Map<kq, Integer> missingIds, Map<kq, Integer[]> remappedIds, FMLControlledNamespacedRegistry<I> currentRegistry, kq registryName) {
        for (Map.Entry<kq, Integer> entry : ids.entrySet()) {
            Object obj;
            kq itemName = entry.getKey();
            int newId = entry.getValue();
            int currId = currentRegistry.getId(itemName);
            if (currId == -1) {
                FMLLog.info("Found a missing id from the world %s", itemName);
                missingIds.put(entry.getKey(), newId);
                continue;
            }
            if (currId != newId) {
                FMLLog.fine("Fixed %s id mismatch %s: %d (init) -> %d (map).", registryName, itemName, currId, newId);
                remappedIds.put(itemName, new Integer[]{currId, newId});
            }
            I sub = obj = super.getRaw(itemName);
            if (currentRegistry.substitutionOriginals.containsKey((Object)itemName)) {
                obj = (IForgeRegistryEntry)currentRegistry.substitutionOriginals.get((Object)itemName);
            }
            this.add(newId, itemName, obj);
            if (!currentRegistry.substitutionOriginals.containsKey((Object)itemName) || this.substitutionCallback == null) continue;
            this.substitutionCallback.onSubstituteActivated(this.slaves, sub, obj, itemName);
        }
    }

    public void blockId(int id) {
        this.blockedIds.add(id);
    }

    public void notifyCallbacks() {
        if (this.addCallback == null) {
            return;
        }
        for (IForgeRegistryEntry i : this.a) {
            this.addCallback.onAdd(i, this.a.c((Object)i), this.slaves);
        }
    }

    public kq getNameForObject(I p_177774_1_) {
        kq rl = (kq)super.getNameForObjectBypass(p_177774_1_);
        if (rl == null) {
            rl = (kq)this.activeSubstitutions.inverse().get(p_177774_1_);
        }
        return rl;
    }

    @Override
    public Class<I> getRegistrySuperType() {
        return this.superType;
    }

    @Override
    public void register(I value) {
        kq key = value.getRegistryName();
        if (key == null) {
            FMLLog.severe("Attempted to register a entry with a null name: %s", value);
            throw new NullPointerException(String.format("Attempted to register a entry with a null name: %s", value));
        }
        this.add(-1, key, value);
    }

    @Override
    public void registerAll(I ... values) {
        for (I value : values) {
            this.register(value);
        }
    }

    @Override
    public boolean containsValue(I value) {
        return this.getKey(value) != null;
    }

    @Override
    public I getValue(kq key) {
        return this.getObject(key);
    }

    @Override
    public kq getKey(I value) {
        return this.getNameForObject(value);
    }

    @Override
    public Set<kq> getKeys() {
        return super.c();
    }

    @Override
    public List<I> getValues() {
        return Lists.newArrayList(this.iterator());
    }

    @Override
    public Set<Map.Entry<kq, I>> getEntries() {
        return Sets.newHashSet((Iterator)new Iterator<Map.Entry<kq, I>>(){
            Iterator<I> itr;
            {
                this.itr = FMLControlledNamespacedRegistry.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public Map.Entry<kq, I> next() {
                final IForgeRegistryEntry value = (IForgeRegistryEntry)this.itr.next();
                final kq key = FMLControlledNamespacedRegistry.this.getKey(value);
                return new Map.Entry<kq, I>(){

                    @Override
                    public kq getKey() {
                        return key;
                    }

                    @Override
                    public I getValue() {
                        return value;
                    }

                    @Override
                    public I setValue(I value2) {
                        throw new UnsupportedOperationException("Setting the value in an iterator is not allowed");
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This is a READ ONLY view of this registry.");
            }
        });
    }

    @Override
    public <T> T getSlaveMap(kq slaveMapName, Class<T> type) {
        return (T)this.slaves.get(slaveMapName);
    }

    RegistryEvent.Register<I> buildRegistryRegisterEvent(kq location) {
        return new RegistryEvent.Register(location, this);
    }
}

