/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.BedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;

public class BedBlock
extends HorizontalBlock
implements ITileEntityProvider {
    public static final EnumProperty<BedPart> field_176472_a = BlockStateProperties.field_208139_an;
    public static final BooleanProperty field_176471_b = BlockStateProperties.field_208192_s;
    protected static final VoxelShape field_220176_c = Block.func_208617_a(0.0, 3.0, 0.0, 16.0, 9.0, 16.0);
    protected static final VoxelShape field_220177_d = Block.func_208617_a(0.0, 0.0, 0.0, 3.0, 3.0, 3.0);
    protected static final VoxelShape field_220178_e = Block.func_208617_a(0.0, 0.0, 13.0, 3.0, 3.0, 16.0);
    protected static final VoxelShape field_220179_f = Block.func_208617_a(13.0, 0.0, 0.0, 16.0, 3.0, 3.0);
    protected static final VoxelShape field_220180_g = Block.func_208617_a(13.0, 0.0, 13.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape field_220181_h = VoxelShapes.func_216384_a(field_220176_c, field_220177_d, field_220179_f);
    protected static final VoxelShape field_220182_i = VoxelShapes.func_216384_a(field_220176_c, field_220178_e, field_220180_g);
    protected static final VoxelShape field_220183_j = VoxelShapes.func_216384_a(field_220176_c, field_220177_d, field_220178_e);
    protected static final VoxelShape field_220184_k = VoxelShapes.func_216384_a(field_220176_c, field_220179_f, field_220180_g);
    private final DyeColor field_196352_y;

    public BedBlock(DyeColor dyeColor, Block.Properties properties) {
        super(properties);
        this.field_196352_y = dyeColor;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176472_a, BedPart.FOOT)).func_206870_a(field_176471_b, false));
    }

    @Override
    public MaterialColor func_180659_g(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        if (blockState.func_177229_b(field_176472_a) == BedPart.FOOT) {
            return this.field_196352_y.func_196055_e();
        }
        return MaterialColor.field_151659_e;
    }

    @Override
    public boolean func_220051_a(BlockState blockState2, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        BlockState blockState2;
        if (world.field_72995_K) {
            return true;
        }
        if (blockState2.func_177229_b(field_176472_a) != BedPart.HEAD && (blockState2 = world.func_180495_p(blockPos = blockPos.func_177972_a(blockState2.func_177229_b(field_185512_D)))).func_177230_c() != this) {
            return true;
        }
        if (!world.field_73011_w.func_76567_e() || world.func_180494_b(blockPos) == Biomes.field_76778_j) {
            world.func_217377_a(blockPos, false);
            BlockPos blockPos2 = blockPos.func_177972_a(blockState2.func_177229_b(field_185512_D).func_176734_d());
            if (world.func_180495_p(blockPos2).func_177230_c() == this) {
                world.func_217377_a(blockPos2, false);
            }
            world.func_217401_a(null, DamageSource.func_199683_a(), (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
            return true;
        }
        if (blockState2.func_177229_b(field_176471_b).booleanValue()) {
            playerEntity.func_146105_b(new TranslationTextComponent("block.minecraft.bed.occupied", new Object[0]), true);
            return true;
        }
        playerEntity.func_213819_a(blockPos).ifLeft(sleepResult -> {
            if (sleepResult != null) {
                playerEntity.func_146105_b(sleepResult.func_221259_a(), true);
            }
        });
        return true;
    }

    @Override
    public void func_180658_a(World world, BlockPos blockPos, Entity entity, float f) {
        super.func_180658_a(world, blockPos, entity, f * 0.5f);
    }

    @Override
    public void func_176216_a(IBlockReader iBlockReader, Entity entity) {
        if (entity.func_70093_af()) {
            super.func_176216_a(iBlockReader, entity);
        } else {
            Vec3d vec3d = entity.func_213322_ci();
            if (vec3d.field_72448_b < 0.0) {
                double d = entity instanceof LivingEntity ? 1.0 : 0.8;
                entity.func_213293_j(vec3d.field_72450_a, -vec3d.field_72448_b * (double)0.66f * d, vec3d.field_72449_c);
            }
        }
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == BedBlock.func_208070_a(blockState.func_177229_b(field_176472_a), blockState.func_177229_b(field_185512_D))) {
            if (blockState2.func_177230_c() == this && blockState2.func_177229_b(field_176472_a) != blockState.func_177229_b(field_176472_a)) {
                return (BlockState)blockState.func_206870_a(field_176471_b, blockState2.func_177229_b(field_176471_b));
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    private static Direction func_208070_a(BedPart bedPart, Direction direction) {
        return bedPart == BedPart.FOOT ? direction : direction.func_176734_d();
    }

    @Override
    public void func_180657_a(World world, PlayerEntity playerEntity, BlockPos blockPos, BlockState blockState, @Nullable TileEntity tileEntity, ItemStack itemStack) {
        super.func_180657_a(world, playerEntity, blockPos, Blocks.field_150350_a.func_176223_P(), tileEntity, itemStack);
    }

    @Override
    public void func_176208_a(World world2, BlockPos blockPos, BlockState blockState, PlayerEntity playerEntity2) {
        World world2;
        BedPart bedPart = blockState.func_177229_b(field_176472_a);
        BlockPos \u26032 = blockPos.func_177972_a(BedBlock.func_208070_a(bedPart, blockState.func_177229_b(field_185512_D)));
        BlockState \u26033 = world2.func_180495_p(\u26032);
        if (\u26033.func_177230_c() == this && \u26033.func_177229_b(field_176472_a) != bedPart) {
            PlayerEntity playerEntity2;
            world2.func_180501_a(\u26032, Blocks.field_150350_a.func_176223_P(), 35);
            world2.func_217378_a(playerEntity2, 2001, \u26032, Block.func_196246_j(\u26033));
            if (!world2.field_72995_K && !playerEntity2.func_184812_l_()) {
                ItemStack itemStack = playerEntity2.func_184614_ca();
                BedBlock.func_220054_a(blockState, world2, blockPos, null, playerEntity2, itemStack);
                BedBlock.func_220054_a(\u26033, world2, \u26032, null, playerEntity2, itemStack);
            }
            playerEntity2.func_71029_a(Stats.field_188065_ae.func_199076_b(this));
        }
        super.func_176208_a(world2, blockPos, blockState, playerEntity2);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        Direction direction = blockItemUseContext.func_195992_f();
        BlockPos \u26032 = blockItemUseContext.func_195995_a();
        BlockPos \u26033 = \u26032.func_177972_a(direction);
        if (blockItemUseContext.func_195991_k().func_180495_p(\u26033).func_196953_a(blockItemUseContext)) {
            return (BlockState)this.func_176223_P().func_206870_a(field_185512_D, direction);
        }
        return null;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        Direction direction = blockState.func_177229_b(field_185512_D);
        \u2603 = blockState.func_177229_b(field_176472_a) == BedPart.HEAD ? direction : direction.func_176734_d();
        switch (\u2603) {
            case NORTH: {
                return field_220181_h;
            }
            case SOUTH: {
                return field_220182_i;
            }
            case WEST: {
                return field_220183_j;
            }
        }
        return field_220184_k;
    }

    public static Optional<Vec3d> func_220172_a(EntityType<?> entityType, IWorldReader iWorldReader, BlockPos blockPos, int n) {
        Direction direction = iWorldReader.func_180495_p(blockPos).func_177229_b(field_185512_D);
        int \u26032 = blockPos.func_177958_n();
        int \u26033 = blockPos.func_177956_o();
        int \u26034 = blockPos.func_177952_p();
        for (int i = 0; i <= 1; ++i) {
            \u2603 = \u26032 - direction.func_82601_c() * i - 1;
            \u2603 = \u26034 - direction.func_82599_e() * i - 1;
            \u2603 = \u2603 + 2;
            \u2603 = \u2603 + 2;
            for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                    BlockPos blockPos2 = new BlockPos(\u2603, \u26033, \u2603);
                    Optional<Vec3d> \u26035 = BedBlock.func_220175_a(entityType, iWorldReader, blockPos2);
                    if (!\u26035.isPresent()) continue;
                    if (n > 0) {
                        --n;
                        continue;
                    }
                    return \u26035;
                }
            }
        }
        return Optional.empty();
    }

    protected static Optional<Vec3d> func_220175_a(EntityType<?> entityType, IWorldReader iWorldReader, BlockPos blockPos) {
        VoxelShape voxelShape = iWorldReader.func_180495_p(blockPos).func_196952_d(iWorldReader, blockPos);
        if (voxelShape.func_197758_c(Direction.Axis.Y) > 0.4375) {
            return Optional.empty();
        }
        BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos(blockPos);
        while (\u26032.func_177956_o() >= 0 && blockPos.func_177956_o() - \u26032.func_177956_o() <= 2 && iWorldReader.func_180495_p(\u26032).func_196952_d(iWorldReader, \u26032).func_197766_b()) {
            \u26032.func_189536_c(Direction.DOWN);
        }
        \u2603 = iWorldReader.func_180495_p(\u26032).func_196952_d(iWorldReader, \u26032);
        if (\u2603.func_197766_b()) {
            return Optional.empty();
        }
        double \u26033 = (double)\u26032.func_177956_o() + \u2603.func_197758_c(Direction.Axis.Y) + 2.0E-7;
        if ((double)blockPos.func_177956_o() - \u26033 > 2.0) {
            return Optional.empty();
        }
        float \u26034 = entityType.func_220333_h() / 2.0f;
        Vec3d \u26035 = new Vec3d((double)\u26032.func_177958_n() + 0.5, \u26033, (double)\u26032.func_177952_p() + 0.5);
        if (iWorldReader.func_217351_c(new AxisAlignedBB(\u26035.field_72450_a - (double)\u26034, \u26035.field_72448_b, \u26035.field_72449_c - (double)\u26034, \u26035.field_72450_a + (double)\u26034, \u26035.field_72448_b + (double)entityType.func_220344_i(), \u26035.field_72449_c + (double)\u26034))) {
            return Optional.of(\u26035);
        }
        return Optional.empty();
    }

    @Override
    public PushReaction func_149656_h(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_185512_D, field_176472_a, field_176471_b);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new BedTileEntity(this.field_196352_y);
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.func_180633_a(world, blockPos, blockState, livingEntity, itemStack);
        if (!world.field_72995_K) {
            BlockPos blockPos2 = blockPos.func_177972_a(blockState.func_177229_b(field_185512_D));
            world.func_180501_a(blockPos2, (BlockState)blockState.func_206870_a(field_176472_a, BedPart.HEAD), 3);
            world.func_195592_c(blockPos, Blocks.field_150350_a);
            blockState.func_196946_a(world, blockPos, 3);
        }
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

