/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import java.util.OptionalInt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class FireworkRocketEntity
extends Entity
implements IProjectile {
    private static final DataParameter<ItemStack> field_184566_a = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_187196_f);
    private static final DataParameter<OptionalInt> field_191512_b = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_218814_r);
    private static final DataParameter<Boolean> field_213895_d = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_187198_h);
    private int field_92056_a;
    private int field_92055_b;
    private LivingEntity field_191513_e;

    public FireworkRocketEntity(EntityType<? extends FireworkRocketEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184566_a, ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(field_191512_b, OptionalInt.empty());
        this.field_70180_af.func_187214_a(field_213895_d, false);
    }

    public FireworkRocketEntity(World world, double d, double d2, double d3, ItemStack itemStack) {
        super(EntityType.field_200810_x, world);
        this.field_92056_a = 0;
        this.func_70107_b(d, d2, d3);
        int n = 1;
        if (!itemStack.func_190926_b() && itemStack.func_77942_o()) {
            this.field_70180_af.func_187227_b(field_184566_a, itemStack.func_77946_l());
            n += itemStack.func_190925_c("Fireworks").func_74771_c("Flight");
        }
        this.func_213293_j(this.field_70146_Z.nextGaussian() * 0.001, 0.05, this.field_70146_Z.nextGaussian() * 0.001);
        this.field_92055_b = 10 * n + this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(7);
    }

    public FireworkRocketEntity(World world, ItemStack itemStack, LivingEntity livingEntity) {
        this(world, livingEntity.field_70165_t, livingEntity.field_70163_u, livingEntity.field_70161_v, itemStack);
        this.field_70180_af.func_187227_b(field_191512_b, OptionalInt.of(livingEntity.func_145782_y()));
        this.field_191513_e = livingEntity;
    }

    public FireworkRocketEntity(World world, ItemStack itemStack, double d, double d2, double d3, boolean bl) {
        this(world, d, d2, d3, itemStack);
        this.field_70180_af.func_187227_b(field_213895_d, bl);
    }

    @Override
    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.func_191511_j()) {
            if (this.field_191513_e == null) {
                this.field_70180_af.func_187225_a(field_191512_b).ifPresent(n -> {
                    Entity entity = this.field_70170_p.func_73045_a(n);
                    if (entity instanceof LivingEntity) {
                        this.field_191513_e = (LivingEntity)entity;
                    }
                });
            }
            if (this.field_191513_e != null) {
                if (this.field_191513_e.func_184613_cA()) {
                    Vec3d vec3d = this.field_191513_e.func_70040_Z();
                    double \u26032 = 1.5;
                    double \u26033 = 0.1;
                    \u2603 = this.field_191513_e.func_213322_ci();
                    this.field_191513_e.func_213317_d(\u2603.func_72441_c(vec3d.field_72450_a * 0.1 + (vec3d.field_72450_a * 1.5 - \u2603.field_72450_a) * 0.5, vec3d.field_72448_b * 0.1 + (vec3d.field_72448_b * 1.5 - \u2603.field_72448_b) * 0.5, vec3d.field_72449_c * 0.1 + (vec3d.field_72449_c * 1.5 - \u2603.field_72449_c) * 0.5));
                }
                this.func_70107_b(this.field_191513_e.field_70165_t, this.field_191513_e.field_70163_u, this.field_191513_e.field_70161_v);
                this.func_213317_d(this.field_191513_e.func_213322_ci());
            }
        } else {
            if (!this.func_213889_i()) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.15, 1.0, 1.15).func_72441_c(0.0, 0.04, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
        vec3d = this.func_213322_ci();
        RayTraceResult rayTraceResult = ProjectileHelper.func_221267_a(this, this.func_174813_aQ().func_216361_a(vec3d).func_186662_g(1.0), entity -> !entity.func_175149_v() && entity.func_70089_S() && entity.func_70067_L(), RayTraceContext.BlockMode.COLLIDER, true);
        if (!this.field_70145_X) {
            this.func_213892_a(rayTraceResult);
            this.field_70160_al = true;
        }
        float \u26034 = MathHelper.func_76133_a(FireworkRocketEntity.func_213296_b(vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b(vec3d.field_72450_a, vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b(vec3d.field_72448_b, \u26034) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g(0.2f, this.field_70127_C, this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g(0.2f, this.field_70126_B, this.field_70177_z);
        if (this.field_92056_a == 0 && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187631_bo, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        ++this.field_92056_a;
        if (this.field_70170_p.field_72995_K && this.field_92056_a % 2 < 2) {
            this.field_70170_p.func_195594_a(ParticleTypes.field_197629_v, this.field_70165_t, this.field_70163_u - 0.3, this.field_70161_v, this.field_70146_Z.nextGaussian() * 0.05, -this.func_213322_ci().field_72448_b * 0.5, this.field_70146_Z.nextGaussian() * 0.05);
        }
        if (!this.field_70170_p.field_72995_K && this.field_92056_a > this.field_92055_b) {
            this.func_213893_k();
        }
    }

    private void func_213893_k() {
        this.field_70170_p.func_72960_a(this, (byte)17);
        this.func_191510_k();
        this.func_70106_y();
    }

    protected void func_213892_a(RayTraceResult rayTraceResult) {
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.ENTITY && !this.field_70170_p.field_72995_K) {
            this.func_213893_k();
        } else if (this.field_70132_H) {
            BlockPos blockPos = rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK ? new BlockPos(((BlockRayTraceResult)rayTraceResult).func_216350_a()) : new BlockPos(this);
            this.field_70170_p.func_180495_p(blockPos).func_196950_a(this.field_70170_p, blockPos, this);
            if (this.func_213894_l()) {
                this.func_213893_k();
            }
        }
    }

    private boolean func_213894_l() {
        ItemStack itemStack = this.field_70180_af.func_187225_a(field_184566_a);
        CompoundNBT \u26032 = itemStack.func_190926_b() ? null : itemStack.func_179543_a("Fireworks");
        ListNBT \u26033 = \u26032 != null ? \u26032.func_150295_c("Explosions", 10) : null;
        return \u26033 != null && !\u26033.isEmpty();
    }

    private void func_191510_k() {
        float f = 0.0f;
        ItemStack \u26032 = this.field_70180_af.func_187225_a(field_184566_a);
        CompoundNBT \u26033 = \u26032.func_190926_b() ? null : \u26032.func_179543_a("Fireworks");
        ListNBT listNBT = \u2603 = \u26033 != null ? \u26033.func_150295_c("Explosions", 10) : null;
        if (\u2603 != null && !\u2603.isEmpty()) {
            f = 5.0f + (float)(\u2603.size() * 2);
        }
        if (f > 0.0f) {
            if (this.field_191513_e != null) {
                this.field_191513_e.func_70097_a(DamageSource.field_191552_t, 5.0f + (float)(\u2603.size() * 2));
            }
            double d = 5.0;
            Vec3d \u26034 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            List<LivingEntity> \u26035 = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(5.0));
            for (LivingEntity livingEntity : \u26035) {
                if (livingEntity == this.field_191513_e || this.func_70068_e(livingEntity) > 25.0) continue;
                boolean \u26037 = false;
                for (int i = 0; i < 2; ++i) {
                    Vec3d vec3d = new Vec3d(livingEntity.field_70165_t, livingEntity.field_70163_u + (double)livingEntity.func_213302_cg() * 0.5 * (double)i, livingEntity.field_70161_v);
                    BlockRayTraceResult \u26036 = this.field_70170_p.func_217299_a(new RayTraceContext(\u26034, vec3d, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, this));
                    if (((RayTraceResult)\u26036).func_216346_c() != RayTraceResult.Type.MISS) continue;
                    \u26037 = true;
                    break;
                }
                if (!\u26037) continue;
                float f2 = f * (float)Math.sqrt((5.0 - (double)this.func_70032_d(livingEntity)) / 5.0);
                livingEntity.func_70097_a(DamageSource.field_191552_t, f2);
            }
        }
    }

    private boolean func_191511_j() {
        return this.field_70180_af.func_187225_a(field_191512_b).isPresent();
    }

    public boolean func_213889_i() {
        return this.field_70180_af.func_187225_a(field_213895_d);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        compoundNBT.func_74768_a("Life", this.field_92056_a);
        compoundNBT.func_74768_a("LifeTime", this.field_92055_b);
        ItemStack itemStack = this.field_70180_af.func_187225_a(field_184566_a);
        if (!itemStack.func_190926_b()) {
            compoundNBT.func_218657_a("FireworksItem", itemStack.func_77955_b(new CompoundNBT()));
        }
        compoundNBT.func_74757_a("ShotAtAngle", this.field_70180_af.func_187225_a(field_213895_d));
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        this.field_92056_a = compoundNBT.func_74762_e("Life");
        this.field_92055_b = compoundNBT.func_74762_e("LifeTime");
        ItemStack itemStack = ItemStack.func_199557_a(compoundNBT.func_74775_l("FireworksItem"));
        if (!itemStack.func_190926_b()) {
            this.field_70180_af.func_187227_b(field_184566_a, itemStack);
        }
        if (compoundNBT.func_74764_b("ShotAtAngle")) {
            this.field_70180_af.func_187227_b(field_213895_d, compoundNBT.func_74767_n("ShotAtAngle"));
        }
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket(this);
    }

    @Override
    public void func_70186_c(double d, double d2, double d3, float f, float f2) {
        \u2603 = MathHelper.func_76133_a(d * d + d2 * d2 + d3 * d3);
        d /= (double)\u2603;
        d2 /= (double)\u2603;
        d3 /= (double)\u2603;
        d += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f2;
        d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f2;
        d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f2;
        this.func_213293_j(d *= (double)f, d2 *= (double)f, d3 *= (double)f);
    }
}

