/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class SpellcastingIllagerEntity
extends AbstractIllagerEntity {
    private static final DataParameter<Byte> field_193088_c = EntityDataManager.func_187226_a(SpellcastingIllagerEntity.class, DataSerializers.field_187191_a);
    protected int field_193087_b;
    private SpellType field_193089_bx = SpellType.NONE;

    protected SpellcastingIllagerEntity(EntityType<? extends SpellcastingIllagerEntity> entityType, World world) {
        super((EntityType<? extends AbstractIllagerEntity>)entityType, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_193088_c, (byte)0);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.field_193087_b = compoundNBT.func_74762_e("SpellTicks");
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("SpellTicks", this.field_193087_b);
    }

    public boolean func_193082_dl() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_187225_a(field_193088_c) > 0;
        }
        return this.field_193087_b > 0;
    }

    public void func_193081_a(SpellType spellType) {
        this.field_193089_bx = spellType;
        this.field_70180_af.func_187227_b(field_193088_c, (byte)spellType.field_193345_g);
    }

    protected SpellType func_193083_dm() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_193089_bx;
        }
        return SpellType.func_193337_a(this.field_70180_af.func_187225_a(field_193088_c).byteValue());
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.field_193087_b > 0) {
            --this.field_193087_b;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.func_193082_dl()) {
            SpellType spellType = this.func_193083_dm();
            double \u26032 = spellType.field_193346_h[0];
            double \u26033 = spellType.field_193346_h[1];
            double \u26034 = spellType.field_193346_h[2];
            float \u26035 = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)this.field_70173_aa * 0.6662f) * 0.25f;
            float \u26036 = MathHelper.func_76134_b(\u26035);
            float \u26037 = MathHelper.func_76126_a(\u26035);
            this.field_70170_p.func_195594_a(ParticleTypes.field_197625_r, this.field_70165_t + (double)\u26036 * 0.6, this.field_70163_u + 1.8, this.field_70161_v + (double)\u26037 * 0.6, \u26032, \u26033, \u26034);
            this.field_70170_p.func_195594_a(ParticleTypes.field_197625_r, this.field_70165_t - (double)\u26036 * 0.6, this.field_70163_u + 1.8, this.field_70161_v - (double)\u26037 * 0.6, \u26032, \u26033, \u26034);
        }
    }

    protected int func_193085_dn() {
        return this.field_193087_b;
    }

    protected abstract SoundEvent func_193086_dk();

    public static enum SpellType {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_VEX(1, 0.7, 0.7, 0.8),
        FANGS(2, 0.4, 0.3, 0.35),
        WOLOLO(3, 0.7, 0.5, 0.2),
        DISAPPEAR(4, 0.3, 0.3, 0.8),
        BLINDNESS(5, 0.1, 0.1, 0.2);

        private final int field_193345_g;
        private final double[] field_193346_h;

        private SpellType(int n2, double d, double d2, double d3) {
            this.field_193345_g = n2;
            this.field_193346_h = new double[]{d, d2, d3};
        }

        public static SpellType func_193337_a(int n) {
            for (SpellType spellType : SpellType.values()) {
                if (n != spellType.field_193345_g) continue;
                return spellType;
            }
            return NONE;
        }
    }

    public abstract class UseSpellGoal
    extends Goal {
        protected int field_193321_c;
        protected int field_193322_d;

        protected UseSpellGoal() {
        }

        @Override
        public boolean func_75250_a() {
            LivingEntity livingEntity = SpellcastingIllagerEntity.this.func_70638_az();
            if (livingEntity == null || !livingEntity.func_70089_S()) {
                return false;
            }
            if (SpellcastingIllagerEntity.this.func_193082_dl()) {
                return false;
            }
            return SpellcastingIllagerEntity.this.field_70173_aa >= this.field_193322_d;
        }

        @Override
        public boolean func_75253_b() {
            LivingEntity livingEntity = SpellcastingIllagerEntity.this.func_70638_az();
            return livingEntity != null && livingEntity.func_70089_S() && this.field_193321_c > 0;
        }

        @Override
        public void func_75249_e() {
            this.field_193321_c = this.func_190867_m();
            SpellcastingIllagerEntity.this.field_193087_b = this.func_190869_f();
            this.field_193322_d = SpellcastingIllagerEntity.this.field_70173_aa + this.func_190872_i();
            SoundEvent soundEvent = this.func_190871_k();
            if (soundEvent != null) {
                SpellcastingIllagerEntity.this.func_184185_a(soundEvent, 1.0f, 1.0f);
            }
            SpellcastingIllagerEntity.this.func_193081_a(this.func_193320_l());
        }

        @Override
        public void func_75246_d() {
            --this.field_193321_c;
            if (this.field_193321_c == 0) {
                this.func_190868_j();
                SpellcastingIllagerEntity.this.func_184185_a(SpellcastingIllagerEntity.this.func_193086_dk(), 1.0f, 1.0f);
            }
        }

        protected abstract void func_190868_j();

        protected int func_190867_m() {
            return 20;
        }

        protected abstract int func_190869_f();

        protected abstract int func_190872_i();

        @Nullable
        protected abstract SoundEvent func_190871_k();

        protected abstract SpellType func_193320_l();
    }

    public class CastingASpellGoal
    extends Goal {
        public CastingASpellGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            return SpellcastingIllagerEntity.this.func_193085_dn() > 0;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            SpellcastingIllagerEntity.this.field_70699_by.func_75499_g();
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            SpellcastingIllagerEntity.this.func_193081_a(SpellType.NONE);
        }

        @Override
        public void func_75246_d() {
            if (SpellcastingIllagerEntity.this.func_70638_az() != null) {
                SpellcastingIllagerEntity.this.func_70671_ap().func_75651_a(SpellcastingIllagerEntity.this.func_70638_az(), SpellcastingIllagerEntity.this.func_184649_cE(), SpellcastingIllagerEntity.this.func_70646_bf());
            }
        }
    }
}

