/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTables;

public class SheepEntity
extends AnimalEntity {
    private static final DataParameter<Byte> field_184774_bv = EntityDataManager.func_187226_a(SheepEntity.class, DataSerializers.field_187191_a);
    private static final Map<DyeColor, IItemProvider> field_200206_bz = Util.func_200696_a(Maps.newEnumMap(DyeColor.class), enumMap -> {
        enumMap.put(DyeColor.WHITE, Blocks.field_196556_aL);
        enumMap.put(DyeColor.ORANGE, Blocks.field_196557_aM);
        enumMap.put(DyeColor.MAGENTA, Blocks.field_196558_aN);
        enumMap.put(DyeColor.LIGHT_BLUE, Blocks.field_196559_aO);
        enumMap.put(DyeColor.YELLOW, Blocks.field_196560_aP);
        enumMap.put(DyeColor.LIME, Blocks.field_196561_aQ);
        enumMap.put(DyeColor.PINK, Blocks.field_196562_aR);
        enumMap.put(DyeColor.GRAY, Blocks.field_196563_aS);
        enumMap.put(DyeColor.LIGHT_GRAY, Blocks.field_196564_aT);
        enumMap.put(DyeColor.CYAN, Blocks.field_196565_aU);
        enumMap.put(DyeColor.PURPLE, Blocks.field_196566_aV);
        enumMap.put(DyeColor.BLUE, Blocks.field_196567_aW);
        enumMap.put(DyeColor.BROWN, Blocks.field_196568_aX);
        enumMap.put(DyeColor.GREEN, Blocks.field_196569_aY);
        enumMap.put(DyeColor.RED, Blocks.field_196570_aZ);
        enumMap.put(DyeColor.BLACK, Blocks.field_196602_ba);
    });
    private static final Map<DyeColor, float[]> field_175514_bm = Maps.newEnumMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(dyeColor -> dyeColor, SheepEntity::func_192020_c)));
    private int field_70899_e;
    private EatGrassGoal field_146087_bs;

    private static float[] func_192020_c(DyeColor dyeColor) {
        if (dyeColor == DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] fArray = dyeColor.func_193349_f();
        float \u26032 = 0.75f;
        return new float[]{fArray[0] * 0.75f, fArray[1] * 0.75f, fArray[2] * 0.75f};
    }

    public SheepEntity(EntityType<? extends SheepEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
    }

    @Override
    protected void func_184651_r() {
        this.field_146087_bs = new EatGrassGoal(this);
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, new PanicGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(2, new BreedGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a(Items.field_151015_O), false));
        this.field_70714_bg.func_75776_a(4, new FollowParentGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(5, this.field_146087_bs);
        this.field_70714_bg.func_75776_a(6, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, new LookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
    }

    @Override
    protected void func_70619_bc() {
        this.field_70899_e = this.field_146087_bs.func_151499_f();
        super.func_70619_bc();
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70899_e = Math.max(0, this.field_70899_e - 1);
        }
        super.func_70636_d();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184774_bv, (byte)0);
    }

    @Override
    public ResourceLocation func_184647_J() {
        if (this.func_70892_o()) {
            return this.func_200600_R().func_220348_g();
        }
        switch (this.func_175509_cj()) {
            default: {
                return LootTables.field_186404_L;
            }
            case ORANGE: {
                return LootTables.field_186405_M;
            }
            case MAGENTA: {
                return LootTables.field_186406_N;
            }
            case LIGHT_BLUE: {
                return LootTables.field_186407_O;
            }
            case YELLOW: {
                return LootTables.field_186408_P;
            }
            case LIME: {
                return LootTables.field_186409_Q;
            }
            case PINK: {
                return LootTables.field_186410_R;
            }
            case GRAY: {
                return LootTables.field_186411_S;
            }
            case LIGHT_GRAY: {
                return LootTables.field_197738_Y;
            }
            case CYAN: {
                return LootTables.field_186413_U;
            }
            case PURPLE: {
                return LootTables.field_186414_V;
            }
            case BLUE: {
                return LootTables.field_186415_W;
            }
            case BROWN: {
                return LootTables.field_186416_X;
            }
            case GREEN: {
                return LootTables.field_186417_Y;
            }
            case RED: {
                return LootTables.field_186418_Z;
            }
            case BLACK: 
        }
        return LootTables.field_186376_aa;
    }

    @Override
    public boolean func_184645_a(PlayerEntity playerEntity2, Hand hand) {
        ItemStack itemStack = playerEntity2.func_184586_b(hand);
        if (itemStack.func_77973_b() == Items.field_151097_aZ && !this.func_70892_o() && !this.func_70631_g_()) {
            this.func_213612_dV();
            if (!this.field_70170_p.field_72995_K) {
                itemStack.func_222118_a(1, playerEntity2, playerEntity -> playerEntity.func_213334_d(hand));
            }
        }
        return super.func_184645_a(playerEntity2, hand);
    }

    public void func_213612_dV() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70893_e(true);
            int n = 1 + this.field_70146_Z.nextInt(3);
            for (\u2603 = 0; \u2603 < n; ++\u2603) {
                ItemEntity itemEntity = this.func_199702_a(field_200206_bz.get(this.func_175509_cj()), 1);
                if (itemEntity == null) continue;
                itemEntity.func_213317_d(itemEntity.func_213322_ci().func_72441_c((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f, this.field_70146_Z.nextFloat() * 0.05f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f));
            }
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74757_a("Sheared", this.func_70892_o());
        compoundNBT.func_74774_a("Color", (byte)this.func_175509_cj().func_196059_a());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_70893_e(compoundNBT.func_74767_n("Sheared"));
        this.func_175512_b(DyeColor.func_196056_a(compoundNBT.func_74771_c("Color")));
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187761_eI;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public DyeColor func_175509_cj() {
        return DyeColor.func_196056_a(this.field_70180_af.func_187225_a(field_184774_bv) & 0xF);
    }

    public void func_175512_b(DyeColor dyeColor) {
        byte by = this.field_70180_af.func_187225_a(field_184774_bv);
        this.field_70180_af.func_187227_b(field_184774_bv, (byte)(by & 0xF0 | dyeColor.func_196059_a() & 0xF));
    }

    public boolean func_70892_o() {
        return (this.field_70180_af.func_187225_a(field_184774_bv) & 0x10) != 0;
    }

    public void func_70893_e(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184774_bv);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184774_bv, (byte)(by | 0x10));
        } else {
            this.field_70180_af.func_187227_b(field_184774_bv, (byte)(by & 0xFFFFFFEF));
        }
    }

    public static DyeColor func_175510_a(Random random) {
        int n = random.nextInt(100);
        if (n < 5) {
            return DyeColor.BLACK;
        }
        if (n < 10) {
            return DyeColor.GRAY;
        }
        if (n < 15) {
            return DyeColor.LIGHT_GRAY;
        }
        if (n < 18) {
            return DyeColor.BROWN;
        }
        if (random.nextInt(500) == 0) {
            return DyeColor.PINK;
        }
        return DyeColor.WHITE;
    }

    @Override
    public SheepEntity func_90011_a(AgeableEntity ageableEntity) {
        SheepEntity sheepEntity = (SheepEntity)ageableEntity;
        \u2603 = EntityType.field_200737_ac.func_200721_a(this.field_70170_p);
        \u2603.func_175512_b(this.func_175511_a(this, sheepEntity));
        return \u2603;
    }

    @Override
    public void func_70615_aA() {
        this.func_70893_e(false);
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        ILivingEntityData iLivingEntityData2 = super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData2, compoundNBT);
        this.func_175512_b(SheepEntity.func_175510_a(iWorld.func_201674_k()));
        return iLivingEntityData2;
    }

    private DyeColor func_175511_a(AnimalEntity animalEntity, AnimalEntity animalEntity2) {
        DyeColor dyeColor = ((SheepEntity)animalEntity).func_175509_cj();
        \u2603 = ((SheepEntity)animalEntity2).func_175509_cj();
        CraftingInventory \u26032 = SheepEntity.func_213611_a(dyeColor, \u2603);
        return this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, \u26032, this.field_70170_p).map(iCraftingRecipe -> iCraftingRecipe.func_77572_b(\u26032)).map(ItemStack::func_77973_b).filter(DyeItem.class::isInstance).map(DyeItem.class::cast).map(DyeItem::func_195962_g).orElseGet(() -> this.field_70170_p.field_73012_v.nextBoolean() ? dyeColor : \u2603);
    }

    private static CraftingInventory func_213611_a(DyeColor dyeColor, DyeColor dyeColor2) {
        CraftingInventory craftingInventory = new CraftingInventory(new Container(null, -1){

            @Override
            public boolean func_75145_c(PlayerEntity playerEntity) {
                return false;
            }
        }, 2, 1);
        craftingInventory.func_70299_a(0, new ItemStack(DyeItem.func_195961_a(dyeColor)));
        craftingInventory.func_70299_a(1, new ItemStack(DyeItem.func_195961_a(dyeColor2)));
        return craftingInventory;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return 0.95f * entitySize.field_220316_b;
    }

    @Override
    public /* synthetic */ AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return this.func_90011_a(ageableEntity);
    }
}

