/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.profiler;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.profiler.FilledProfileResult;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IResultableProfiler;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Profiler
implements IResultableProfiler {
    private static final long field_219907_a = Duration.ofMillis(100L).toNanos();
    private static final Logger field_151234_b = LogManager.getLogger();
    private final List<String> field_76325_b = Lists.newArrayList();
    private final LongList field_76326_c = new LongArrayList();
    private final Object2LongMap<String> field_76324_e = new Object2LongOpenHashMap();
    private final Object2LongMap<String> field_223510_f = new Object2LongOpenHashMap();
    private final IntSupplier field_219912_f;
    private final long field_219913_g;
    private final int field_219914_h;
    private String field_219915_i = "";
    private boolean field_219916_j;

    public Profiler(long l, IntSupplier intSupplier) {
        this.field_219913_g = l;
        this.field_219914_h = intSupplier.getAsInt();
        this.field_219912_f = intSupplier;
    }

    @Override
    public void func_219894_a() {
        if (this.field_219916_j) {
            field_151234_b.error("Profiler tick already started - missing endTick()?");
            return;
        }
        this.field_219916_j = true;
        this.field_219915_i = "";
        this.field_76325_b.clear();
        this.func_76320_a("root");
    }

    @Override
    public void func_219897_b() {
        if (!this.field_219916_j) {
            field_151234_b.error("Profiler tick already ended - missing startTick()?");
            return;
        }
        this.func_76319_b();
        this.field_219916_j = false;
        if (!this.field_219915_i.isEmpty()) {
            field_151234_b.error("Profiler tick ended before path was fully popped (remainder: '{}'). Mismatched push/pop?", new org.apache.logging.log4j.util.Supplier[]{() -> IProfileResult.func_225434_b(this.field_219915_i)});
        }
    }

    @Override
    public void func_76320_a(String string) {
        if (!this.field_219916_j) {
            field_151234_b.error("Cannot push '{}' to profiler if profiler tick hasn't started - missing startTick()?", (Object)string);
            return;
        }
        if (!this.field_219915_i.isEmpty()) {
            this.field_219915_i = this.field_219915_i + '\u001e';
        }
        this.field_219915_i = this.field_219915_i + string;
        this.field_76325_b.add(this.field_219915_i);
        this.field_76326_c.add(Util.func_211178_c());
    }

    @Override
    public void func_194340_a(Supplier<String> supplier) {
        this.func_76320_a(supplier.get());
    }

    @Override
    public void func_76319_b() {
        if (!this.field_219916_j) {
            field_151234_b.error("Cannot pop from profiler if profiler tick hasn't started - missing startTick()?");
            return;
        }
        if (this.field_76326_c.isEmpty()) {
            field_151234_b.error("Tried to pop one too many times! Mismatched push() and pop()?");
            return;
        }
        long l = Util.func_211178_c();
        \u2603 = this.field_76326_c.removeLong(this.field_76326_c.size() - 1);
        this.field_76325_b.remove(this.field_76325_b.size() - 1);
        \u2603 = l - \u2603;
        this.field_76324_e.put((Object)this.field_219915_i, this.field_76324_e.getLong((Object)this.field_219915_i) + \u2603);
        this.field_223510_f.put((Object)this.field_219915_i, this.field_223510_f.getLong((Object)this.field_219915_i) + 1L);
        if (\u2603 > field_219907_a) {
            field_151234_b.warn("Something's taking too long! '{}' took aprox {} ms", new org.apache.logging.log4j.util.Supplier[]{() -> IProfileResult.func_225434_b(this.field_219915_i), () -> (double)\u2603 / 1000000.0});
        }
        this.field_219915_i = this.field_76325_b.isEmpty() ? "" : this.field_76325_b.get(this.field_76325_b.size() - 1);
    }

    @Override
    public void func_219895_b(String string) {
        this.func_76319_b();
        this.func_76320_a(string);
    }

    @Override
    public IProfileResult func_219905_d() {
        return new FilledProfileResult((Map<String, Long>)this.field_76324_e, (Map<String, Long>)this.field_223510_f, this.field_219913_g, this.field_219914_h, Util.func_211178_c(), this.field_219912_f.getAsInt());
    }
}

