/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.util.JSONUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserList<K, V extends UserListEntry<K>> {
    protected static final Logger field_152693_a = LogManager.getLogger();
    protected final Gson field_152694_b;
    private final File field_152695_c;
    private final Map<String, V> field_152696_d = Maps.newHashMap();
    private boolean field_152697_e = true;
    private static final ParameterizedType field_152698_f = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{UserListEntry.class};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };

    public UserList(File file) {
        this.field_152695_c = file;
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        gsonBuilder.registerTypeHierarchyAdapter(UserListEntry.class, (Object)new Serializer());
        this.field_152694_b = gsonBuilder.create();
    }

    public boolean func_152689_b() {
        return this.field_152697_e;
    }

    public void func_152686_a(boolean bl) {
        this.field_152697_e = bl;
    }

    public File func_152691_c() {
        return this.field_152695_c;
    }

    public void func_152687_a(V v) {
        this.field_152696_d.put(this.func_152681_a(((UserListEntry)v).func_152640_f()), v);
        try {
            this.func_152678_f();
        }
        catch (IOException iOException) {
            field_152693_a.warn("Could not save the list after adding a user.", (Throwable)iOException);
        }
    }

    @Nullable
    public V func_152683_b(K k) {
        this.func_152680_h();
        return (V)((UserListEntry)this.field_152696_d.get(this.func_152681_a(k)));
    }

    public void func_152684_c(K k) {
        this.field_152696_d.remove(this.func_152681_a(k));
        try {
            this.func_152678_f();
        }
        catch (IOException iOException) {
            field_152693_a.warn("Could not save the list after removing a user.", (Throwable)iOException);
        }
    }

    public void func_199042_b(UserListEntry<K> userListEntry) {
        this.func_152684_c(userListEntry.func_152640_f());
    }

    public String[] func_152685_a() {
        return this.field_152696_d.keySet().toArray(new String[this.field_152696_d.size()]);
    }

    public boolean func_152690_d() {
        return this.field_152696_d.size() < 1;
    }

    protected String func_152681_a(K k) {
        return k.toString();
    }

    protected boolean func_152692_d(K k) {
        return this.field_152696_d.containsKey(this.func_152681_a(k));
    }

    private void func_152680_h() {
        ArrayList arrayList = Lists.newArrayList();
        for (Object \u26032 : this.field_152696_d.values()) {
            if (!((UserListEntry)\u26032).func_73682_e()) continue;
            arrayList.add(((UserListEntry)\u26032).func_152640_f());
        }
        for (Object \u26032 : arrayList) {
            this.field_152696_d.remove(this.func_152681_a(\u26032));
        }
    }

    protected UserListEntry<K> func_152682_a(JsonObject jsonObject) {
        return new UserListEntry<Object>(null, jsonObject);
    }

    public Collection<V> func_199043_f() {
        return this.field_152696_d.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_152678_f() throws IOException {
        Collection<V> collection = this.field_152696_d.values();
        String \u26032 = this.field_152694_b.toJson(collection);
        BufferedWriter \u26033 = null;
        try {
            \u26033 = Files.newWriter((File)this.field_152695_c, (Charset)StandardCharsets.UTF_8);
            \u26033.write(\u26032);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(\u26033);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)\u26033);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_152679_g() throws FileNotFoundException {
        if (!this.field_152695_c.exists()) {
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = Files.newReader((File)this.field_152695_c, (Charset)StandardCharsets.UTF_8);
            Collection collection = (Collection)JSONUtils.func_193841_a(this.field_152694_b, bufferedReader, field_152698_f);
            if (collection != null) {
                this.field_152696_d.clear();
                for (UserListEntry userListEntry : collection) {
                    if (userListEntry.func_152640_f() == null) continue;
                    this.field_152696_d.put(this.func_152681_a(userListEntry.func_152640_f()), userListEntry);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
    }

    class Serializer
    implements JsonDeserializer<UserListEntry<K>>,
    JsonSerializer<UserListEntry<K>> {
        private Serializer() {
        }

        public JsonElement serialize(UserListEntry<K> userListEntry, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            userListEntry.func_152641_a(jsonObject);
            return jsonObject;
        }

        public UserListEntry<K> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                return UserList.this.func_152682_a(jsonObject);
            }
            return null;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((UserListEntry)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

