/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;

public class RegionFile
implements AutoCloseable {
    private static final byte[] field_76720_a = new byte[4096];
    private final RandomAccessFile field_76719_c;
    private final int[] field_76716_d = new int[1024];
    private final int[] field_76717_e = new int[1024];
    private final List<Boolean> field_76714_f;

    public RegionFile(File file) throws IOException {
        int n;
        this.field_76719_c = new RandomAccessFile(file, "rw");
        if (this.field_76719_c.length() < 4096L) {
            this.field_76719_c.write(field_76720_a);
            this.field_76719_c.write(field_76720_a);
        }
        if ((this.field_76719_c.length() & 0xFFFL) != 0L) {
            n = 0;
            while ((long)n < (this.field_76719_c.length() & 0xFFFL)) {
                this.field_76719_c.write(0);
                ++n;
            }
        }
        n = (int)this.field_76719_c.length() / 4096;
        this.field_76714_f = Lists.newArrayListWithCapacity((int)n);
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            this.field_76714_f.add(true);
        }
        this.field_76714_f.set(0, false);
        this.field_76714_f.set(1, false);
        this.field_76719_c.seek(0L);
        for (\u2603 = 0; \u2603 < 1024; ++\u2603) {
            this.field_76716_d[\u2603] = \u2603 = this.field_76719_c.readInt();
            if (\u2603 == 0 || (\u2603 >> 8) + (\u2603 & 0xFF) > this.field_76714_f.size()) continue;
            for (\u2603 = 0; \u2603 < (\u2603 & 0xFF); ++\u2603) {
                this.field_76714_f.set((\u2603 >> 8) + \u2603, false);
            }
        }
        for (\u2603 = 0; \u2603 < 1024; ++\u2603) {
            this.field_76717_e[\u2603] = \u2603 = this.field_76719_c.readInt();
        }
    }

    @Nullable
    public synchronized DataInputStream func_222666_a(ChunkPos chunkPos) throws IOException {
        int n = this.func_222660_e(chunkPos);
        if (n == 0) {
            return null;
        }
        \u2603 = n >> 8;
        \u2603 = n & 0xFF;
        if (\u2603 + \u2603 > this.field_76714_f.size()) {
            return null;
        }
        this.field_76719_c.seek(\u2603 * 4096);
        n2 = this.field_76719_c.readInt();
        if (n2 > 4096 * \u2603) {
            return null;
        }
        if (n2 <= 0) {
            return null;
        }
        byte \u26032 = this.field_76719_c.readByte();
        if (\u26032 == 1) {
            byte[] byArray = new byte[n2 - 1];
            this.field_76719_c.read(byArray);
            return new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(byArray))));
        }
        if (\u26032 == 2) {
            int n2;
            byte[] \u26033 = new byte[n2 - 1];
            this.field_76719_c.read(\u26033);
            return new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(\u26033))));
        }
        return null;
    }

    public boolean func_222662_b(ChunkPos chunkPos) {
        int n = this.func_222660_e(chunkPos);
        if (n == 0) {
            return false;
        }
        \u2603 = n >> 8;
        \u2603 = n & 0xFF;
        if (\u2603 + \u2603 > this.field_76714_f.size()) {
            return false;
        }
        try {
            this.field_76719_c.seek(\u2603 * 4096);
            \u2603 = this.field_76719_c.readInt();
            if (\u2603 > 4096 * \u2603) {
                return false;
            }
            if (\u2603 <= 0) {
                return false;
            }
        }
        catch (IOException \u26032) {
            return false;
        }
        return true;
    }

    public DataOutputStream func_222661_c(ChunkPos chunkPos) {
        return new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(new ChunkBuffer(chunkPos))));
    }

    protected synchronized void func_222664_a(ChunkPos chunkPos, byte[] byArray, int n) throws IOException {
        \u2603 = this.func_222660_e(chunkPos);
        \u2603 = \u2603 >> 8;
        \u2603 = \u2603 & 0xFF;
        \u2603 = (n + 5) / 4096 + 1;
        if (\u2603 >= 256) {
            throw new RuntimeException(String.format("Too big to save, %d > 1048576", n));
        }
        if (\u2603 != 0 && \u2603 == \u2603) {
            this.func_76712_a(\u2603, byArray, n);
        } else {
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                this.field_76714_f.set(\u2603 + \u2603, true);
            }
            \u2603 = this.field_76714_f.indexOf(true);
            \u2603 = 0;
            if (\u2603 != -1) {
                for (\u2603 = \u2603; \u2603 < this.field_76714_f.size(); ++\u2603) {
                    if (\u2603 != 0) {
                        \u2603 = this.field_76714_f.get(\u2603).booleanValue() ? ++\u2603 : 0;
                    } else if (this.field_76714_f.get(\u2603).booleanValue()) {
                        \u2603 = \u2603;
                        \u2603 = 1;
                    }
                    if (\u2603 >= \u2603) break;
                }
            }
            if (\u2603 >= \u2603) {
                \u2603 = \u2603;
                this.func_222663_a(chunkPos, \u2603 << 8 | \u2603);
                for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                    this.field_76714_f.set(\u2603 + \u2603, false);
                }
                this.func_76712_a(\u2603, byArray, n);
            } else {
                this.field_76719_c.seek(this.field_76719_c.length());
                \u2603 = this.field_76714_f.size();
                for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                    this.field_76719_c.write(field_76720_a);
                    this.field_76714_f.add(false);
                }
                this.func_76712_a(\u2603, byArray, n);
                this.func_222663_a(chunkPos, \u2603 << 8 | \u2603);
            }
        }
        this.func_222665_b(chunkPos, (int)(Util.func_211179_d() / 1000L));
    }

    private void func_76712_a(int n, byte[] byArray, int n2) throws IOException {
        this.field_76719_c.seek(n * 4096);
        this.field_76719_c.writeInt(n2 + 1);
        this.field_76719_c.writeByte(2);
        this.field_76719_c.write(byArray, 0, n2);
    }

    private int func_222660_e(ChunkPos chunkPos) {
        return this.field_76716_d[this.func_222668_f(chunkPos)];
    }

    public boolean func_222667_d(ChunkPos chunkPos) {
        return this.func_222660_e(chunkPos) != 0;
    }

    private void func_222663_a(ChunkPos chunkPos, int n) throws IOException {
        \u2603 = this.func_222668_f(chunkPos);
        this.field_76716_d[\u2603] = n;
        this.field_76719_c.seek(\u2603 * 4);
        this.field_76719_c.writeInt(n);
    }

    private int func_222668_f(ChunkPos chunkPos) {
        return chunkPos.func_222240_j() + chunkPos.func_222238_k() * 32;
    }

    private void func_222665_b(ChunkPos chunkPos, int n) throws IOException {
        \u2603 = this.func_222668_f(chunkPos);
        this.field_76717_e[\u2603] = n;
        this.field_76719_c.seek(4096 + \u2603 * 4);
        this.field_76719_c.writeInt(n);
    }

    @Override
    public void close() throws IOException {
        this.field_76719_c.close();
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkPos field_222659_b;

        public ChunkBuffer(ChunkPos chunkPos) {
            super(8096);
            this.field_222659_b = chunkPos;
        }

        @Override
        public void close() throws IOException {
            RegionFile.this.func_222664_a(this.field_222659_b, this.buf, this.count);
        }
    }
}

