/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public abstract class ChunkGenerator<C extends GenerationSettings> {
    protected final IWorld field_222540_a;
    protected final long field_222541_b;
    protected final BiomeProvider field_222542_c;
    protected final C field_222543_d;

    public ChunkGenerator(IWorld iWorld, BiomeProvider biomeProvider, C c) {
        this.field_222540_a = iWorld;
        this.field_222541_b = iWorld.func_72905_C();
        this.field_222542_c = biomeProvider;
        this.field_222543_d = c;
    }

    public void func_222539_a(IChunk iChunk) {
        ChunkPos chunkPos = iChunk.func_76632_l();
        int \u26032 = chunkPos.field_77276_a;
        int \u26033 = chunkPos.field_77275_b;
        Biome[] \u26034 = this.field_222542_c.func_201539_b(\u26032 * 16, \u26033 * 16, 16, 16);
        iChunk.func_201577_a(\u26034);
    }

    protected Biome func_222534_b(IChunk iChunk) {
        return iChunk.func_217309_c(BlockPos.field_177992_a);
    }

    protected Biome func_222527_a(WorldGenRegion worldGenRegion, BlockPos blockPos) {
        return this.field_222542_c.func_222364_a(blockPos);
    }

    public void func_222538_a(IChunk iChunk, GenerationStage.Carving carving) {
        SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
        int \u26032 = 8;
        ChunkPos \u26033 = iChunk.func_76632_l();
        int \u26034 = \u26033.field_77276_a;
        int \u26035 = \u26033.field_77275_b;
        BitSet \u26036 = iChunk.func_205749_a(carving);
        for (int i = \u26034 - 8; i <= \u26034 + 8; ++i) {
            for (\u2603 = \u26035 - 8; \u2603 <= \u26035 + 8; ++\u2603) {
                List<ConfiguredCarver<?>> list = this.func_222534_b(iChunk).func_203603_a(carving);
                ListIterator<ConfiguredCarver<?>> \u26037 = list.listIterator();
                while (\u26037.hasNext()) {
                    int n = \u26037.nextIndex();
                    ConfiguredCarver<?> \u26038 = \u26037.next();
                    sharedSeedRandom.func_202425_c(this.field_222541_b + (long)n, i, \u2603);
                    if (!\u26038.func_222730_a(sharedSeedRandom, i, \u2603)) continue;
                    \u26038.func_222731_a(iChunk, sharedSeedRandom, this.func_222530_f(), i, \u2603, \u26034, \u26035, \u26036);
                }
            }
        }
    }

    @Nullable
    public BlockPos func_211403_a(World world, String string, BlockPos blockPos, int n, boolean bl) {
        Structure structure = (Structure)Feature.field_202300_at.get((Object)string.toLowerCase(Locale.ROOT));
        if (structure != null) {
            return structure.func_211405_a(world, this, blockPos, n, bl);
        }
        return null;
    }

    public void func_202092_b(WorldGenRegion worldGenRegion) {
        int n = worldGenRegion.func_201679_a();
        \u2603 = worldGenRegion.func_201680_b();
        \u2603 = n * 16;
        \u2603 = \u2603 * 16;
        BlockPos \u26032 = new BlockPos(\u2603, 0, \u2603);
        Biome \u26033 = this.func_222527_a(worldGenRegion, \u26032.func_177982_a(8, 8, 8));
        SharedSeedRandom \u26034 = new SharedSeedRandom();
        long \u26035 = \u26034.func_202424_a(worldGenRegion.func_72905_C(), \u2603, \u2603);
        for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
            try {
                \u26033.func_203608_a(decoration, this, worldGenRegion, \u26035, \u26034, \u26032);
            }
            catch (Exception exception) {
                CrashReport crashReport = CrashReport.func_85055_a(exception, "Biome decoration");
                crashReport.func_85058_a("Generation").func_71507_a("CenterX", n).func_71507_a("CenterZ", \u2603).func_71507_a("Step", (Object)decoration).func_71507_a("Seed", \u26035).func_71507_a("Biome", Registry.field_212624_m.func_177774_c(\u26033));
                throw new ReportedException(crashReport);
            }
        }
    }

    public abstract void func_222535_c(IChunk var1);

    public void func_202093_c(WorldGenRegion worldGenRegion) {
    }

    public C func_201496_a_() {
        return this.field_222543_d;
    }

    public abstract int func_205470_d();

    public void func_203222_a(ServerWorld serverWorld, boolean bl, boolean bl2) {
    }

    public boolean func_202094_a(Biome biome, Structure<? extends IFeatureConfig> structure) {
        return biome.func_201858_a(structure);
    }

    @Nullable
    public <C extends IFeatureConfig> C func_202087_b(Biome biome, Structure<C> structure) {
        return biome.func_201857_b(structure);
    }

    public BiomeProvider func_202090_b() {
        return this.field_222542_c;
    }

    public long func_202089_c() {
        return this.field_222541_b;
    }

    public int func_207511_e() {
        return 256;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification entityClassification, BlockPos blockPos) {
        return this.field_222540_a.func_180494_b(blockPos).func_76747_a(entityClassification);
    }

    public void func_222533_a(IChunk iChunk, ChunkGenerator<?> chunkGenerator, TemplateManager templateManager) {
        for (Structure structure : Feature.field_202300_at.values()) {
            if (!chunkGenerator.func_202090_b().func_205004_a(structure)) continue;
            SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
            ChunkPos \u26032 = iChunk.func_76632_l();
            StructureStart \u26033 = StructureStart.field_214630_a;
            if (structure.func_202372_a(chunkGenerator, sharedSeedRandom, \u26032.field_77276_a, \u26032.field_77275_b)) {
                Biome biome = this.func_202090_b().func_222364_a(new BlockPos(\u26032.func_180334_c() + 9, 0, \u26032.func_180333_d() + 9));
                StructureStart \u26034 = structure.func_214557_a().create(structure, \u26032.field_77276_a, \u26032.field_77275_b, biome, MutableBoundingBox.func_78887_a(), 0, chunkGenerator.func_202089_c());
                \u26034.func_214625_a(this, templateManager, \u26032.field_77276_a, \u26032.field_77275_b, biome);
                \u26033 = \u26034.func_75069_d() ? \u26034 : StructureStart.field_214630_a;
            }
            iChunk.func_201584_a(structure.func_143025_a(), \u26033);
        }
    }

    public void func_222528_a(IWorld iWorld, IChunk iChunk) {
        int n = 8;
        \u2603 = iChunk.func_76632_l().field_77276_a;
        \u2603 = iChunk.func_76632_l().field_77275_b;
        \u2603 = \u2603 << 4;
        \u2603 = \u2603 << 4;
        for (\u2603 = \u2603 - 8; \u2603 <= \u2603 + 8; ++\u2603) {
            for (\u2603 = \u2603 - 8; \u2603 <= \u2603 + 8; ++\u2603) {
                long l = ChunkPos.func_77272_a(\u2603, \u2603);
                for (Map.Entry<String, StructureStart> entry : iWorld.func_212866_a_(\u2603, \u2603).func_201609_c().entrySet()) {
                    StructureStart structureStart = entry.getValue();
                    if (structureStart == StructureStart.field_214630_a || !structureStart.func_75071_a().func_78885_a(\u2603, \u2603, \u2603 + 15, \u2603 + 15)) continue;
                    iChunk.func_201583_a(entry.getKey(), l);
                    DebugPacketSender.func_218804_a(iWorld, structureStart);
                }
            }
        }
    }

    public abstract void func_222537_b(IWorld var1, IChunk var2);

    public int func_222530_f() {
        return 63;
    }

    public abstract int func_222529_a(int var1, int var2, Heightmap.Type var3);

    public int func_222532_b(int n, int n2, Heightmap.Type type) {
        return this.func_222529_a(n, n2, type);
    }

    public int func_222531_c(int n, int n2, Heightmap.Type type) {
        return this.func_222529_a(n, n2, type) - 1;
    }
}

