/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class OverworldChunkGenerator
extends NoiseChunkGenerator<OverworldGenSettings> {
    private static final float[] field_222576_h = Util.func_200696_a(new float[25], fArray -> {
        for (int i = -2; i <= 2; ++i) {
            for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                fArray[i + 2 + (\u2603 + 2) * 5] = \u2603 = 10.0f / MathHelper.func_76129_c((float)(i * i + \u2603 * \u2603) + 0.2f);
            }
        }
    });
    private final OctavesNoiseGenerator field_185984_c;
    private final boolean field_222577_j;
    private final PhantomSpawner field_203230_r = new PhantomSpawner();
    private final PatrolSpawner field_222578_l = new PatrolSpawner();
    private final CatSpawner field_222579_m = new CatSpawner();
    private final VillageSiege field_225495_n = new VillageSiege();

    public OverworldChunkGenerator(IWorld iWorld, BiomeProvider biomeProvider, OverworldGenSettings overworldGenSettings) {
        super(iWorld, biomeProvider, 4, 8, 256, overworldGenSettings, true);
        this.field_222558_e.func_202423_a(2620);
        this.field_185984_c = new OctavesNoiseGenerator(this.field_222558_e, 16);
        this.field_222577_j = iWorld.func_72912_H().func_76067_t() == WorldType.field_151360_e;
    }

    @Override
    public void func_202093_c(WorldGenRegion worldGenRegion) {
        int n = worldGenRegion.func_201679_a();
        \u2603 = worldGenRegion.func_201680_b();
        Biome \u26032 = worldGenRegion.func_212866_a_(n, \u2603).func_201590_e()[0];
        SharedSeedRandom \u26033 = new SharedSeedRandom();
        \u26033.func_202424_a(worldGenRegion.func_72905_C(), n << 4, \u2603 << 4);
        WorldEntitySpawner.func_77191_a(worldGenRegion, \u26032, n, \u2603, \u26033);
    }

    @Override
    protected void func_222548_a(double[] dArray, int n, int n2) {
        double d = 684.412f;
        \u2603 = 684.412f;
        \u2603 = 8.555149841308594;
        \u2603 = 4.277574920654297;
        int \u26032 = -10;
        int \u26033 = 3;
        this.func_222546_a(dArray, n, n2, 684.412f, 684.412f, 8.555149841308594, 4.277574920654297, 3, -10);
    }

    @Override
    protected double func_222545_a(double d, double d2, int n) {
        double d3 = 8.5;
        \u2603 = ((double)n - (8.5 + d * 8.5 / 8.0 * 4.0)) * 12.0 * 128.0 / 256.0 / d2;
        if (\u2603 < 0.0) {
            \u2603 *= 4.0;
        }
        return \u2603;
    }

    @Override
    protected double[] func_222549_a(int n, int n2) {
        double[] dArray = new double[2];
        float \u26032 = 0.0f;
        float \u26033 = 0.0f;
        float \u26034 = 0.0f;
        int \u26035 = 2;
        float \u26036 = this.field_222542_c.func_222366_b(n, n2).func_185355_j();
        for (int i = -2; i <= 2; ++i) {
            for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                Biome biome = this.field_222542_c.func_222366_b(n + i, n2 + \u2603);
                float \u26037 = biome.func_185355_j();
                float \u26038 = biome.func_185360_m();
                if (this.field_222577_j && \u26037 > 0.0f) {
                    \u26037 = 1.0f + \u26037 * 2.0f;
                    \u26038 = 1.0f + \u26038 * 4.0f;
                }
                float \u26039 = field_222576_h[i + 2 + (\u2603 + 2) * 5] / (\u26037 + 2.0f);
                if (biome.func_185355_j() > \u26036) {
                    \u26039 /= 2.0f;
                }
                \u26032 += \u26038 * \u26039;
                \u26033 += \u26037 * \u26039;
                \u26034 += \u26039;
            }
        }
        \u26032 /= \u26034;
        \u26033 /= \u26034;
        \u26032 = \u26032 * 0.9f + 0.1f;
        \u26033 = (\u26033 * 4.0f - 1.0f) / 8.0f;
        dArray[0] = (double)\u26033 + this.func_222574_c(n, n2);
        dArray[1] = \u26032;
        return dArray;
    }

    private double func_222574_c(int n, int n2) {
        double d = this.field_185984_c.func_215462_a(n * 200, 10.0, n2 * 200, 1.0, 0.0, true) / 8000.0;
        if (d < 0.0) {
            d = -d * 0.3;
        }
        if ((d = d * 3.0 - 2.0) < 0.0) {
            d /= 28.0;
        } else {
            if (d > 1.0) {
                d = 1.0;
            }
            d /= 40.0;
        }
        return d;
    }

    @Override
    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification entityClassification, BlockPos blockPos) {
        if (Feature.field_202334_l.func_202383_b(this.field_222540_a, blockPos)) {
            if (entityClassification == EntityClassification.MONSTER) {
                return Feature.field_202334_l.func_202279_e();
            }
            if (entityClassification == EntityClassification.CREATURE) {
                return Feature.field_202334_l.func_214469_f();
            }
        } else if (entityClassification == EntityClassification.MONSTER) {
            if (Feature.field_214536_b.func_175796_a(this.field_222540_a, blockPos)) {
                return Feature.field_214536_b.func_202279_e();
            }
            if (Feature.field_202336_n.func_175796_a(this.field_222540_a, blockPos)) {
                return Feature.field_202336_n.func_202279_e();
            }
        }
        return super.func_177458_a(entityClassification, blockPos);
    }

    @Override
    public void func_203222_a(ServerWorld serverWorld, boolean bl, boolean bl2) {
        this.field_203230_r.func_203232_a(serverWorld, bl, bl2);
        this.field_222578_l.func_222696_a(serverWorld, bl, bl2);
        this.field_222579_m.func_221124_a(serverWorld, bl, bl2);
        this.field_225495_n.func_225477_a(serverWorld, bl, bl2);
    }

    @Override
    public int func_205470_d() {
        return this.field_222540_a.func_181545_F() + 1;
    }

    @Override
    public int func_222530_f() {
        return 63;
    }
}

