/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Structures {
    private static final Logger field_151687_a = LogManager.getLogger();
    public static final Structure<?> field_215143_a = Structures.func_215141_a("Mineshaft", Feature.field_202329_g);
    public static final Structure<?> field_215144_b = Structures.func_215141_a("Pillager_Outpost", Feature.field_214536_b);
    public static final Structure<?> field_215145_c = Structures.func_215141_a("Fortress", Feature.field_202337_o);
    public static final Structure<?> field_215146_d = Structures.func_215141_a("Stronghold", Feature.field_202335_m);
    public static final Structure<?> field_215147_e = Structures.func_215141_a("Jungle_Pyramid", Feature.field_202331_i);
    public static final Structure<?> field_215148_f = Structures.func_215141_a("Ocean_Ruin", Feature.field_204029_o);
    public static final Structure<?> field_215149_g = Structures.func_215141_a("Desert_Pyramid", Feature.field_202332_j);
    public static final Structure<?> field_215150_h = Structures.func_215141_a("Igloo", Feature.field_202333_k);
    public static final Structure<?> field_215151_i = Structures.func_215141_a("Swamp_Hut", Feature.field_202334_l);
    public static final Structure<?> field_215152_j = Structures.func_215141_a("Monument", Feature.field_202336_n);
    public static final Structure<?> field_215153_k = Structures.func_215141_a("EndCity", Feature.field_204292_r);
    public static final Structure<?> field_215154_l = Structures.func_215141_a("Mansion", Feature.field_202330_h);
    public static final Structure<?> field_215155_m = Structures.func_215141_a("Buried_Treasure", Feature.field_214549_o);
    public static final Structure<?> field_215156_n = Structures.func_215141_a("Shipwreck", Feature.field_204751_l);
    public static final Structure<?> field_215157_o = Structures.func_215141_a("Village", Feature.field_214550_p);

    private static Structure<?> func_215141_a(String string, Structure<?> structure) {
        return Registry.func_218325_a(Registry.field_218361_B, string.toLowerCase(Locale.ROOT), structure);
    }

    public static void func_215140_a() {
    }

    @Nullable
    public static StructureStart func_215142_a(ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, BiomeProvider biomeProvider, CompoundNBT compoundNBT) {
        String string = compoundNBT.func_74779_i("id");
        if ("INVALID".equals(string)) {
            return StructureStart.field_214630_a;
        }
        Structure<?> \u26032 = Registry.field_218361_B.func_82594_a(new ResourceLocation(string.toLowerCase(Locale.ROOT)));
        if (\u26032 == null) {
            field_151687_a.error("Unknown feature id: {}", (Object)string);
            return null;
        }
        int \u26033 = compoundNBT.func_74762_e("ChunkX");
        int \u26034 = compoundNBT.func_74762_e("ChunkZ");
        Biome \u26035 = compoundNBT.func_74764_b("biome") ? Registry.field_212624_m.func_82594_a(new ResourceLocation(compoundNBT.func_74779_i("biome"))) : biomeProvider.func_222364_a(new BlockPos((\u26033 << 4) + 9, 0, (\u26034 << 4) + 9));
        MutableBoundingBox \u26036 = compoundNBT.func_74764_b("BB") ? new MutableBoundingBox(compoundNBT.func_74759_k("BB")) : MutableBoundingBox.func_78887_a();
        ListNBT \u26037 = compoundNBT.func_150295_c("Children", 10);
        try {
            StructureStart structureStart = \u26032.func_214557_a().create(\u26032, \u26033, \u26034, \u26035, \u26036, 0, chunkGenerator.func_202089_c());
            for (int i = 0; i < \u26037.size(); ++i) {
                CompoundNBT compoundNBT2 = \u26037.func_150305_b(i);
                String \u26038 = compoundNBT2.func_74779_i("id");
                IStructurePieceType \u26039 = Registry.field_218362_C.func_82594_a(new ResourceLocation(\u26038.toLowerCase(Locale.ROOT)));
                if (\u26039 == null) {
                    field_151687_a.error("Unknown structure piece id: {}", (Object)\u26038);
                    continue;
                }
                try {
                    StructurePiece structurePiece = \u26039.load(templateManager, compoundNBT2);
                    structureStart.field_75075_a.add(structurePiece);
                    continue;
                }
                catch (Exception exception) {
                    field_151687_a.error("Exception loading structure piece with id {}", (Object)\u26038, (Object)exception);
                }
            }
            return structureStart;
        }
        catch (Exception exception) {
            field_151687_a.error("Failed Start with id {}", (Object)string, (Object)exception);
            return null;
        }
    }
}

