/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkDistanceGraph;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.ChunkTaskPriorityQueueSorter;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.Ticket;
import net.minecraft.world.server.TicketType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TicketManager {
    private static final Logger field_219373_a = LogManager.getLogger();
    private static final int field_219374_b = 33 + ChunkStatus.func_222599_a(ChunkStatus.field_222617_m) - 2;
    private final Long2ObjectMap<ObjectSet<ServerPlayerEntity>> field_219375_c = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<ObjectSortedSet<Ticket<?>>> field_219377_e = new Long2ObjectOpenHashMap();
    private final ChunkTicketTracker field_219378_f = new ChunkTicketTracker();
    private final PlayerChunkTracker field_219381_i = new PlayerChunkTracker(8);
    private final PlayerTicketTracker field_219382_j = new PlayerTicketTracker(33);
    private final Set<ChunkHolder> field_219383_k = Sets.newHashSet();
    private final ChunkTaskPriorityQueueSorter field_219384_l;
    private final ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>> field_219385_m;
    private final ITaskExecutor<ChunkTaskPriorityQueueSorter.RunnableEntry> field_219386_n;
    private final LongSet field_219387_o = new LongOpenHashSet();
    private final Executor field_219388_p;
    private long field_219389_q;

    protected TicketManager(Executor executor, Executor executor2) {
        ITaskExecutor<Runnable> iTaskExecutor = ITaskExecutor.func_213140_a("player ticket throttler", executor2::execute);
        this.field_219384_l = \u2603 = new ChunkTaskPriorityQueueSorter((List<ITaskExecutor<?>>)ImmutableList.of(iTaskExecutor), executor, 4);
        this.field_219385_m = \u2603.func_219087_a(iTaskExecutor, true);
        this.field_219386_n = \u2603.func_219091_a(iTaskExecutor);
        this.field_219388_p = executor2;
    }

    protected void func_219340_a() {
        ++this.field_219389_q;
        ObjectIterator objectIterator = this.field_219377_e.long2ObjectEntrySet().fastIterator();
        while (objectIterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectIterator.next();
            if (((ObjectSortedSet)entry.getValue()).removeIf(ticket -> ticket.func_223182_a(this.field_219389_q))) {
                this.field_219378_f.func_215491_b(entry.getLongKey(), this.func_219344_a((ObjectSortedSet)entry.getValue()), false);
            }
            if (!((ObjectSortedSet)entry.getValue()).isEmpty()) continue;
            objectIterator.remove();
        }
    }

    private int func_219344_a(ObjectSortedSet<Ticket<?>> objectSortedSet) {
        ObjectBidirectionalIterator objectBidirectionalIterator = objectSortedSet.iterator();
        if (objectBidirectionalIterator.hasNext()) {
            return ((Ticket)objectBidirectionalIterator.next()).func_219477_b();
        }
        return ChunkManager.field_219249_a + 1;
    }

    protected abstract boolean func_219371_a(long var1);

    @Nullable
    protected abstract ChunkHolder func_219335_b(long var1);

    @Nullable
    protected abstract ChunkHolder func_219372_a(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean func_219353_a(ChunkManager chunkManager) {
        this.field_219381_i.func_215497_a();
        this.field_219382_j.func_215497_a();
        int n = Integer.MAX_VALUE - this.field_219378_f.func_215493_a(Integer.MAX_VALUE);
        boolean bl = \u2603 = n != 0;
        if (\u2603) {
            // empty if block
        }
        if (!this.field_219383_k.isEmpty()) {
            this.field_219383_k.forEach(chunkHolder -> chunkHolder.func_219291_a(chunkManager));
            this.field_219383_k.clear();
            return true;
        }
        if (!this.field_219387_o.isEmpty()) {
            LongIterator longIterator = this.field_219387_o.iterator();
            while (longIterator.hasNext()) {
                long l = longIterator.nextLong();
                if (!this.func_219332_d(l).stream().anyMatch(ticket -> ticket.func_219479_a() == TicketType.field_219490_c)) continue;
                ChunkHolder \u26032 = chunkManager.func_219220_a(l);
                if (\u26032 == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> \u26033 = \u26032.func_219297_b();
                \u26033.thenAccept(either -> this.field_219388_p.execute(() -> this.field_219386_n.func_212871_a_(ChunkTaskPriorityQueueSorter.func_219073_a(() -> {}, l, false))));
            }
            this.field_219387_o.clear();
        }
        return \u2603;
    }

    private void func_219347_a(long l, Ticket<?> ticket) {
        ObjectSortedSet<Ticket<?>> objectSortedSet = this.func_219332_d(l);
        ObjectBidirectionalIterator \u26032 = objectSortedSet.iterator();
        int \u26033 = \u26032.hasNext() ? ((Ticket)\u26032.next()).func_219477_b() : ChunkManager.field_219249_a + 1;
        if (objectSortedSet.add(ticket)) {
            // empty if block
        }
        if (ticket.func_219477_b() < \u26033) {
            this.field_219378_f.func_215491_b(l, ticket.func_219477_b(), true);
        }
    }

    private void func_219349_b(long l, Ticket<?> ticket) {
        ObjectSortedSet<Ticket<?>> objectSortedSet = this.func_219332_d(l);
        if (objectSortedSet.remove(ticket)) {
            // empty if block
        }
        if (objectSortedSet.isEmpty()) {
            this.field_219377_e.remove(l);
        }
        this.field_219378_f.func_215491_b(l, this.func_219344_a(objectSortedSet), false);
    }

    public <T> void func_219356_a(TicketType<T> ticketType, ChunkPos chunkPos, int n, T t) {
        this.func_219347_a(chunkPos.func_201841_a(), new Ticket<T>(ticketType, n, t, this.field_219389_q));
    }

    public <T> void func_219345_b(TicketType<T> ticketType, ChunkPos chunkPos, int n, T t) {
        Ticket<T> ticket = new Ticket<T>(ticketType, n, t, this.field_219389_q);
        this.func_219349_b(chunkPos.func_201841_a(), ticket);
    }

    public <T> void func_219331_c(TicketType<T> ticketType, ChunkPos chunkPos, int n, T t) {
        this.func_219347_a(chunkPos.func_201841_a(), new Ticket<T>(ticketType, 33 - n, t, this.field_219389_q));
    }

    public <T> void func_219362_d(TicketType<T> ticketType, ChunkPos chunkPos, int n, T t) {
        Ticket<T> ticket = new Ticket<T>(ticketType, 33 - n, t, this.field_219389_q);
        this.func_219349_b(chunkPos.func_201841_a(), ticket);
    }

    private ObjectSortedSet<Ticket<?>> func_219332_d(long l2) {
        return (ObjectSortedSet)this.field_219377_e.computeIfAbsent(l2, l -> new ObjectAVLTreeSet());
    }

    protected void func_219364_a(ChunkPos chunkPos, boolean bl) {
        Ticket<ChunkPos> ticket = new Ticket<ChunkPos>(TicketType.field_219491_d, 31, chunkPos, this.field_219389_q);
        if (bl) {
            this.func_219347_a(chunkPos.func_201841_a(), ticket);
        } else {
            this.func_219349_b(chunkPos.func_201841_a(), ticket);
        }
    }

    public void func_219341_a(SectionPos sectionPos, ServerPlayerEntity serverPlayerEntity) {
        long l2 = sectionPos.func_218155_u().func_201841_a();
        ((ObjectSet)this.field_219375_c.computeIfAbsent(l2, l -> new ObjectOpenHashSet())).add((Object)serverPlayerEntity);
        this.field_219381_i.func_215491_b(l2, 0, true);
        this.field_219382_j.func_215491_b(l2, 0, true);
    }

    public void func_219367_b(SectionPos sectionPos, ServerPlayerEntity serverPlayerEntity) {
        long l = sectionPos.func_218155_u().func_201841_a();
        ObjectSet \u26032 = (ObjectSet)this.field_219375_c.get(l);
        \u26032.remove((Object)serverPlayerEntity);
        if (\u26032.isEmpty()) {
            this.field_219375_c.remove(l);
            this.field_219381_i.func_215491_b(l, Integer.MAX_VALUE, false);
            this.field_219382_j.func_215491_b(l, Integer.MAX_VALUE, false);
        }
    }

    protected String func_225413_c(long l) {
        ObjectSortedSet objectSortedSet = (ObjectSortedSet)this.field_219377_e.get(l);
        String \u26032 = objectSortedSet == null || objectSortedSet.isEmpty() ? "no_ticket" : ((Ticket)objectSortedSet.first()).toString();
        return \u26032;
    }

    protected void func_219354_b(int n) {
        this.field_219382_j.func_215508_a(n);
    }

    public int func_219358_b() {
        this.field_219381_i.func_215497_a();
        return this.field_219381_i.field_215498_a.size();
    }

    public boolean func_223494_d(long l) {
        this.field_219381_i.func_215497_a();
        return this.field_219381_i.field_215498_a.containsKey(l);
    }

    public String func_225412_c() {
        return this.field_219384_l.func_225396_a();
    }

    class ChunkTicketTracker
    extends ChunkDistanceGraph {
        public ChunkTicketTracker() {
            super(ChunkManager.field_219249_a + 2, 16, 256);
        }

        @Override
        protected int func_215492_b(long l) {
            ObjectSortedSet objectSortedSet = (ObjectSortedSet)TicketManager.this.field_219377_e.get(l);
            if (objectSortedSet == null) {
                return Integer.MAX_VALUE;
            }
            ObjectBidirectionalIterator \u26032 = objectSortedSet.iterator();
            if (!\u26032.hasNext()) {
                return Integer.MAX_VALUE;
            }
            return ((Ticket)\u26032.next()).func_219477_b();
        }

        @Override
        protected int func_215471_c(long l) {
            if (!TicketManager.this.func_219371_a(l) && (\u2603 = TicketManager.this.func_219335_b(l)) != null) {
                return \u2603.func_219299_i();
            }
            return ChunkManager.field_219249_a + 1;
        }

        @Override
        protected void func_215476_a(long l, int n) {
            ChunkHolder chunkHolder = TicketManager.this.func_219335_b(l);
            int n2 = \u2603 = chunkHolder == null ? ChunkManager.field_219249_a + 1 : chunkHolder.func_219299_i();
            if (\u2603 == n) {
                return;
            }
            if ((chunkHolder = TicketManager.this.func_219372_a(l, n, chunkHolder, \u2603)) != null) {
                TicketManager.this.field_219383_k.add(chunkHolder);
            }
        }

        public int func_215493_a(int n) {
            return this.func_215483_b(n);
        }
    }

    class PlayerTicketTracker
    extends PlayerChunkTracker {
        private int field_215512_e;
        private final Long2IntMap field_215513_f;
        private final LongSet field_215514_g;

        protected PlayerTicketTracker(int n) {
            super(n);
            this.field_215513_f = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.field_215514_g = new LongOpenHashSet();
            this.field_215512_e = 0;
            this.field_215513_f.defaultReturnValue(n + 2);
        }

        @Override
        protected void func_215495_a(long l, int n, int n2) {
            this.field_215514_g.add(l);
        }

        public void func_215508_a(int n) {
            for (Long2ByteMap.Entry entry : this.field_215498_a.long2ByteEntrySet()) {
                byte by = entry.getByteValue();
                long \u26032 = entry.getLongKey();
                this.func_215504_a(\u26032, by, this.func_215505_c(by), by <= n - 2);
            }
            this.field_215512_e = n;
        }

        private void func_215504_a(long l, int n, boolean bl, boolean bl2) {
            if (bl != bl2) {
                Ticket<ChunkPos> ticket = new Ticket<ChunkPos>(TicketType.field_219490_c, field_219374_b, new ChunkPos(l), TicketManager.this.field_219389_q);
                if (bl2) {
                    TicketManager.this.field_219385_m.func_212871_a_(ChunkTaskPriorityQueueSorter.func_219069_a(() -> TicketManager.this.field_219388_p.execute(() -> {
                        if (this.func_215505_c(this.func_215471_c(l))) {
                            TicketManager.this.func_219347_a(l, ticket);
                            TicketManager.this.field_219387_o.add(l);
                        } else {
                            TicketManager.this.field_219386_n.func_212871_a_(ChunkTaskPriorityQueueSorter.func_219073_a(() -> {}, l, false));
                        }
                    }), l, () -> n));
                } else {
                    TicketManager.this.field_219386_n.func_212871_a_(ChunkTaskPriorityQueueSorter.func_219073_a(() -> TicketManager.this.field_219388_p.execute(() -> TicketManager.this.func_219349_b(l, ticket)), l, true));
                }
            }
        }

        @Override
        public void func_215497_a() {
            super.func_215497_a();
            if (!this.field_215514_g.isEmpty()) {
                LongIterator longIterator = this.field_215514_g.iterator();
                while (longIterator.hasNext()) {
                    long l = longIterator.nextLong();
                    int \u26032 = this.field_215513_f.get(l);
                    if (\u26032 == (\u2603 = this.func_215471_c(l))) continue;
                    TicketManager.this.field_219384_l.func_219066_a(new ChunkPos(l), () -> this.field_215513_f.get(l), \u2603, n -> {
                        if (n >= this.field_215513_f.defaultReturnValue()) {
                            this.field_215513_f.remove(l);
                        } else {
                            this.field_215513_f.put(l, n);
                        }
                    });
                    this.func_215504_a(l, \u2603, this.func_215505_c(\u26032), this.func_215505_c(\u2603));
                }
                this.field_215514_g.clear();
            }
        }

        private boolean func_215505_c(int n) {
            return n <= this.field_215512_e - 2;
        }
    }

    class PlayerChunkTracker
    extends ChunkDistanceGraph {
        protected final Long2ByteMap field_215498_a;
        protected final int field_215499_b;

        protected PlayerChunkTracker(int n) {
            super(n + 2, 16, 256);
            this.field_215498_a = new Long2ByteOpenHashMap();
            this.field_215499_b = n;
            this.field_215498_a.defaultReturnValue((byte)(n + 2));
        }

        @Override
        protected int func_215471_c(long l) {
            return this.field_215498_a.get(l);
        }

        @Override
        protected void func_215476_a(long l, int n) {
            byte by = n > this.field_215499_b ? this.field_215498_a.remove(l) : this.field_215498_a.put(l, (byte)n);
            this.func_215495_a(l, by, n);
        }

        protected void func_215495_a(long l, int n, int n2) {
        }

        @Override
        protected int func_215492_b(long l) {
            return this.func_215496_d(l) ? 0 : Integer.MAX_VALUE;
        }

        private boolean func_215496_d(long l) {
            ObjectSet objectSet = (ObjectSet)TicketManager.this.field_219375_c.get(l);
            return objectSet != null && !objectSet.isEmpty();
        }

        public void func_215497_a() {
            this.func_215483_b(Integer.MAX_VALUE);
        }
    }
}

