/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.spawner;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSpawner {
    private static final Logger field_209160_a = LogManager.getLogger();
    private int field_98286_b = 20;
    private final List<WeightedSpawnerEntity> field_98285_e = Lists.newArrayList();
    private WeightedSpawnerEntity field_98282_f = new WeightedSpawnerEntity();
    private double field_98287_c;
    private double field_98284_d;
    private int field_98283_g = 200;
    private int field_98293_h = 800;
    private int field_98294_i = 4;
    private Entity field_98291_j;
    private int field_98292_k = 6;
    private int field_98289_l = 16;
    private int field_98290_m = 4;

    @Nullable
    private ResourceLocation func_190895_g() {
        String string = this.field_98282_f.func_185277_b().func_74779_i("id");
        try {
            return StringUtils.func_151246_b(string) ? null : new ResourceLocation(string);
        }
        catch (ResourceLocationException \u26032) {
            BlockPos blockPos = this.func_177221_b();
            field_209160_a.warn("Invalid entity id '{}' at spawner {}:[{},{},{}]", (Object)string, (Object)this.func_98271_a().field_73011_w.func_186058_p(), (Object)blockPos.func_177958_n(), (Object)blockPos.func_177956_o(), (Object)blockPos.func_177952_p());
            return null;
        }
    }

    public void func_200876_a(EntityType<?> entityType) {
        this.field_98282_f.func_185277_b().func_74778_a("id", Registry.field_212629_r.func_177774_c(entityType).toString());
    }

    private boolean func_98279_f() {
        BlockPos blockPos = this.func_177221_b();
        return this.func_98271_a().func_217358_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, this.field_98289_l);
    }

    public void func_98278_g() {
        if (!this.func_98279_f()) {
            this.field_98284_d = this.field_98287_c;
            return;
        }
        World world = this.func_98271_a();
        BlockPos \u26032 = this.func_177221_b();
        if (world.field_72995_K) {
            double d = (float)\u26032.func_177958_n() + world.field_73012_v.nextFloat();
            \u2603 = (float)\u26032.func_177956_o() + world.field_73012_v.nextFloat();
            \u2603 = (float)\u26032.func_177952_p() + world.field_73012_v.nextFloat();
            world.func_195594_a(ParticleTypes.field_197601_L, d, \u2603, \u2603, 0.0, 0.0, 0.0);
            world.func_195594_a(ParticleTypes.field_197631_x, d, \u2603, \u2603, 0.0, 0.0, 0.0);
            if (this.field_98286_b > 0) {
                --this.field_98286_b;
            }
            this.field_98284_d = this.field_98287_c;
            this.field_98287_c = (this.field_98287_c + (double)(1000.0f / ((float)this.field_98286_b + 200.0f))) % 360.0;
        } else {
            if (this.field_98286_b == -1) {
                this.func_98273_j();
            }
            if (this.field_98286_b > 0) {
                --this.field_98286_b;
                return;
            }
            boolean \u260310 = false;
            for (int i = 0; i < this.field_98294_i; ++i) {
                CompoundNBT compoundNBT = this.field_98282_f.func_185277_b();
                Optional<EntityType<?>> \u26033 = EntityType.func_220347_a(compoundNBT);
                if (!\u26033.isPresent()) {
                    this.func_98273_j();
                    return;
                }
                ListNBT \u26034 = compoundNBT.func_150295_c("Pos", 6);
                int \u26035 = \u26034.size();
                double \u26036 = \u26035 >= 1 ? \u26034.func_150309_d(0) : (double)\u26032.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                double \u26037 = \u26035 >= 2 ? \u26034.func_150309_d(1) : (double)(\u26032.func_177956_o() + world.field_73012_v.nextInt(3) - 1);
                double d = \u2603 = \u26035 >= 3 ? \u26034.func_150309_d(2) : (double)\u26032.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                if (!world.func_217351_c(\u26033.get().func_220328_a(\u26036, \u26037, \u2603)) || !EntitySpawnPlacementRegistry.func_223515_a(\u26033.get(), world.func_201672_e(), SpawnReason.SPAWNER, new BlockPos(\u26036, \u26037, \u2603), world.func_201674_k())) continue;
                Entity \u26038 = EntityType.func_220335_a(compoundNBT, world, entity -> {
                    entity.func_70012_b(\u26036, \u26037, \u2603, entity.field_70177_z, entity.field_70125_A);
                    return entity;
                });
                if (\u26038 == null) {
                    this.func_98273_j();
                    return;
                }
                int \u26039 = world.func_217357_a(\u26038.getClass(), new AxisAlignedBB(\u26032.func_177958_n(), \u26032.func_177956_o(), \u26032.func_177952_p(), \u26032.func_177958_n() + 1, \u26032.func_177956_o() + 1, \u26032.func_177952_p() + 1).func_186662_g(this.field_98290_m)).size();
                if (\u26039 >= this.field_98292_k) {
                    this.func_98273_j();
                    return;
                }
                \u26038.func_70012_b(\u26038.field_70165_t, \u26038.field_70163_u, \u26038.field_70161_v, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (\u26038 instanceof MobEntity) {
                    MobEntity mobEntity = (MobEntity)\u26038;
                    if (!mobEntity.func_213380_a(world, SpawnReason.SPAWNER) || !mobEntity.func_205019_a(world)) continue;
                    if (this.field_98282_f.func_185277_b().func_186856_d() == 1 && this.field_98282_f.func_185277_b().func_150297_b("id", 8)) {
                        ((MobEntity)\u26038).func_213386_a(world, world.func_175649_E(new BlockPos(\u26038)), SpawnReason.SPAWNER, null, null);
                    }
                }
                this.func_221409_a(\u26038);
                world.func_217379_c(2004, \u26032, 0);
                if (\u26038 instanceof MobEntity) {
                    ((MobEntity)\u26038).func_70656_aK();
                }
                \u260310 = true;
            }
            if (\u260310) {
                this.func_98273_j();
            }
        }
    }

    private void func_221409_a(Entity entity) {
        if (!this.func_98271_a().func_217376_c(entity)) {
            return;
        }
        for (Entity entity2 : entity.func_184188_bt()) {
            this.func_221409_a(entity2);
        }
    }

    private void func_98273_j() {
        this.field_98286_b = this.field_98293_h <= this.field_98283_g ? this.field_98283_g : this.field_98283_g + this.func_98271_a().field_73012_v.nextInt(this.field_98293_h - this.field_98283_g);
        if (!this.field_98285_e.isEmpty()) {
            this.func_184993_a(WeightedRandom.func_76271_a(this.func_98271_a().field_73012_v, this.field_98285_e));
        }
        this.func_98267_a(1);
    }

    public void func_98270_a(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        this.field_98286_b = compoundNBT2.func_74765_d("Delay");
        this.field_98285_e.clear();
        if (compoundNBT2.func_150297_b("SpawnPotentials", 9)) {
            ListNBT listNBT = compoundNBT2.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < listNBT.size(); ++i) {
                this.field_98285_e.add(new WeightedSpawnerEntity(listNBT.func_150305_b(i)));
            }
        }
        if (compoundNBT2.func_150297_b("SpawnData", 10)) {
            this.func_184993_a(new WeightedSpawnerEntity(1, compoundNBT2.func_74775_l("SpawnData")));
        } else if (!this.field_98285_e.isEmpty()) {
            this.func_184993_a(WeightedRandom.func_76271_a(this.func_98271_a().field_73012_v, this.field_98285_e));
        }
        if (compoundNBT2.func_150297_b("MinSpawnDelay", 99)) {
            this.field_98283_g = compoundNBT2.func_74765_d("MinSpawnDelay");
            this.field_98293_h = compoundNBT2.func_74765_d("MaxSpawnDelay");
            this.field_98294_i = compoundNBT2.func_74765_d("SpawnCount");
        }
        if (compoundNBT2.func_150297_b("MaxNearbyEntities", 99)) {
            this.field_98292_k = compoundNBT2.func_74765_d("MaxNearbyEntities");
            this.field_98289_l = compoundNBT2.func_74765_d("RequiredPlayerRange");
        }
        if (compoundNBT2.func_150297_b("SpawnRange", 99)) {
            this.field_98290_m = compoundNBT2.func_74765_d("SpawnRange");
        }
        if (this.func_98271_a() != null) {
            this.field_98291_j = null;
        }
    }

    public CompoundNBT func_189530_b(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        ResourceLocation resourceLocation = this.func_190895_g();
        if (resourceLocation == null) {
            return compoundNBT2;
        }
        compoundNBT2.func_74777_a("Delay", (short)this.field_98286_b);
        compoundNBT2.func_74777_a("MinSpawnDelay", (short)this.field_98283_g);
        compoundNBT2.func_74777_a("MaxSpawnDelay", (short)this.field_98293_h);
        compoundNBT2.func_74777_a("SpawnCount", (short)this.field_98294_i);
        compoundNBT2.func_74777_a("MaxNearbyEntities", (short)this.field_98292_k);
        compoundNBT2.func_74777_a("RequiredPlayerRange", (short)this.field_98289_l);
        compoundNBT2.func_74777_a("SpawnRange", (short)this.field_98290_m);
        compoundNBT2.func_218657_a("SpawnData", this.field_98282_f.func_185277_b().func_74737_b());
        ListNBT \u26032 = new ListNBT();
        if (this.field_98285_e.isEmpty()) {
            \u26032.add(this.field_98282_f.func_185278_a());
        } else {
            for (WeightedSpawnerEntity weightedSpawnerEntity : this.field_98285_e) {
                \u26032.add(weightedSpawnerEntity.func_185278_a());
            }
        }
        compoundNBT2.func_218657_a("SpawnPotentials", \u26032);
        return compoundNBT2;
    }

    public boolean func_98268_b(int n) {
        if (n == 1 && this.func_98271_a().field_72995_K) {
            this.field_98286_b = this.field_98283_g;
            return true;
        }
        return false;
    }

    public void func_184993_a(WeightedSpawnerEntity weightedSpawnerEntity) {
        this.field_98282_f = weightedSpawnerEntity;
    }

    public abstract void func_98267_a(int var1);

    public abstract World func_98271_a();

    public abstract BlockPos func_177221_b();
}

