/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ILootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.ParentedLootEntry;
import net.minecraft.world.storage.loot.ValidationResults;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import org.apache.commons.lang3.ArrayUtils;

public class AlternativesLootEntry
extends ParentedLootEntry {
    AlternativesLootEntry(LootEntry[] lootEntryArray, ILootCondition[] iLootConditionArray) {
        super(lootEntryArray, iLootConditionArray);
    }

    @Override
    protected ILootEntry func_216146_a(ILootEntry[] iLootEntryArray) {
        switch (iLootEntryArray.length) {
            case 0: {
                return field_216139_a;
            }
            case 1: {
                return iLootEntryArray[0];
            }
            case 2: {
                return iLootEntryArray[0].func_216135_b(iLootEntryArray[1]);
            }
        }
        return (lootContext, consumer) -> {
            for (ILootEntry iLootEntry : iLootEntryArray) {
                if (!iLootEntry.expand(lootContext, consumer)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public void func_216142_a(ValidationResults validationResults, Function<ResourceLocation, LootTable> function, Set<ResourceLocation> set, LootParameterSet lootParameterSet) {
        super.func_216142_a(validationResults, function, set, lootParameterSet);
        for (int i = 0; i < this.field_216147_c.length - 1; ++i) {
            if (!ArrayUtils.isEmpty((Object[])this.field_216147_c[i].field_216144_d)) continue;
            validationResults.func_216105_a("Unreachable entry!");
        }
    }

    public static Builder func_216149_a(LootEntry.Builder<?> ... builderArray) {
        return new Builder(builderArray);
    }

    public static class Builder
    extends LootEntry.Builder<Builder> {
        private final List<LootEntry> field_216083_a = Lists.newArrayList();

        public Builder(LootEntry.Builder<?> ... builderArray) {
            for (LootEntry.Builder<?> builder : builderArray) {
                this.field_216083_a.add(builder.func_216081_b());
            }
        }

        @Override
        protected Builder func_212845_d_() {
            return this;
        }

        @Override
        public Builder func_216080_a(LootEntry.Builder<?> builder) {
            this.field_216083_a.add(builder.func_216081_b());
            return this;
        }

        @Override
        public LootEntry func_216081_b() {
            return new AlternativesLootEntry(this.field_216083_a.toArray(new LootEntry[0]), this.func_216079_f());
        }

        @Override
        protected /* synthetic */ LootEntry.Builder func_212845_d_() {
            return this.func_212845_d_();
        }
    }
}

