/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.ValidationResults;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.functions.ILootFunction;

public class TableLootEntry
extends StandaloneLootEntry {
    private final ResourceLocation field_186371_a;

    private TableLootEntry(ResourceLocation resourceLocation, int n, int n2, ILootCondition[] iLootConditionArray, ILootFunction[] iLootFunctionArray) {
        super(n, n2, iLootConditionArray, iLootFunctionArray);
        this.field_186371_a = resourceLocation;
    }

    @Override
    public void func_216154_a(Consumer<ItemStack> consumer, LootContext lootContext) {
        LootTable lootTable = lootContext.func_186497_e().func_186521_a(this.field_186371_a);
        lootTable.func_216114_a(lootContext, consumer);
    }

    @Override
    public void func_216142_a(ValidationResults validationResults, Function<ResourceLocation, LootTable> function, Set<ResourceLocation> set, LootParameterSet lootParameterSet) {
        if (set.contains(this.field_186371_a)) {
            validationResults.func_216105_a("Table " + this.field_186371_a + " is recursively called");
            return;
        }
        super.func_216142_a(validationResults, function, set, lootParameterSet);
        LootTable lootTable = function.apply(this.field_186371_a);
        if (lootTable == null) {
            validationResults.func_216105_a("Unknown loot table called " + this.field_186371_a);
        } else {
            ImmutableSet immutableSet = ImmutableSet.builder().addAll(set).add((Object)this.field_186371_a).build();
            lootTable.func_216117_a(validationResults.func_216108_b("->{" + this.field_186371_a + "}"), function, (Set<ResourceLocation>)immutableSet, lootParameterSet);
        }
    }

    public static StandaloneLootEntry.Builder<?> func_216171_a(ResourceLocation resourceLocation) {
        return TableLootEntry.func_216156_a((n, n2, iLootConditionArray, iLootFunctionArray) -> new TableLootEntry(resourceLocation, n, n2, iLootConditionArray, iLootFunctionArray));
    }

    public static class Serializer
    extends StandaloneLootEntry.Serializer<TableLootEntry> {
        public Serializer() {
            super(new ResourceLocation("loot_table"), TableLootEntry.class);
        }

        @Override
        public void func_212830_a_(JsonObject jsonObject, TableLootEntry tableLootEntry, JsonSerializationContext jsonSerializationContext) {
            super.func_212830_a_(jsonObject, tableLootEntry, jsonSerializationContext);
            jsonObject.addProperty("name", tableLootEntry.field_186371_a.toString());
        }

        @Override
        protected TableLootEntry func_212829_b_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, int n, int n2, ILootCondition[] iLootConditionArray, ILootFunction[] iLootFunctionArray) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "name"));
            return new TableLootEntry(resourceLocation, n, n2, iLootConditionArray, iLootFunctionArray);
        }

        @Override
        protected /* synthetic */ StandaloneLootEntry func_212829_b_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, int n, int n2, ILootCondition[] iLootConditionArray, ILootFunction[] iLootFunctionArray) {
            return this.func_212829_b_(jsonObject, jsonDeserializationContext, n, n2, iLootConditionArray, iLootFunctionArray);
        }
    }
}

