/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.ValidationResults;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class SetLootTable
extends LootFunction {
    private final ResourceLocation field_215928_a;
    private final long field_215929_c;

    private SetLootTable(ILootCondition[] iLootConditionArray, ResourceLocation resourceLocation, long l) {
        super(iLootConditionArray);
        this.field_215928_a = resourceLocation;
        this.field_215929_c = l;
    }

    @Override
    public ItemStack func_215859_a(ItemStack itemStack, LootContext lootContext) {
        if (itemStack.func_190926_b()) {
            return itemStack;
        }
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a("LootTable", this.field_215928_a.toString());
        if (this.field_215929_c != 0L) {
            compoundNBT.func_74772_a("LootTableSeed", this.field_215929_c);
        }
        itemStack.func_196082_o().func_218657_a("BlockEntityTag", compoundNBT);
        return itemStack;
    }

    @Override
    public void func_215856_a(ValidationResults validationResults, Function<ResourceLocation, LootTable> function, Set<ResourceLocation> set, LootParameterSet lootParameterSet) {
        if (set.contains(this.field_215928_a)) {
            validationResults.func_216105_a("Table " + this.field_215928_a + " is recursively called");
            return;
        }
        super.func_215856_a(validationResults, function, set, lootParameterSet);
        LootTable lootTable = function.apply(this.field_215928_a);
        if (lootTable == null) {
            validationResults.func_216105_a("Unknown loot table called " + this.field_215928_a);
        } else {
            ImmutableSet immutableSet = ImmutableSet.builder().addAll(set).add((Object)this.field_215928_a).build();
            lootTable.func_216117_a(validationResults.func_216108_b("->{" + this.field_215928_a + "}"), function, (Set<ResourceLocation>)immutableSet, lootParameterSet);
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<SetLootTable> {
        protected Serializer() {
            super(new ResourceLocation("set_loot_table"), SetLootTable.class);
        }

        @Override
        public void func_186532_a(JsonObject jsonObject, SetLootTable setLootTable, JsonSerializationContext jsonSerializationContext) {
            super.func_186532_a(jsonObject, setLootTable, jsonSerializationContext);
            jsonObject.addProperty("name", setLootTable.field_215928_a.toString());
            if (setLootTable.field_215929_c != 0L) {
                jsonObject.addProperty("seed", (Number)setLootTable.field_215929_c);
            }
        }

        @Override
        public SetLootTable func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "name"));
            long \u26032 = JSONUtils.func_219796_a(jsonObject, "seed", 0L);
            return new SetLootTable(iLootConditionArray, resourceLocation, \u26032);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }
}

