/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class CactusBlock
extends Block
implements IPlantable {
    public static final IntegerProperty field_176587_a = BlockStateProperties.field_208171_X;
    protected static final VoxelShape field_196400_b = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);
    protected static final VoxelShape field_196401_c = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    protected CactusBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176587_a, Integer.valueOf(0))));
    }

    @Override
    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.func_196955_c(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        } else {
            BlockPos blockpos = pos.func_177984_a();
            if (worldIn.func_175623_d(blockpos)) {
                int i = 1;
                while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                    ++i;
                }
                if (i < 3) {
                    int j = (Integer)state.func_177229_b((IProperty)field_176587_a);
                    if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)blockpos, (BlockState)state, (boolean)true)) {
                        if (j == 15) {
                            worldIn.func_175656_a(blockpos, this.func_176223_P());
                            BlockState blockstate = (BlockState)((Object)state.func_206870_a((IProperty)field_176587_a, Integer.valueOf(0)));
                            worldIn.func_180501_a(pos, blockstate, 4);
                            blockstate.func_215697_a(worldIn, blockpos, this, pos, false);
                        } else {
                            worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((IProperty)field_176587_a, Integer.valueOf(j + 1))), 4);
                        }
                        ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
                    }
                }
            }
        }
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return field_196400_b;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return field_196401_c;
    }

    @Override
    public boolean func_200124_e(BlockState state) {
        return true;
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c(worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
            Material material = blockstate.func_185904_a();
            if (!material.func_76220_a() && !worldIn.func_204610_c(pos.func_177972_a(direction)).func_206884_a(FluidTags.field_206960_b)) continue;
            return false;
        }
        BlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return soil.canSustainPlant((IBlockReader)worldIn, pos.func_177977_b(), Direction.UP, this) && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d();
    }

    @Override
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176587_a});
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.Desert;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }
}

