/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChorusPlantBlock;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ChorusFlowerBlock
extends Block {
    public static final IntegerProperty field_185607_a = BlockStateProperties.field_208169_V;
    private final ChorusPlantBlock field_196405_b;

    protected ChorusFlowerBlock(ChorusPlantBlock p_i48429_1_, Block.Properties builder) {
        super(builder);
        this.field_196405_b = p_i48429_1_;
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185607_a, Integer.valueOf(0))));
    }

    @Override
    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!state.func_196955_c(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        } else {
            int i;
            BlockPos blockpos = pos.func_177984_a();
            if (worldIn.func_175623_d(blockpos) && blockpos.func_177956_o() < worldIn.func_201675_m().getHeight() && (i = ((Integer)state.func_177229_b((IProperty)field_185607_a)).intValue()) < 5 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)blockpos, (BlockState)state, (boolean)true)) {
                boolean flag = false;
                boolean flag1 = false;
                BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
                Block block = blockstate.func_177230_c();
                if (block == Blocks.field_150377_bs) {
                    flag = true;
                } else if (block == this.field_196405_b) {
                    int j = 1;
                    for (int k = 0; k < 4; ++k) {
                        Block block1 = worldIn.func_180495_p(pos.func_177979_c(j + 1)).func_177230_c();
                        if (block1 != this.field_196405_b) {
                            if (block1 != Blocks.field_150377_bs) break;
                            flag1 = true;
                            break;
                        }
                        ++j;
                    }
                    if (j < 2 || j <= random.nextInt(flag1 ? 5 : 4)) {
                        flag = true;
                    }
                } else if (blockstate.isAir((IBlockReader)worldIn, pos.func_177977_b())) {
                    flag = true;
                }
                if (flag && ChorusFlowerBlock.func_185604_a(worldIn, blockpos, null) && worldIn.func_175623_d(pos.func_177981_b(2))) {
                    worldIn.func_180501_a(pos, this.field_196405_b.func_196497_a((IBlockReader)worldIn, pos), 2);
                    this.func_185602_a(worldIn, blockpos, i);
                } else if (i < 4) {
                    int l = random.nextInt(4);
                    if (flag1) {
                        ++l;
                    }
                    boolean flag2 = false;
                    for (int i1 = 0; i1 < l; ++i1) {
                        Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(random);
                        BlockPos blockpos1 = pos.func_177972_a(direction);
                        if (!worldIn.func_175623_d(blockpos1) || !worldIn.func_175623_d(blockpos1.func_177977_b()) || !ChorusFlowerBlock.func_185604_a(worldIn, blockpos1, direction.func_176734_d())) continue;
                        this.func_185602_a(worldIn, blockpos1, i + 1);
                        flag2 = true;
                    }
                    if (flag2) {
                        worldIn.func_180501_a(pos, this.field_196405_b.func_196497_a((IBlockReader)worldIn, pos), 2);
                    } else {
                        this.func_185605_c(worldIn, pos);
                    }
                } else {
                    this.func_185605_c(worldIn, pos);
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    private void func_185602_a(World worldIn, BlockPos pos, int age) {
        worldIn.func_180501_a(pos, (BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_185607_a, Integer.valueOf(age))), 2);
        worldIn.func_217379_c(1033, pos, 0);
    }

    private void func_185605_c(World worldIn, BlockPos pos) {
        worldIn.func_180501_a(pos, (BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_185607_a, Integer.valueOf(5))), 2);
        worldIn.func_217379_c(1034, pos, 0);
    }

    private static boolean func_185604_a(IWorldReader worldIn, BlockPos pos, @Nullable Direction excludingSide) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (direction == excludingSide || worldIn.func_175623_d(pos.func_177972_a(direction))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing != Direction.UP && !stateIn.func_196955_c(worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = blockstate.func_177230_c();
        if (block != this.field_196405_b && block != Blocks.field_150377_bs) {
            if (!blockstate.isAir((IBlockReader)worldIn, pos.func_177977_b())) {
                return false;
            }
            boolean flag = false;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate1 = worldIn.func_180495_p(pos.func_177972_a(direction));
                if (blockstate1.func_177230_c() == this.field_196405_b) {
                    if (flag) {
                        return false;
                    }
                    flag = true;
                    continue;
                }
                if (blockstate1.isAir((IBlockReader)worldIn, pos.func_177972_a(direction))) continue;
                return false;
            }
            return flag;
        }
        return true;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185607_a});
    }

    public static void func_185603_a(IWorld worldIn, BlockPos pos, Random rand, int p_185603_3_) {
        worldIn.func_180501_a(pos, ((ChorusPlantBlock)Blocks.field_185765_cR).func_196497_a((IBlockReader)worldIn, pos), 2);
        ChorusFlowerBlock.func_185601_a(worldIn, pos, rand, pos, p_185603_3_, 0);
    }

    private static void func_185601_a(IWorld worldIn, BlockPos p_185601_1_, Random rand, BlockPos p_185601_3_, int p_185601_4_, int p_185601_5_) {
        ChorusPlantBlock chorusplantblock = (ChorusPlantBlock)Blocks.field_185765_cR;
        int i = rand.nextInt(4) + 1;
        if (p_185601_5_ == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            BlockPos blockpos = p_185601_1_.func_177981_b(j + 1);
            if (!ChorusFlowerBlock.func_185604_a(worldIn, blockpos, null)) {
                return;
            }
            worldIn.func_180501_a(blockpos, chorusplantblock.func_196497_a((IBlockReader)worldIn, blockpos), 2);
            worldIn.func_180501_a(blockpos.func_177977_b(), chorusplantblock.func_196497_a((IBlockReader)worldIn, blockpos.func_177977_b()), 2);
        }
        boolean flag = false;
        if (p_185601_5_ < 4) {
            int l = rand.nextInt(4);
            if (p_185601_5_ == 0) {
                ++l;
            }
            for (int k = 0; k < l; ++k) {
                Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                BlockPos blockpos1 = p_185601_1_.func_177981_b(i).func_177972_a(direction);
                if (Math.abs(blockpos1.func_177958_n() - p_185601_3_.func_177958_n()) >= p_185601_4_ || Math.abs(blockpos1.func_177952_p() - p_185601_3_.func_177952_p()) >= p_185601_4_ || !worldIn.func_175623_d(blockpos1) || !worldIn.func_175623_d(blockpos1.func_177977_b()) || !ChorusFlowerBlock.func_185604_a(worldIn, blockpos1, direction.func_176734_d())) continue;
                flag = true;
                worldIn.func_180501_a(blockpos1, chorusplantblock.func_196497_a((IBlockReader)worldIn, blockpos1), 2);
                worldIn.func_180501_a(blockpos1.func_177972_a(direction.func_176734_d()), chorusplantblock.func_196497_a((IBlockReader)worldIn, blockpos1.func_177972_a(direction.func_176734_d())), 2);
                ChorusFlowerBlock.func_185601_a(worldIn, blockpos1, rand, p_185601_3_, p_185601_4_, p_185601_5_ + 1);
            }
        }
        if (!flag) {
            worldIn.func_180501_a(p_185601_1_.func_177981_b(i), (BlockState)((Object)Blocks.field_185766_cS.func_176223_P().func_206870_a((IProperty)field_185607_a, Integer.valueOf(5))), 2);
        }
    }

    @Override
    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, Entity projectile) {
        BlockPos blockpos = hit.func_216350_a();
        ChorusFlowerBlock.func_180635_a(worldIn, blockpos, new ItemStack(this));
        worldIn.func_175655_b(blockpos, true);
    }
}

