/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public class CropsBlock
extends BushBlock
implements IGrowable {
    public static final IntegerProperty field_176488_a = BlockStateProperties.field_208170_W;
    private static final VoxelShape[] field_196393_a = new VoxelShape[]{Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 6.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 10.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 14.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)};

    protected CropsBlock(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)this.func_185524_e(), Integer.valueOf(0))));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return field_196393_a[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    @Override
    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    public IntegerProperty func_185524_e() {
        return field_176488_a;
    }

    public int func_185526_g() {
        return 7;
    }

    protected int func_185527_x(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.func_185524_e());
    }

    public BlockState func_185528_e(int age) {
        return (BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)this.func_185524_e(), Integer.valueOf(age)));
    }

    public boolean func_185525_y(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.func_185524_e()) >= this.func_185526_g();
    }

    @Override
    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        float f;
        int i;
        super.func_196267_b(state, worldIn, pos, random);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_201669_a(pos, 0) >= 9 && (i = this.func_185527_x(state)) < this.func_185526_g() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (f = CropsBlock.func_180672_a(this, (IBlockReader)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, this.func_185528_e(i + 1), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void func_176487_g(World worldIn, BlockPos pos, BlockState state) {
        int j;
        int i = this.func_185527_x(state) + this.func_185529_b(worldIn);
        if (i > (j = this.func_185526_g())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.func_185528_e(i), 2);
    }

    protected int func_185529_b(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    protected static float func_180672_a(Block blockIn, IBlockReader worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (blockstate.canSustainPlant(worldIn, blockpos.func_177982_a(i, 0, j), Direction.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(worldIn, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return (worldIn.func_201669_a(pos, 0) >= 8 || worldIn.func_217337_f(pos)) && super.func_196260_a(state, worldIn, pos);
    }

    @Override
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof RavagerEntity && ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entityIn)) {
            worldIn.func_175655_b(pos, true);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    protected IItemProvider func_199772_f() {
        return Items.field_151014_N;
    }

    @Override
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this.func_199772_f());
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.func_185525_y(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, BlockState state) {
        this.func_176487_g(worldIn, pos, state);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176488_a});
    }
}

