/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class FlowerPotBlock
extends Block {
    private static final Map<Block, Block> field_196451_b = Maps.newHashMap();
    protected static final VoxelShape field_196450_a = Block.func_208617_a(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final Block field_196452_c = null;
    private final Map<ResourceLocation, Supplier<? extends Block>> fullPots;
    private final Supplier<FlowerPotBlock> emptyPot;
    private final Supplier<? extends Block> flowerDelegate;

    @Deprecated
    public FlowerPotBlock(Block p_i48395_1_, Block.Properties p_i48395_2_) {
        this(Blocks.field_150457_bL == null ? null : () -> (FlowerPotBlock)((Object)((Object)Blocks.field_150457_bL.delegate.get())), () -> (Block)((Object)((Object)p_i48395_1_.delegate.get())), p_i48395_2_);
        if (Blocks.field_150457_bL != null) {
            ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(p_i48395_1_.getRegistryName(), () -> this);
        }
    }

    public FlowerPotBlock(@Nullable Supplier<FlowerPotBlock> emptyPot, Supplier<? extends Block> p_i48395_1_, Block.Properties p_i48395_2_) {
        super(p_i48395_2_);
        this.flowerDelegate = p_i48395_1_;
        if (emptyPot == null) {
            this.fullPots = Maps.newHashMap();
            this.emptyPot = null;
        } else {
            this.fullPots = Collections.emptyMap();
            this.emptyPot = emptyPot;
        }
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return field_196450_a;
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean flag1;
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        Block block = item instanceof BlockItem ? this.getEmptyPot().fullPots.getOrDefault(((BlockItem)item).func_179223_d().getRegistryName(), (Supplier<? extends Block>)Blocks.field_150350_a.delegate).get() : Blocks.field_150350_a;
        boolean flag = block == Blocks.field_150350_a;
        boolean bl = flag1 = this.field_196452_c == Blocks.field_150350_a;
        if (flag != flag1) {
            if (flag1) {
                worldIn.func_180501_a(pos, block.func_176223_P(), 3);
                player.func_195066_a(Stats.field_188088_V);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            } else {
                ItemStack itemstack1 = new ItemStack(this.field_196452_c);
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(handIn, itemstack1);
                } else if (!player.func_191521_c(itemstack1)) {
                    player.func_71019_a(itemstack1, false);
                }
                worldIn.func_180501_a(pos, this.getEmptyPot().func_176223_P(), 3);
            }
        }
        return true;
    }

    @Override
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return this.field_196452_c == Blocks.field_150350_a ? super.func_185473_a(worldIn, pos, state) : new ItemStack(this.field_196452_c);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.func_196955_c(worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public Block func_220276_d() {
        return this.flowerDelegate.get();
    }

    public FlowerPotBlock getEmptyPot() {
        return this.emptyPot == null ? this : this.emptyPot.get();
    }

    public void addPlant(ResourceLocation flower, Supplier<? extends Block> fullPot) {
        if (this.getEmptyPot() != this) {
            throw new IllegalArgumentException("Cannot add plant to non-empty pot: " + (Object)((Object)this));
        }
        this.fullPots.put(flower, fullPot);
    }
}

