/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;

public class LeavesBlock
extends Block
implements IShearable {
    public static final IntegerProperty field_208494_a = BlockStateProperties.field_208514_aa;
    public static final BooleanProperty field_208495_b = BlockStateProperties.field_208515_s;
    protected static boolean field_196478_c;

    public LeavesBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_208494_a, Integer.valueOf(7)))).func_206870_a((IProperty)field_208495_b, Boolean.valueOf(false))));
    }

    @Override
    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)field_208494_a) == 7 && (Boolean)state.func_177229_b((IProperty)field_208495_b) == false;
    }

    @Override
    public void func_196265_a(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((IProperty)field_208495_b)).booleanValue() && (Integer)state.func_177229_b((IProperty)field_208494_a) == 7) {
            LeavesBlock.func_220075_c(state, worldIn, pos);
            worldIn.func_217377_a(pos, false);
        }
    }

    @Override
    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        worldIn.func_180501_a(pos, LeavesBlock.func_208493_b(state, worldIn, pos), 3);
    }

    @Override
    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1;
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = LeavesBlock.func_208492_w(facingState) + 1;
        if (i != 1 || (Integer)stateIn.func_177229_b((IProperty)field_208494_a) != i) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return stateIn;
    }

    private static BlockState func_208493_b(BlockState p_208493_0_, IWorld p_208493_1_, BlockPos p_208493_2_) {
        int i = 7;
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (Direction direction : Direction.values()) {
                blockpos$pooledmutableblockpos.func_189533_g((Vec3i)p_208493_2_).func_189536_c(direction);
                i = Math.min(i, LeavesBlock.func_208492_w(p_208493_1_.func_180495_p((BlockPos)blockpos$pooledmutableblockpos)) + 1);
                if (i != 1) continue;
                break;
            }
        }
        return (BlockState)((Object)p_208493_0_.func_206870_a((IProperty)field_208494_a, Integer.valueOf(i)));
    }

    private static int func_208492_w(BlockState neighbor) {
        if (BlockTags.field_200031_h.func_199685_a_(neighbor.func_177230_c())) {
            return 0;
        }
        return neighbor.func_177230_c() instanceof LeavesBlock ? (Integer)neighbor.func_177229_b((IProperty)field_208494_a) : 7;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!worldIn.func_175727_C(pos.func_177984_a()) || rand.nextInt(15) != 1 || (blockstate = worldIn.func_180495_p(blockpos = pos.func_177977_b())).func_200132_m() && blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP))) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197618_k, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_196475_b(boolean fancy) {
        field_196478_c = fancy;
    }

    @Override
    public boolean func_200124_e(BlockState state) {
        return false;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return field_196478_c ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    @Override
    public boolean func_220060_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    @Override
    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return type == EntityType.field_200781_U || type == EntityType.field_200783_W;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_208494_a, field_208495_b});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return LeavesBlock.func_208493_b((BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_208495_b, Boolean.valueOf(true))), context.func_195991_k(), context.func_195995_a());
    }
}

