/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StairsBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty field_176309_a = HorizontalBlock.field_185512_D;
    public static final EnumProperty<Half> field_176308_b = BlockStateProperties.field_208164_Q;
    public static final EnumProperty<StairsShape> field_176310_M = BlockStateProperties.field_208146_au;
    public static final BooleanProperty field_204513_t = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_185712_d = SlabBlock.field_196507_c;
    protected static final VoxelShape field_185719_G = SlabBlock.field_196506_b;
    protected static final VoxelShape field_196512_A = Block.func_208617_a(0.0, 0.0, 0.0, 8.0, 8.0, 8.0);
    protected static final VoxelShape field_196513_B = Block.func_208617_a(0.0, 0.0, 8.0, 8.0, 8.0, 16.0);
    protected static final VoxelShape field_196514_C = Block.func_208617_a(0.0, 8.0, 0.0, 8.0, 16.0, 8.0);
    protected static final VoxelShape field_196515_D = Block.func_208617_a(0.0, 8.0, 8.0, 8.0, 16.0, 16.0);
    protected static final VoxelShape field_196516_E = Block.func_208617_a(8.0, 0.0, 0.0, 16.0, 8.0, 8.0);
    protected static final VoxelShape field_196517_F = Block.func_208617_a(8.0, 0.0, 8.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape field_196518_G = Block.func_208617_a(8.0, 8.0, 0.0, 16.0, 16.0, 8.0);
    protected static final VoxelShape field_196519_H = Block.func_208617_a(8.0, 8.0, 8.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] field_196520_I = StairsBlock.func_199779_a(field_185712_d, field_196512_A, field_196516_E, field_196513_B, field_196517_F);
    protected static final VoxelShape[] field_196521_J = StairsBlock.func_199779_a(field_185719_G, field_196514_C, field_196518_G, field_196515_D, field_196519_H);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block field_150149_b;
    private final BlockState field_150151_M;
    private final Supplier<BlockState> stateSupplier;

    private static VoxelShape[] func_199779_a(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> StairsBlock.func_199781_a(p_199780_5_, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape func_199781_a(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    @Deprecated
    protected StairsBlock(BlockState state, Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176309_a, (Comparable)((Object)Direction.NORTH)))).func_206870_a((IProperty)field_176308_b, (Comparable)Half.BOTTOM))).func_206870_a((IProperty)field_176310_M, (Comparable)StairsShape.STRAIGHT))).func_206870_a((IProperty)field_204513_t, Boolean.valueOf(false))));
        this.field_150149_b = state.func_177230_c();
        this.field_150151_M = state;
        this.stateSupplier = () -> state;
    }

    public StairsBlock(Supplier<BlockState> state, Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176309_a, (Comparable)((Object)Direction.NORTH)))).func_206870_a((IProperty)field_176308_b, (Comparable)Half.BOTTOM))).func_206870_a((IProperty)field_176310_M, (Comparable)StairsShape.STRAIGHT))).func_206870_a((IProperty)field_204513_t, Boolean.valueOf(false))));
        this.field_150149_b = Blocks.field_150350_a;
        this.field_150151_M = Blocks.field_150350_a.func_176223_P();
        this.stateSupplier = state;
    }

    @Override
    public boolean func_220074_n(BlockState state) {
        return true;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (state.func_177229_b((IProperty)field_176308_b) == Half.TOP ? field_196520_I : field_196521_J)[field_196522_K[this.func_196511_x(state)]];
    }

    private int func_196511_x(BlockState state) {
        return ((StairsShape)state.func_177229_b((IProperty)field_176310_M)).ordinal() * 4 + ((Direction)((Object)state.func_177229_b((IProperty)field_176309_a))).func_176736_b();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.field_150149_b.func_180655_c(stateIn, worldIn, pos, rand);
    }

    @Override
    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        this.field_150151_M.func_196942_a(worldIn, pos, player);
    }

    @Override
    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        this.field_150149_b.func_176206_d(worldIn, pos, state);
    }

    @Override
    public float func_149638_a() {
        return this.field_150149_b.func_149638_a();
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return this.field_150149_b.func_180664_k();
    }

    @Override
    public int func_149738_a(IWorldReader worldIn) {
        return this.field_150149_b.func_149738_a(worldIn);
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177230_c() != state.func_177230_c()) {
            this.field_150151_M.func_215697_a(worldIn, pos, Blocks.field_150350_a, pos, false);
            this.field_150149_b.func_220082_b(this.field_150151_M, worldIn, pos, oldState, false);
        }
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.field_150151_M.func_196947_b(worldIn, pos, newState, isMoving);
        }
    }

    @Override
    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.field_150149_b.func_176199_a(worldIn, pos, entityIn);
    }

    @Override
    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        this.field_150149_b.func_196267_b(state, worldIn, pos, random);
    }

    @Override
    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return this.field_150151_M.func_215687_a(worldIn, player, handIn, hit);
    }

    @Override
    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.field_150149_b.func_180652_a(worldIn, pos, explosionIn);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate = (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_176309_a, (Comparable)((Object)context.func_195992_f())))).func_206870_a((IProperty)field_176308_b, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? Half.BOTTOM : Half.TOP)))).func_206870_a((IProperty)field_204513_t, Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a)));
        return (BlockState)((Object)blockstate.func_206870_a((IProperty)field_176310_M, (Comparable)StairsBlock.func_208064_n(blockstate, (IBlockReader)context.func_195991_k(), blockpos)));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)field_204513_t)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)((Object)stateIn.func_206870_a((IProperty)field_176310_M, (Comparable)StairsBlock.func_208064_n(stateIn, (IBlockReader)worldIn, currentPos))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static StairsShape func_208064_n(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)((Object)state.func_177229_b((IProperty)field_176309_a));
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (StairsBlock.func_185709_i(blockstate) && state.func_177229_b((IProperty)field_176308_b) == blockstate.func_177229_b((IProperty)field_176308_b) && (direction1 = (Direction)((Object)blockstate.func_177229_b((IProperty)field_176309_a))).func_176740_k() != ((Direction)((Object)state.func_177229_b((IProperty)field_176309_a))).func_176740_k() && StairsBlock.func_185704_d(state, worldIn, pos, direction1.func_176734_d())) {
            if (direction1 == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (StairsBlock.func_185709_i(blockstate1) && state.func_177229_b((IProperty)field_176308_b) == blockstate1.func_177229_b((IProperty)field_176308_b) && (direction2 = (Direction)((Object)blockstate1.func_177229_b((IProperty)field_176309_a))).func_176740_k() != ((Direction)((Object)state.func_177229_b((IProperty)field_176309_a))).func_176740_k() && StairsBlock.func_185704_d(state, worldIn, pos, direction2)) {
            if (direction2 == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean func_185704_d(BlockState state, IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(face));
        return !StairsBlock.func_185709_i(blockstate) || blockstate.func_177229_b((IProperty)field_176309_a) != state.func_177229_b((IProperty)field_176309_a) || blockstate.func_177229_b((IProperty)field_176308_b) != state.func_177229_b((IProperty)field_176308_b);
    }

    public static boolean func_185709_i(BlockState state) {
        return state.func_177230_c() instanceof StairsBlock;
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)((Object)state.func_206870_a((IProperty)field_176309_a, (Comparable)((Object)rot.func_185831_a((Direction)((Object)state.func_177229_b((IProperty)field_176309_a))))));
    }

    @Override
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)((Object)state.func_177229_b((IProperty)field_176309_a));
        StairsShape stairsshape = (StairsShape)state.func_177229_b((IProperty)field_176310_M);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.func_176740_k() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)((Object)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((IProperty)field_176310_M, (Comparable)StairsShape.INNER_RIGHT));
                    }
                    case INNER_RIGHT: {
                        return (BlockState)((Object)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((IProperty)field_176310_M, (Comparable)StairsShape.INNER_LEFT));
                    }
                    case OUTER_LEFT: {
                        return (BlockState)((Object)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((IProperty)field_176310_M, (Comparable)StairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)((Object)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((IProperty)field_176310_M, (Comparable)StairsShape.OUTER_LEFT));
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.func_176740_k() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)((Object)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((IProperty)field_176310_M, (Comparable)StairsShape.INNER_LEFT));
                    }
                    case INNER_RIGHT: {
                        return (BlockState)((Object)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((IProperty)field_176310_M, (Comparable)StairsShape.INNER_RIGHT));
                    }
                    case OUTER_LEFT: {
                        return (BlockState)((Object)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((IProperty)field_176310_M, (Comparable)StairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)((Object)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((IProperty)field_176310_M, (Comparable)StairsShape.OUTER_LEFT));
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176309_a, field_176308_b, field_176310_M, field_204513_t});
    }

    @Override
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_204513_t) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    private Block getModelBlock() {
        return this.getModelState().func_177230_c();
    }

    private BlockState getModelState() {
        return this.stateSupplier.get();
    }
}

