/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GLX;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.IForgeRenderChunk;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class ChunkRender
implements IForgeRenderChunk {
    private volatile World field_178588_d;
    private final WorldRenderer field_178589_e;
    public static int field_178592_a;
    public CompiledChunk field_178590_b = CompiledChunk.field_178502_a;
    private final ReentrantLock field_178587_g = new ReentrantLock();
    private final ReentrantLock field_178598_h = new ReentrantLock();
    private ChunkRenderTask field_178599_i;
    private final Set<TileEntity> field_181056_j = Sets.newHashSet();
    private final VertexBuffer[] field_178594_l = new VertexBuffer[BlockRenderLayer.values().length];
    public AxisAlignedBB field_178591_c;
    private int field_178595_m = -1;
    private boolean field_178593_n = true;
    private final BlockPos.MutableBlockPos field_178586_f = new BlockPos.MutableBlockPos(-1, -1, -1);
    private final BlockPos.MutableBlockPos[] field_181702_p = (BlockPos.MutableBlockPos[])Util.func_200696_a((Object)new BlockPos.MutableBlockPos[6], p_205125_0_ -> {
        for (int j = 0; j < ((BlockPos.MutableBlockPos[])p_205125_0_).length; ++j) {
            p_205125_0_[j] = new BlockPos.MutableBlockPos();
        }
    });
    private boolean field_188284_q;

    public ChunkRender(World worldIn, WorldRenderer worldRendererIn) {
        this.field_178588_d = worldIn;
        this.field_178589_e = worldRendererIn;
        if (GLX.useVbo()) {
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                this.field_178594_l[i] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            }
        }
    }

    private static boolean func_217673_a(BlockPos pos, World worldIn) {
        return !worldIn.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_76621_g();
    }

    public boolean func_217674_b() {
        int i = 24;
        if (!(this.func_188280_f() > 576.0)) {
            return true;
        }
        World world = this.func_188283_p();
        return ChunkRender.func_217673_a((BlockPos)this.field_181702_p[Direction.WEST.ordinal()], world) && ChunkRender.func_217673_a((BlockPos)this.field_181702_p[Direction.NORTH.ordinal()], world) && ChunkRender.func_217673_a((BlockPos)this.field_181702_p[Direction.EAST.ordinal()], world) && ChunkRender.func_217673_a((BlockPos)this.field_181702_p[Direction.SOUTH.ordinal()], world);
    }

    public boolean func_178577_a(int frameIndexIn) {
        if (this.field_178595_m == frameIndexIn) {
            return false;
        }
        this.field_178595_m = frameIndexIn;
        return true;
    }

    public VertexBuffer func_178565_b(int layer) {
        return this.field_178594_l[layer];
    }

    public void func_189562_a(int x, int y, int z) {
        if (x != this.field_178586_f.func_177958_n() || y != this.field_178586_f.func_177956_o() || z != this.field_178586_f.func_177952_p()) {
            this.func_178585_h();
            this.field_178586_f.func_181079_c(x, y, z);
            this.field_178591_c = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 16), (double)(y + 16), (double)(z + 16));
            for (Direction direction : Direction.values()) {
                this.field_181702_p[direction.ordinal()].func_189533_g((Vec3i)this.field_178586_f).func_189534_c(direction, 16);
            }
        }
    }

    public void func_178570_a(float x, float y, float z, ChunkRenderTask generator) {
        CompiledChunk compiledchunk = generator.func_178544_c();
        if (compiledchunk.func_178487_c() != null && !compiledchunk.func_178491_b(BlockRenderLayer.TRANSLUCENT)) {
            this.func_178573_a(generator.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT), (BlockPos)this.field_178586_f);
            generator.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT).func_178993_a(compiledchunk.func_178487_c());
            this.func_178584_a(BlockRenderLayer.TRANSLUCENT, x, y, z, generator.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT), compiledchunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_178581_b(float x, float y, float z, ChunkRenderTask generator) {
        CompiledChunk compiledchunk = new CompiledChunk();
        boolean i = true;
        BlockPos blockpos = this.field_178586_f.func_185334_h();
        BlockPos blockpos1 = blockpos.func_177982_a(15, 15, 15);
        World world = this.field_178588_d;
        if (world != null) {
            generator.func_178540_f().lock();
            try {
                if (generator.func_178546_a() != ChunkRenderTask.Status.COMPILING) {
                    return;
                }
                generator.func_178543_a(compiledchunk);
            }
            finally {
                generator.func_178540_f().unlock();
            }
            VisGraph lvt_10_1_ = new VisGraph();
            HashSet lvt_11_1_ = Sets.newHashSet();
            ChunkRenderCache lvt_12_1_ = generator.func_217667_c();
            if (lvt_12_1_ != null) {
                ++field_178592_a;
                boolean[] aboolean = new boolean[BlockRenderLayer.values().length];
                BlockModelRenderer.func_211847_a();
                Random random = new Random();
                BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                for (BlockPos blockpos2 : BlockPos.func_218278_a((BlockPos)blockpos, (BlockPos)blockpos1)) {
                    TileEntityRenderer<TileEntity> tileentityrenderer;
                    TileEntity tileentity;
                    BlockState blockstate = lvt_12_1_.func_180495_p(blockpos2);
                    Block block = blockstate.func_177230_c();
                    if (blockstate.func_200015_d((IBlockReader)lvt_12_1_, blockpos2)) {
                        lvt_10_1_.func_178606_a(blockpos2);
                    }
                    if (blockstate.hasTileEntity() && (tileentity = lvt_12_1_.func_212399_a(blockpos2, Chunk.CreateEntityType.CHECK)) != null && (tileentityrenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileentity)) != null) {
                        if (tileentityrenderer.func_188185_a(tileentity)) {
                            lvt_11_1_.add(tileentity);
                        } else {
                            compiledchunk.func_178490_a(tileentity);
                        }
                    }
                    IFluidState ifluidstate = lvt_12_1_.func_204610_c(blockpos2);
                    IModelData modelData = generator.getModelData(blockpos2);
                    for (BlockRenderLayer blockrenderlayer1 : BlockRenderLayer.values()) {
                        ForgeHooksClient.setRenderLayer((BlockRenderLayer)blockrenderlayer1);
                        if (!ifluidstate.func_206888_e() && ifluidstate.canRenderInLayer(blockrenderlayer1)) {
                            int j = blockrenderlayer1.ordinal();
                            BufferBuilder bufferbuilder = generator.func_178545_d().func_179039_a(j);
                            if (!compiledchunk.func_178492_d(blockrenderlayer1)) {
                                compiledchunk.func_178493_c(blockrenderlayer1);
                                this.func_178573_a(bufferbuilder, blockpos);
                            }
                            int n = j;
                            aboolean[n] = aboolean[n] | blockrendererdispatcher.func_215331_a(blockpos2, (IEnviromentBlockReader)lvt_12_1_, bufferbuilder, ifluidstate);
                        }
                        if (blockstate.func_185901_i() == BlockRenderType.INVISIBLE || !blockstate.canRenderInLayer(blockrenderlayer1)) continue;
                        int k = blockrenderlayer1.ordinal();
                        BufferBuilder bufferbuilder1 = generator.func_178545_d().func_179039_a(k);
                        if (!compiledchunk.func_178492_d(blockrenderlayer1)) {
                            compiledchunk.func_178493_c(blockrenderlayer1);
                            this.func_178573_a(bufferbuilder1, blockpos);
                        }
                        int n = k;
                        aboolean[n] = aboolean[n] | blockrendererdispatcher.renderBlock(blockstate, blockpos2, (IEnviromentBlockReader)lvt_12_1_, bufferbuilder1, random, modelData);
                    }
                    ForgeHooksClient.setRenderLayer(null);
                }
                for (BlockRenderLayer blockrenderlayer : BlockRenderLayer.values()) {
                    if (aboolean[blockrenderlayer.ordinal()]) {
                        compiledchunk.func_178486_a(blockrenderlayer);
                    }
                    if (!compiledchunk.func_178492_d(blockrenderlayer)) continue;
                    this.func_178584_a(blockrenderlayer, x, y, z, generator.func_178545_d().func_179038_a(blockrenderlayer), compiledchunk);
                }
                BlockModelRenderer.func_210266_a();
            }
            compiledchunk.func_178488_a(lvt_10_1_.func_178607_a());
            this.field_178587_g.lock();
            try {
                HashSet set = Sets.newHashSet((Iterable)lvt_11_1_);
                HashSet set1 = Sets.newHashSet(this.field_181056_j);
                set.removeAll(this.field_181056_j);
                set1.removeAll(lvt_11_1_);
                this.field_181056_j.clear();
                this.field_181056_j.addAll(lvt_11_1_);
                this.field_178589_e.func_181023_a(set1, set);
            }
            finally {
                this.field_178587_g.unlock();
            }
        }
    }

    protected void func_178578_b() {
        this.field_178587_g.lock();
        try {
            if (this.field_178599_i != null && this.field_178599_i.func_178546_a() != ChunkRenderTask.Status.DONE) {
                this.field_178599_i.func_178542_e();
                this.field_178599_i = null;
            }
        }
        finally {
            this.field_178587_g.unlock();
        }
    }

    public ReentrantLock func_178579_c() {
        return this.field_178587_g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkRenderTask func_178574_d() {
        ChunkRenderTask chunkrendertask;
        this.field_178587_g.lock();
        try {
            this.func_178578_b();
            BlockPos blockpos = this.field_178586_f.func_185334_h();
            boolean i = true;
            ChunkRenderCache chunkrendercache = this.createRegionRenderCache(this.field_178588_d, blockpos.func_177982_a(-1, -1, -1), blockpos.func_177982_a(16, 16, 16), 1);
            chunkrendertask = this.field_178599_i = new ChunkRenderTask(this, ChunkRenderTask.Type.REBUILD_CHUNK, this.func_188280_f(), chunkrendercache);
        }
        finally {
            this.field_178587_g.unlock();
        }
        return chunkrendertask;
    }

    @Nullable
    public ChunkRenderTask func_178582_e() {
        ChunkRenderTask chunkrendertask;
        this.field_178587_g.lock();
        try {
            if (this.field_178599_i == null || this.field_178599_i.func_178546_a() != ChunkRenderTask.Status.PENDING) {
                ChunkRenderTask chunkrendertask2;
                if (this.field_178599_i != null && this.field_178599_i.func_178546_a() != ChunkRenderTask.Status.DONE) {
                    this.field_178599_i.func_178542_e();
                    this.field_178599_i = null;
                }
                this.field_178599_i = new ChunkRenderTask(this, ChunkRenderTask.Type.RESORT_TRANSPARENCY, this.func_188280_f(), null);
                this.field_178599_i.func_178543_a(this.field_178590_b);
                ChunkRenderTask chunkRenderTask = chunkrendertask2 = this.field_178599_i;
                return chunkRenderTask;
            }
            chunkrendertask = null;
        }
        finally {
            this.field_178587_g.unlock();
        }
        return chunkrendertask;
    }

    protected double func_188280_f() {
        ActiveRenderInfo activerenderinfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        double d0 = this.field_178591_c.field_72340_a + 8.0 - activerenderinfo.func_216785_c().field_72450_a;
        double d1 = this.field_178591_c.field_72338_b + 8.0 - activerenderinfo.func_216785_c().field_72448_b;
        double d2 = this.field_178591_c.field_72339_c + 8.0 - activerenderinfo.func_216785_c().field_72449_c;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    private void func_178573_a(BufferBuilder bufferBuilderIn, BlockPos pos) {
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        bufferBuilderIn.func_178969_c(-pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p());
    }

    private void func_178584_a(BlockRenderLayer layer, float x, float y, float z, BufferBuilder bufferBuilderIn, CompiledChunk compiledChunkIn) {
        if (layer == BlockRenderLayer.TRANSLUCENT && !compiledChunkIn.func_178491_b(layer)) {
            bufferBuilderIn.func_181674_a(x, y, z);
            compiledChunkIn.func_178494_a(bufferBuilderIn.func_181672_a());
        }
        bufferBuilderIn.func_178977_d();
    }

    public CompiledChunk func_178571_g() {
        return this.field_178590_b;
    }

    public void func_178580_a(CompiledChunk compiledChunkIn) {
        this.field_178598_h.lock();
        try {
            this.field_178590_b = compiledChunkIn;
        }
        finally {
            this.field_178598_h.unlock();
        }
    }

    public void func_178585_h() {
        this.func_178578_b();
        this.field_178590_b = CompiledChunk.field_178502_a;
        this.field_178593_n = true;
    }

    public void func_178566_a() {
        this.func_178585_h();
        this.field_178588_d = null;
        for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
            if (this.field_178594_l[i] == null) continue;
            this.field_178594_l[i].func_177362_c();
        }
    }

    public BlockPos func_178568_j() {
        return this.field_178586_f;
    }

    public void func_178575_a(boolean immediate) {
        if (this.field_178593_n) {
            immediate |= this.field_188284_q;
        }
        this.field_178593_n = true;
        this.field_188284_q = immediate;
    }

    public void func_188282_m() {
        this.field_178593_n = false;
        this.field_188284_q = false;
    }

    public boolean func_178569_m() {
        return this.field_178593_n;
    }

    public boolean func_188281_o() {
        return this.field_178593_n && this.field_188284_q;
    }

    public BlockPos func_181701_a(Direction facing) {
        return this.field_181702_p[facing.ordinal()];
    }

    public World func_188283_p() {
        return this.field_178588_d;
    }
}

