/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.multipart.Multipart;
import net.minecraft.client.renderer.model.multipart.Selector;
import net.minecraft.state.StateContainer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.BlockStateLoader;

@OnlyIn(value=Dist.CLIENT)
public class BlockModelDefinition {
    private final Map<String, VariantList> field_178332_b = Maps.newLinkedHashMap();
    private Multipart field_188005_c;

    @Deprecated
    public static BlockModelDefinition func_209577_a(ContainerHolder containerHolderIn, Reader readerIn) {
        return BlockModelDefinition.fromJson(containerHolderIn, readerIn, null, null, null);
    }

    public static BlockModelDefinition fromJson(ContainerHolder containerHolderIn, Reader readerIn, @Nullable ResourceLocation location, @Nullable ModelBakery bakery, @Nullable BiConsumer<ResourceLocation, IUnbakedModel> modelConsumer) {
        return BlockStateLoader.load((Reader)readerIn, (ResourceLocation)location, (Gson)containerHolderIn.field_209575_a, (ModelBakery)bakery, modelConsumer);
    }

    public BlockModelDefinition(Map<String, VariantList> variants, Multipart multipartIn) {
        this.field_188005_c = multipartIn;
        this.field_178332_b.putAll(variants);
    }

    public BlockModelDefinition(List<BlockModelDefinition> definitions) {
        BlockModelDefinition blockmodeldefinition = null;
        for (BlockModelDefinition blockmodeldefinition1 : definitions) {
            if (blockmodeldefinition1.func_188002_b()) {
                this.field_178332_b.clear();
                blockmodeldefinition = blockmodeldefinition1;
            }
            this.field_178332_b.putAll(blockmodeldefinition1.field_178332_b);
        }
        if (blockmodeldefinition != null) {
            this.field_188005_c = blockmodeldefinition.field_188005_c;
        }
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof BlockModelDefinition) {
            BlockModelDefinition blockmodeldefinition = (BlockModelDefinition)p_equals_1_;
            if (this.field_178332_b.equals(blockmodeldefinition.field_178332_b)) {
                return this.func_188002_b() ? this.field_188005_c.equals(blockmodeldefinition.field_188005_c) : !blockmodeldefinition.func_188002_b();
            }
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.field_178332_b.hashCode() + (this.func_188002_b() ? this.field_188005_c.hashCode() : 0);
    }

    public Map<String, VariantList> func_209578_a() {
        return this.field_178332_b;
    }

    public boolean func_188002_b() {
        return this.field_188005_c != null;
    }

    public Multipart func_188001_c() {
        return this.field_188005_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<BlockModelDefinition> {
        public BlockModelDefinition deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            Map<String, VariantList> map = this.func_187999_a(p_deserialize_3_, jsonobject);
            Multipart multipart = this.func_187998_b(p_deserialize_3_, jsonobject);
            if (!map.isEmpty() || multipart != null && !multipart.func_188137_b().isEmpty()) {
                return new BlockModelDefinition(map, multipart);
            }
            throw new JsonParseException("Neither 'variants' nor 'multipart' found");
        }

        protected Map<String, VariantList> func_187999_a(JsonDeserializationContext deserializationContext, JsonObject object) {
            HashMap map = Maps.newHashMap();
            if (object.has("variants")) {
                JsonObject jsonobject = JSONUtils.func_152754_s((JsonObject)object, (String)"variants");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    map.put(entry.getKey(), deserializationContext.deserialize((JsonElement)entry.getValue(), VariantList.class));
                }
            }
            return map;
        }

        @Nullable
        protected Multipart func_187998_b(JsonDeserializationContext deserializationContext, JsonObject object) {
            if (!object.has("multipart")) {
                return null;
            }
            JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)object, (String)"multipart");
            return (Multipart)deserializationContext.deserialize((JsonElement)jsonarray, Multipart.class);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class ContainerHolder {
        protected final Gson field_209575_a = new GsonBuilder().registerTypeAdapter(BlockModelDefinition.class, (Object)new Deserializer()).registerTypeAdapter(Variant.class, (Object)new Variant.Deserializer()).registerTypeAdapter(VariantList.class, (Object)new VariantList.Deserializer()).registerTypeAdapter(Multipart.class, (Object)new Multipart.Deserializer(this)).registerTypeAdapter(Selector.class, (Object)new Selector.Deserializer()).create();
        private StateContainer<Block, BlockState> field_209576_b;

        public StateContainer<Block, BlockState> func_209574_a() {
            return this.field_209576_b;
        }

        public void func_209573_a(StateContainer<Block, BlockState> stateContainerIn) {
            this.field_209576_b = stateContainerIn;
        }
    }
}

