/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model.multipart;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BlockModelDefinition;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.multipart.Selector;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Multipart
implements IUnbakedModel {
    private final StateContainer<Block, BlockState> field_188140_b;
    private final List<Selector> field_188139_a;

    public Multipart(StateContainer<Block, BlockState> stateContainerIn, List<Selector> selectorsIn) {
        this.field_188140_b = stateContainerIn;
        this.field_188139_a = selectorsIn;
    }

    public List<Selector> func_188136_a() {
        return this.field_188139_a;
    }

    public Set<VariantList> func_188137_b() {
        HashSet set = Sets.newHashSet();
        for (Selector selector : this.field_188139_a) {
            set.add(selector.func_188165_a());
        }
        return set;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Multipart)) {
            return false;
        }
        Multipart multipart = (Multipart)p_equals_1_;
        return Objects.equals(this.field_188140_b, multipart.field_188140_b) && Objects.equals(this.field_188139_a, multipart.field_188139_a);
    }

    public int hashCode() {
        return Objects.hash(this.field_188140_b, this.field_188139_a);
    }

    @Override
    public Collection<ResourceLocation> func_187965_e() {
        return this.func_188136_a().stream().flatMap(p_209563_0_ -> p_209563_0_.func_188165_a().func_187965_e().stream()).collect(Collectors.toSet());
    }

    @Override
    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        return this.func_188136_a().stream().flatMap(p_209562_2_ -> p_209562_2_.func_188165_a().func_209559_a(modelGetter, missingTextureErrors).stream()).collect(Collectors.toSet());
    }

    @Nullable
    public IBakedModel bake(ModelBakery p_217641_1_, Function<ResourceLocation, TextureAtlasSprite> p_217641_2_, ISprite p_217641_3_, VertexFormat format) {
        MultipartBakedModel.Builder multipartbakedmodel$builder = new MultipartBakedModel.Builder();
        for (Selector selector : this.func_188136_a()) {
            IBakedModel ibakedmodel = selector.func_188165_a().bake(p_217641_1_, p_217641_2_, p_217641_3_, format);
            if (ibakedmodel == null) continue;
            multipartbakedmodel$builder.func_188648_a(selector.func_188166_a(this.field_188140_b), ibakedmodel);
        }
        return multipartbakedmodel$builder.func_188647_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<Multipart> {
        private final BlockModelDefinition.ContainerHolder field_209584_a;

        public Deserializer(BlockModelDefinition.ContainerHolder containerHolderIn) {
            this.field_209584_a = containerHolderIn;
        }

        public Multipart deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return new Multipart(this.field_209584_a.func_209574_a(), this.func_188133_a(p_deserialize_3_, p_deserialize_1_.getAsJsonArray()));
        }

        private List<Selector> func_188133_a(JsonDeserializationContext context, JsonArray elements) {
            ArrayList list = Lists.newArrayList();
            for (JsonElement jsonelement : elements) {
                list.add(context.deserialize(jsonelement, Selector.class));
            }
            return list;
        }
    }
}

