/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Framebuffer {
    public int field_147622_a;
    public int field_147620_b;
    public int field_147621_c;
    public int field_147618_d;
    public final boolean field_147619_e;
    public int field_147616_f;
    public int field_147617_g;
    public int field_147624_h;
    public final float[] field_147625_i;
    public int field_147623_j;
    private boolean stencilEnabled = false;

    public Framebuffer(int p_i51175_1_, int p_i51175_2_, boolean p_i51175_3_, boolean p_i51175_4_) {
        this.field_147619_e = p_i51175_3_;
        this.field_147616_f = -1;
        this.field_147617_g = -1;
        this.field_147624_h = -1;
        this.field_147625_i = new float[4];
        this.field_147625_i[0] = 1.0f;
        this.field_147625_i[1] = 1.0f;
        this.field_147625_i[2] = 1.0f;
        this.field_147625_i[3] = 0.0f;
        this.func_216491_a(p_i51175_1_, p_i51175_2_, p_i51175_4_);
    }

    public void func_216491_a(int p_216491_1_, int p_216491_2_, boolean p_216491_3_) {
        if (!GLX.isUsingFBOs()) {
            this.field_147621_c = p_216491_1_;
            this.field_147618_d = p_216491_2_;
        } else {
            GlStateManager.enableDepthTest();
            if (this.field_147616_f >= 0) {
                this.func_147608_a();
            }
            this.func_216492_b(p_216491_1_, p_216491_2_, p_216491_3_);
            GLX.glBindFramebuffer(GLX.GL_FRAMEBUFFER, 0);
        }
    }

    public void func_147608_a() {
        if (GLX.isUsingFBOs()) {
            this.func_147606_d();
            this.func_147609_e();
            if (this.field_147624_h > -1) {
                GLX.glDeleteRenderbuffers(this.field_147624_h);
                this.field_147624_h = -1;
            }
            if (this.field_147617_g > -1) {
                TextureUtil.releaseTextureId((int)this.field_147617_g);
                this.field_147617_g = -1;
            }
            if (this.field_147616_f > -1) {
                GLX.glBindFramebuffer(GLX.GL_FRAMEBUFFER, 0);
                GLX.glDeleteFramebuffers(this.field_147616_f);
                this.field_147616_f = -1;
            }
        }
    }

    public void func_216492_b(int p_216492_1_, int p_216492_2_, boolean p_216492_3_) {
        this.field_147621_c = p_216492_1_;
        this.field_147618_d = p_216492_2_;
        this.field_147622_a = p_216492_1_;
        this.field_147620_b = p_216492_2_;
        if (!GLX.isUsingFBOs()) {
            this.func_216493_b(p_216492_3_);
        } else {
            this.field_147616_f = GLX.glGenFramebuffers();
            this.field_147617_g = TextureUtil.generateTextureId();
            if (this.field_147619_e) {
                this.field_147624_h = GLX.glGenRenderbuffers();
            }
            this.func_147607_a(9728);
            GlStateManager.bindTexture((int)this.field_147617_g);
            GlStateManager.texImage2D((int)3553, (int)0, (int)32856, (int)this.field_147622_a, (int)this.field_147620_b, (int)0, (int)6408, (int)5121, (IntBuffer)null);
            GLX.glBindFramebuffer(GLX.GL_FRAMEBUFFER, this.field_147616_f);
            GLX.glFramebufferTexture2D(GLX.GL_FRAMEBUFFER, GLX.GL_COLOR_ATTACHMENT0, 3553, this.field_147617_g, 0);
            if (this.field_147619_e) {
                GLX.glBindRenderbuffer(GLX.GL_RENDERBUFFER, this.field_147624_h);
                if (!this.stencilEnabled) {
                    GLX.glRenderbufferStorage(GLX.GL_RENDERBUFFER, 33190, this.field_147622_a, this.field_147620_b);
                    GLX.glFramebufferRenderbuffer(GLX.GL_FRAMEBUFFER, GLX.GL_DEPTH_ATTACHMENT, GLX.GL_RENDERBUFFER, this.field_147624_h);
                } else {
                    GLX.glRenderbufferStorage(GLX.GL_RENDERBUFFER, 35056, this.field_147622_a, this.field_147620_b);
                    GLX.glFramebufferRenderbuffer(GLX.GL_FRAMEBUFFER, GLX.GL_DEPTH_ATTACHMENT, GLX.GL_RENDERBUFFER, this.field_147624_h);
                    GLX.glFramebufferRenderbuffer(GLX.GL_FRAMEBUFFER, 36128, GLX.GL_RENDERBUFFER, this.field_147624_h);
                }
            }
            this.func_147611_b();
            this.func_216493_b(p_216492_3_);
            this.func_147606_d();
        }
    }

    public void func_147607_a(int framebufferFilterIn) {
        if (GLX.isUsingFBOs()) {
            this.field_147623_j = framebufferFilterIn;
            GlStateManager.bindTexture((int)this.field_147617_g);
            GlStateManager.texParameter((int)3553, (int)10241, (int)framebufferFilterIn);
            GlStateManager.texParameter((int)3553, (int)10240, (int)framebufferFilterIn);
            GlStateManager.texParameter((int)3553, (int)10242, (int)10496);
            GlStateManager.texParameter((int)3553, (int)10243, (int)10496);
            GlStateManager.bindTexture((int)0);
        }
    }

    public void func_147611_b() {
        int i = GLX.glCheckFramebufferStatus(GLX.GL_FRAMEBUFFER);
        if (i != GLX.GL_FRAMEBUFFER_COMPLETE) {
            if (i == GLX.GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == GLX.GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == GLX.GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == GLX.GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    public void func_147612_c() {
        if (GLX.isUsingFBOs()) {
            GlStateManager.bindTexture((int)this.field_147617_g);
        }
    }

    public void func_147606_d() {
        if (GLX.isUsingFBOs()) {
            GlStateManager.bindTexture((int)0);
        }
    }

    public void func_147610_a(boolean p_147610_1_) {
        if (GLX.isUsingFBOs()) {
            GLX.glBindFramebuffer(GLX.GL_FRAMEBUFFER, this.field_147616_f);
            if (p_147610_1_) {
                GlStateManager.viewport((int)0, (int)0, (int)this.field_147621_c, (int)this.field_147618_d);
            }
        }
    }

    public void func_147609_e() {
        if (GLX.isUsingFBOs()) {
            GLX.glBindFramebuffer(GLX.GL_FRAMEBUFFER, 0);
        }
    }

    public void func_147604_a(float red, float green, float blue, float alpha) {
        this.field_147625_i[0] = red;
        this.field_147625_i[1] = green;
        this.field_147625_i[2] = blue;
        this.field_147625_i[3] = alpha;
    }

    public void func_147615_c(int width, int height) {
        this.func_178038_a(width, height, true);
    }

    public void func_178038_a(int width, int height, boolean p_178038_3_) {
        if (GLX.isUsingFBOs()) {
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GlStateManager.disableDepthTest();
            GlStateManager.depthMask((boolean)false);
            GlStateManager.matrixMode((int)5889);
            GlStateManager.loadIdentity();
            GlStateManager.ortho((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.matrixMode((int)5888);
            GlStateManager.loadIdentity();
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            GlStateManager.viewport((int)0, (int)0, (int)width, (int)height);
            GlStateManager.enableTexture();
            GlStateManager.disableLighting();
            GlStateManager.disableAlphaTest();
            if (p_178038_3_) {
                GlStateManager.disableBlend();
                GlStateManager.enableColorMaterial();
            }
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_147612_c();
            float f = width;
            float f1 = height;
            float f2 = (float)this.field_147621_c / (float)this.field_147622_a;
            float f3 = (float)this.field_147618_d / (float)this.field_147620_b;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b(0.0, f1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(f, f1, 0.0).func_187315_a(f2, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(f, 0.0, 0.0).func_187315_a(f2, f3).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, f3).func_181669_b(255, 255, 255, 255).func_181675_d();
            tessellator.func_78381_a();
            this.func_147606_d();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    public void func_216493_b(boolean onMac) {
        this.func_147610_a(true);
        GlStateManager.clearColor((float)this.field_147625_i[0], (float)this.field_147625_i[1], (float)this.field_147625_i[2], (float)this.field_147625_i[3]);
        int i = 16384;
        if (this.field_147619_e) {
            GlStateManager.clearDepth((double)1.0);
            i |= 0x100;
        }
        GlStateManager.clear((int)i, (boolean)onMac);
        this.func_147609_e();
    }

    public void enableStencil() {
        if (this.stencilEnabled) {
            return;
        }
        this.stencilEnabled = true;
        this.func_216491_a(this.field_147621_c, this.field_147618_d, Minecraft.field_142025_a);
    }

    public boolean isStencilEnabled() {
        return this.stencilEnabled;
    }
}

