/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.client.util.JSONException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;

@OnlyIn(value=Dist.CLIENT)
public class ShaderGroup
implements AutoCloseable {
    private final Framebuffer field_148035_a;
    private final IResourceManager field_148033_b;
    private final String field_148034_c;
    private final List<Shader> field_148031_d = Lists.newArrayList();
    private final Map<String, Framebuffer> field_148032_e = Maps.newHashMap();
    private final List<Framebuffer> field_148029_f = Lists.newArrayList();
    private Matrix4f field_148030_g;
    private int field_148038_h;
    private int field_148039_i;
    private float field_148036_j;
    private float field_148037_k;

    public ShaderGroup(TextureManager p_i1050_1_, IResourceManager resourceManagerIn, Framebuffer mainFramebufferIn, ResourceLocation p_i1050_4_) throws IOException, JsonSyntaxException {
        this.field_148033_b = resourceManagerIn;
        this.field_148035_a = mainFramebufferIn;
        this.field_148036_j = 0.0f;
        this.field_148037_k = 0.0f;
        this.field_148038_h = mainFramebufferIn.field_147621_c;
        this.field_148039_i = mainFramebufferIn.field_147618_d;
        this.field_148034_c = p_i1050_4_.toString();
        this.func_148024_c();
        this.func_152765_a(p_i1050_1_, p_i1050_4_);
    }

    private void func_152765_a(TextureManager p_152765_1_, ResourceLocation p_152765_2_) throws IOException, JsonSyntaxException {
        IResource iresource;
        block11: {
            iresource = null;
            try {
                iresource = this.field_148033_b.func_199002_a(p_152765_2_);
                JsonObject jsonobject = JSONUtils.func_212743_a((Reader)new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8));
                if (JSONUtils.func_151202_d((JsonObject)jsonobject, (String)"targets")) {
                    JsonArray jsonarray = jsonobject.getAsJsonArray("targets");
                    int i = 0;
                    for (JsonElement jsonelement : jsonarray) {
                        try {
                            this.func_148027_a(jsonelement);
                        }
                        catch (Exception exception1) {
                            JSONException jsonexception1 = JSONException.func_151379_a((Exception)exception1);
                            jsonexception1.func_151380_a("targets[" + i + "]");
                            throw jsonexception1;
                        }
                        ++i;
                    }
                }
                if (!JSONUtils.func_151202_d((JsonObject)jsonobject, (String)"passes")) break block11;
                JsonArray jsonarray1 = jsonobject.getAsJsonArray("passes");
                int j = 0;
                for (JsonElement jsonelement1 : jsonarray1) {
                    try {
                        this.func_152764_a(p_152765_1_, jsonelement1);
                    }
                    catch (Exception exception) {
                        JSONException jsonexception2 = JSONException.func_151379_a((Exception)exception);
                        jsonexception2.func_151380_a("passes[" + j + "]");
                        throw jsonexception2;
                    }
                    ++j;
                }
            }
            catch (Exception exception2) {
                try {
                    JSONException jsonexception = JSONException.func_151379_a((Exception)exception2);
                    jsonexception.func_151381_b(p_152765_2_.func_110623_a());
                    throw jsonexception;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(iresource);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Closeable)iresource);
    }

    private void func_148027_a(JsonElement p_148027_1_) throws JSONException {
        if (JSONUtils.func_151211_a((JsonElement)p_148027_1_)) {
            this.func_148020_a(p_148027_1_.getAsString(), this.field_148038_h, this.field_148039_i);
        } else {
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)p_148027_1_, (String)"target");
            String s = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
            int i = JSONUtils.func_151208_a((JsonObject)jsonobject, (String)"width", (int)this.field_148038_h);
            int j = JSONUtils.func_151208_a((JsonObject)jsonobject, (String)"height", (int)this.field_148039_i);
            if (this.field_148032_e.containsKey(s)) {
                throw new JSONException(s + " is already defined");
            }
            this.func_148020_a(s, i, j);
        }
    }

    private void func_152764_a(TextureManager p_152764_1_, JsonElement json) throws IOException {
        JsonArray jsonarray1;
        JsonObject jsonobject;
        block16: {
            jsonobject = JSONUtils.func_151210_l((JsonElement)json, (String)"pass");
            String s = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
            String s1 = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"intarget");
            String s2 = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"outtarget");
            Framebuffer framebuffer = this.func_148017_a(s1);
            Framebuffer framebuffer1 = this.func_148017_a(s2);
            if (framebuffer == null) {
                throw new JSONException("Input target '" + s1 + "' does not exist");
            }
            if (framebuffer1 == null) {
                throw new JSONException("Output target '" + s2 + "' does not exist");
            }
            Shader shader = this.func_148023_a(s, framebuffer, framebuffer1);
            JsonArray jsonarray = JSONUtils.func_151213_a((JsonObject)jsonobject, (String)"auxtargets", (JsonArray)null);
            if (jsonarray == null) break block16;
            int i = 0;
            for (JsonElement jsonelement : jsonarray) {
                block15: {
                    try {
                        Framebuffer framebuffer2;
                        String s4;
                        block17: {
                            JsonObject jsonobject1 = JSONUtils.func_151210_l((JsonElement)jsonelement, (String)"auxtarget");
                            s4 = JSONUtils.func_151200_h((JsonObject)jsonobject1, (String)"name");
                            String s3 = JSONUtils.func_151200_h((JsonObject)jsonobject1, (String)"id");
                            framebuffer2 = this.func_148017_a(s3);
                            if (framebuffer2 != null) break block17;
                            ResourceLocation rl = ResourceLocation.func_208304_a((String)s3);
                            ResourceLocation resourcelocation = new ResourceLocation(rl.func_110624_b(), "textures/effect/" + rl.func_110623_a() + ".png");
                            IResource iresource = null;
                            try {
                                iresource = this.field_148033_b.func_199002_a(resourcelocation);
                            }
                            catch (FileNotFoundException var29) {
                                try {
                                    throw new JSONException("Render target or texture '" + s3 + "' does not exist");
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(iresource);
                                    throw throwable;
                                }
                            }
                            IOUtils.closeQuietly((Closeable)iresource);
                            p_152764_1_.func_110577_a(resourcelocation);
                            ITextureObject lvt_20_2_ = p_152764_1_.func_110581_b(resourcelocation);
                            int lvt_21_1_ = JSONUtils.func_151203_m((JsonObject)jsonobject1, (String)"width");
                            int lvt_22_1_ = JSONUtils.func_151203_m((JsonObject)jsonobject1, (String)"height");
                            boolean lvt_23_1_ = JSONUtils.func_151212_i((JsonObject)jsonobject1, (String)"bilinear");
                            if (lvt_23_1_) {
                                GlStateManager.texParameter((int)3553, (int)10241, (int)9729);
                                GlStateManager.texParameter((int)3553, (int)10240, (int)9729);
                            } else {
                                GlStateManager.texParameter((int)3553, (int)10241, (int)9728);
                                GlStateManager.texParameter((int)3553, (int)10240, (int)9728);
                            }
                            shader.func_148041_a(s4, (Object)lvt_20_2_.func_110552_b(), lvt_21_1_, lvt_22_1_);
                            break block15;
                        }
                        shader.func_148041_a(s4, (Object)framebuffer2, framebuffer2.field_147622_a, framebuffer2.field_147620_b);
                    }
                    catch (Exception exception1) {
                        JSONException jsonexception = JSONException.func_151379_a((Exception)exception1);
                        jsonexception.func_151380_a("auxtargets[" + i + "]");
                        throw jsonexception;
                    }
                }
                ++i;
            }
        }
        if ((jsonarray1 = JSONUtils.func_151213_a((JsonObject)jsonobject, (String)"uniforms", (JsonArray)null)) != null) {
            int l = 0;
            for (JsonElement jsonelement1 : jsonarray1) {
                try {
                    this.func_148028_c(jsonelement1);
                }
                catch (Exception exception) {
                    JSONException jsonexception1 = JSONException.func_151379_a((Exception)exception);
                    jsonexception1.func_151380_a("uniforms[" + l + "]");
                    throw jsonexception1;
                }
                ++l;
            }
        }
    }

    private void func_148028_c(JsonElement json) throws JSONException {
        JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)json, (String)"uniform");
        String s = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
        ShaderUniform shaderuniform = this.field_148031_d.get(this.field_148031_d.size() - 1).func_217624_b().func_216539_a(s);
        if (shaderuniform == null) {
            throw new JSONException("Uniform '" + s + "' does not exist");
        }
        float[] afloat = new float[4];
        int i = 0;
        for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)jsonobject, (String)"values")) {
            try {
                afloat[i] = JSONUtils.func_151220_d((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                JSONException jsonexception = JSONException.func_151379_a((Exception)exception);
                jsonexception.func_151380_a("values[" + i + "]");
                throw jsonexception;
            }
            ++i;
        }
        switch (i) {
            default: {
                break;
            }
            case 1: {
                shaderuniform.func_148090_a(afloat[0]);
                break;
            }
            case 2: {
                shaderuniform.func_148087_a(afloat[0], afloat[1]);
                break;
            }
            case 3: {
                shaderuniform.func_148095_a(afloat[0], afloat[1], afloat[2]);
                break;
            }
            case 4: {
                shaderuniform.func_148081_a(afloat[0], afloat[1], afloat[2], afloat[3]);
            }
        }
    }

    public Framebuffer func_177066_a(String attributeName) {
        return this.field_148032_e.get(attributeName);
    }

    public void func_148020_a(String name, int width, int height) {
        Framebuffer framebuffer = new Framebuffer(width, height, true, Minecraft.field_142025_a);
        framebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.field_148032_e.put(name, framebuffer);
        if (width == this.field_148038_h && height == this.field_148039_i) {
            this.field_148029_f.add(framebuffer);
        }
    }

    @Override
    public void close() {
        for (Framebuffer framebuffer : this.field_148032_e.values()) {
            framebuffer.func_147608_a();
        }
        for (Shader shader : this.field_148031_d) {
            shader.close();
        }
        this.field_148031_d.clear();
    }

    public Shader func_148023_a(String programName, Framebuffer framebufferIn, Framebuffer framebufferOut) throws IOException {
        Shader shader = new Shader(this.field_148033_b, programName, framebufferIn, framebufferOut);
        this.field_148031_d.add(this.field_148031_d.size(), shader);
        return shader;
    }

    private void func_148024_c() {
        this.field_148030_g = Matrix4f.func_195877_a(this.field_148035_a.field_147622_a, this.field_148035_a.field_147620_b, 0.1f, 1000.0f);
    }

    public void func_148026_a(int width, int height) {
        this.field_148038_h = this.field_148035_a.field_147622_a;
        this.field_148039_i = this.field_148035_a.field_147620_b;
        this.func_148024_c();
        for (Shader shader : this.field_148031_d) {
            shader.func_195654_a(this.field_148030_g);
        }
        for (Framebuffer framebuffer : this.field_148029_f) {
            framebuffer.func_216491_a(width, height, Minecraft.field_142025_a);
        }
    }

    public void func_148018_a(float partialTicks) {
        if (partialTicks < this.field_148037_k) {
            this.field_148036_j += 1.0f - this.field_148037_k;
            this.field_148036_j += partialTicks;
        } else {
            this.field_148036_j += partialTicks - this.field_148037_k;
        }
        this.field_148037_k = partialTicks;
        while (this.field_148036_j > 20.0f) {
            this.field_148036_j -= 20.0f;
        }
        for (Shader shader : this.field_148031_d) {
            shader.func_148042_a(this.field_148036_j / 20.0f);
        }
    }

    public final String func_148022_b() {
        return this.field_148034_c;
    }

    private Framebuffer func_148017_a(String p_148017_1_) {
        if (p_148017_1_ == null) {
            return null;
        }
        return p_148017_1_.equals("minecraft:main") ? this.field_148035_a : this.field_148032_e.get(p_148017_1_);
    }
}

