/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.IShaderManager;
import net.minecraft.client.shader.ShaderDefault;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.shader.ShaderLoader;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.client.util.JSONBlendingMode;
import net.minecraft.client.util.JSONException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ShaderInstance
implements IShaderManager,
AutoCloseable {
    private static final Logger field_216545_a = LogManager.getLogger();
    private static final ShaderDefault field_216546_b = new ShaderDefault();
    private static ShaderInstance field_216547_c;
    private static int field_216548_d;
    private final Map<String, Object> field_216549_e = Maps.newHashMap();
    private final List<String> field_216550_f = Lists.newArrayList();
    private final List<Integer> field_216551_g = Lists.newArrayList();
    private final List<ShaderUniform> field_216552_h = Lists.newArrayList();
    private final List<Integer> field_216553_i = Lists.newArrayList();
    private final Map<String, ShaderUniform> field_216554_j = Maps.newHashMap();
    private final int field_216555_k;
    private final String field_216556_l;
    private final boolean field_216557_m;
    private boolean field_216558_n;
    private final JSONBlendingMode field_216559_o;
    private final List<Integer> field_216560_p;
    private final List<String> field_216561_q;
    private final ShaderLoader field_216562_r;
    private final ShaderLoader field_216563_s;

    public ShaderInstance(IResourceManager p_i50988_1_, String p_i50988_2_) throws IOException {
        ResourceLocation rl = ResourceLocation.func_208304_a((String)p_i50988_2_);
        ResourceLocation resourcelocation = new ResourceLocation(rl.func_110624_b(), "shaders/program/" + rl.func_110623_a() + ".json");
        this.field_216556_l = p_i50988_2_;
        IResource iresource = null;
        try {
            JsonArray jsonarray2;
            JsonArray jsonarray1;
            iresource = p_i50988_1_.func_199002_a(resourcelocation);
            JsonObject jsonobject = JSONUtils.func_212743_a((Reader)new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8));
            String s = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"vertex");
            String s1 = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"fragment");
            JsonArray jsonarray = JSONUtils.func_151213_a((JsonObject)jsonobject, (String)"samplers", (JsonArray)null);
            if (jsonarray != null) {
                int i = 0;
                for (Object jsonelement : jsonarray) {
                    try {
                        this.func_216541_a((JsonElement)jsonelement);
                    }
                    catch (Exception exception2) {
                        JSONException jsonexception1 = JSONException.func_151379_a((Exception)exception2);
                        jsonexception1.func_151380_a("samplers[" + i + "]");
                        throw jsonexception1;
                    }
                    ++i;
                }
            }
            if ((jsonarray1 = JSONUtils.func_151213_a((JsonObject)jsonobject, (String)"attributes", (JsonArray)null)) != null) {
                int j = 0;
                this.field_216560_p = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                this.field_216561_q = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                for (Iterator jsonelement1 : jsonarray1) {
                    try {
                        this.field_216561_q.add(JSONUtils.func_151206_a((JsonElement)jsonelement1, (String)"attribute"));
                    }
                    catch (Exception exception1) {
                        JSONException jsonexception2 = JSONException.func_151379_a((Exception)exception1);
                        jsonexception2.func_151380_a("attributes[" + j + "]");
                        throw jsonexception2;
                    }
                    ++j;
                }
            } else {
                this.field_216560_p = null;
                this.field_216561_q = null;
            }
            if ((jsonarray2 = JSONUtils.func_151213_a((JsonObject)jsonobject, (String)"uniforms", (JsonArray)null)) != null) {
                int k = 0;
                for (JsonElement jsonelement2 : jsonarray2) {
                    try {
                        this.func_216540_b(jsonelement2);
                    }
                    catch (Exception exception) {
                        JSONException jsonexception3 = JSONException.func_151379_a((Exception)exception);
                        jsonexception3.func_151380_a("uniforms[" + k + "]");
                        throw jsonexception3;
                    }
                    ++k;
                }
            }
            this.field_216559_o = ShaderInstance.func_216543_a(JSONUtils.func_151218_a((JsonObject)jsonobject, (String)"blend", (JsonObject)null));
            this.field_216557_m = JSONUtils.func_151209_a((JsonObject)jsonobject, (String)"cull", (boolean)true);
            this.field_216562_r = ShaderInstance.func_216542_a(p_i50988_1_, ShaderLoader.ShaderType.VERTEX, s);
            this.field_216563_s = ShaderInstance.func_216542_a(p_i50988_1_, ShaderLoader.ShaderType.FRAGMENT, s1);
            this.field_216555_k = ShaderLinkHelper.func_148074_b().func_148078_c();
            ShaderLinkHelper.func_148074_b().func_148075_b((IShaderManager)this);
            this.func_216536_h();
            if (this.field_216561_q != null) {
                for (String s2 : this.field_216561_q) {
                    int l = GLX.glGetAttribLocation(this.field_216555_k, s2);
                    this.field_216560_p.add(l);
                }
            }
        }
        catch (Exception exception3) {
            JSONException jsonexception = JSONException.func_151379_a((Exception)exception3);
            jsonexception.func_151381_b(resourcelocation.func_110623_a());
            throw jsonexception;
        }
        finally {
            IOUtils.closeQuietly((Closeable)iresource);
        }
        this.func_147985_d();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShaderLoader func_216542_a(IResourceManager p_216542_0_, ShaderLoader.ShaderType p_216542_1_, String p_216542_2_) throws IOException {
        ShaderLoader shaderloader = (ShaderLoader)p_216542_1_.func_148064_d().get(p_216542_2_);
        if (shaderloader == null) {
            ResourceLocation rl = ResourceLocation.func_208304_a((String)p_216542_2_);
            ResourceLocation resourcelocation = new ResourceLocation(rl.func_110624_b(), "shaders/program/" + rl.func_110623_a() + p_216542_1_.func_148063_b());
            IResource iresource = p_216542_0_.func_199002_a(resourcelocation);
            try {
                shaderloader = ShaderLoader.func_216534_a((ShaderLoader.ShaderType)p_216542_1_, (String)p_216542_2_, (InputStream)iresource.func_199027_b());
            }
            finally {
                IOUtils.closeQuietly((Closeable)iresource);
            }
        }
        return shaderloader;
    }

    public static JSONBlendingMode func_216543_a(JsonObject p_216543_0_) {
        if (p_216543_0_ == null) {
            return new JSONBlendingMode();
        }
        int i = 32774;
        int j = 1;
        int k = 0;
        int l = 1;
        int i1 = 0;
        boolean flag = true;
        boolean flag1 = false;
        if (JSONUtils.func_151205_a((JsonObject)p_216543_0_, (String)"func") && (i = JSONBlendingMode.func_148108_a((String)p_216543_0_.get("func").getAsString())) != 32774) {
            flag = false;
        }
        if (JSONUtils.func_151205_a((JsonObject)p_216543_0_, (String)"srcrgb") && (j = JSONBlendingMode.func_148107_b((String)p_216543_0_.get("srcrgb").getAsString())) != 1) {
            flag = false;
        }
        if (JSONUtils.func_151205_a((JsonObject)p_216543_0_, (String)"dstrgb") && (k = JSONBlendingMode.func_148107_b((String)p_216543_0_.get("dstrgb").getAsString())) != 0) {
            flag = false;
        }
        if (JSONUtils.func_151205_a((JsonObject)p_216543_0_, (String)"srcalpha")) {
            l = JSONBlendingMode.func_148107_b((String)p_216543_0_.get("srcalpha").getAsString());
            if (l != 1) {
                flag = false;
            }
            flag1 = true;
        }
        if (JSONUtils.func_151205_a((JsonObject)p_216543_0_, (String)"dstalpha")) {
            i1 = JSONBlendingMode.func_148107_b((String)p_216543_0_.get("dstalpha").getAsString());
            if (i1 != 0) {
                flag = false;
            }
            flag1 = true;
        }
        if (flag) {
            return new JSONBlendingMode();
        }
        return flag1 ? new JSONBlendingMode(j, k, l, i1, i) : new JSONBlendingMode(j, k, i);
    }

    @Override
    public void close() {
        for (ShaderUniform shaderuniform : this.field_216552_h) {
            shaderuniform.close();
        }
        ShaderLinkHelper.func_148074_b().func_148077_a((IShaderManager)this);
    }

    public void func_216544_e() {
        GLX.glUseProgram(0);
        field_216548_d = -1;
        field_216547_c = null;
        for (int i = 0; i < this.field_216551_g.size(); ++i) {
            if (this.field_216549_e.get(this.field_216550_f.get(i)) == null) continue;
            GlStateManager.activeTexture((int)(GLX.GL_TEXTURE0 + i));
            GlStateManager.bindTexture((int)0);
        }
    }

    public void func_216535_f() {
        this.field_216558_n = false;
        field_216547_c = this;
        this.field_216559_o.func_148109_a();
        if (this.field_216555_k != field_216548_d) {
            GLX.glUseProgram(this.field_216555_k);
            field_216548_d = this.field_216555_k;
        }
        if (this.field_216557_m) {
            GlStateManager.enableCull();
        } else {
            GlStateManager.disableCull();
        }
        for (int i = 0; i < this.field_216551_g.size(); ++i) {
            if (this.field_216549_e.get(this.field_216550_f.get(i)) == null) continue;
            GlStateManager.activeTexture((int)(GLX.GL_TEXTURE0 + i));
            GlStateManager.enableTexture();
            Object object = this.field_216549_e.get(this.field_216550_f.get(i));
            int j = -1;
            if (object instanceof Framebuffer) {
                j = ((Framebuffer)object).field_147617_g;
            } else if (object instanceof ITextureObject) {
                j = ((ITextureObject)object).func_110552_b();
            } else if (object instanceof Integer) {
                j = (Integer)object;
            }
            if (j == -1) continue;
            GlStateManager.bindTexture((int)j);
            GLX.glUniform1i(GLX.glGetUniformLocation(this.field_216555_k, this.field_216550_f.get(i)), i);
        }
        for (ShaderUniform shaderuniform : this.field_216552_h) {
            shaderuniform.func_148093_b();
        }
    }

    public void func_147985_d() {
        this.field_216558_n = true;
    }

    @Nullable
    public ShaderUniform func_216539_a(String p_216539_1_) {
        return this.field_216554_j.get(p_216539_1_);
    }

    public ShaderDefault func_216538_b(String p_216538_1_) {
        ShaderUniform shaderuniform = this.func_216539_a(p_216538_1_);
        return shaderuniform == null ? field_216546_b : shaderuniform;
    }

    private void func_216536_h() {
        int i = 0;
        int j = 0;
        while (i < this.field_216550_f.size()) {
            String s = this.field_216550_f.get(i);
            int k = GLX.glGetUniformLocation(this.field_216555_k, s);
            if (k == -1) {
                field_216545_a.warn("Shader {}could not find sampler named {} in the specified shader program.", (Object)this.field_216556_l, (Object)s);
                this.field_216549_e.remove(s);
                this.field_216550_f.remove(j);
                --j;
            } else {
                this.field_216551_g.add(k);
            }
            ++i;
            ++j;
        }
        for (ShaderUniform shaderuniform : this.field_216552_h) {
            String s1 = shaderuniform.func_148086_a();
            int l = GLX.glGetUniformLocation(this.field_216555_k, s1);
            if (l == -1) {
                field_216545_a.warn("Could not find uniform named {} in the specified shader program.", (Object)s1);
                continue;
            }
            this.field_216553_i.add(l);
            shaderuniform.func_148084_b(l);
            this.field_216554_j.put(s1, shaderuniform);
        }
    }

    private void func_216541_a(JsonElement p_216541_1_) {
        JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)p_216541_1_, (String)"sampler");
        String s = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
        if (!JSONUtils.func_151205_a((JsonObject)jsonobject, (String)"file")) {
            this.field_216549_e.put(s, null);
            this.field_216550_f.add(s);
        } else {
            this.field_216550_f.add(s);
        }
    }

    public void func_216537_a(String p_216537_1_, Object p_216537_2_) {
        if (this.field_216549_e.containsKey(p_216537_1_)) {
            this.field_216549_e.remove(p_216537_1_);
        }
        this.field_216549_e.put(p_216537_1_, p_216537_2_);
        this.func_147985_d();
    }

    private void func_216540_b(JsonElement p_216540_1_) throws JSONException {
        JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)p_216540_1_, (String)"uniform");
        String s = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
        int i = ShaderUniform.func_148085_a((String)JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"type"));
        int j = JSONUtils.func_151203_m((JsonObject)jsonobject, (String)"count");
        float[] afloat = new float[Math.max(j, 16)];
        JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)jsonobject, (String)"values");
        if (jsonarray.size() != j && jsonarray.size() > 1) {
            throw new JSONException("Invalid amount of values specified (expected " + j + ", found " + jsonarray.size() + ")");
        }
        int k = 0;
        for (JsonElement jsonelement : jsonarray) {
            try {
                afloat[k] = JSONUtils.func_151220_d((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                JSONException jsonexception = JSONException.func_151379_a((Exception)exception);
                jsonexception.func_151380_a("values[" + k + "]");
                throw jsonexception;
            }
            ++k;
        }
        if (j > 1 && jsonarray.size() == 1) {
            while (k < j) {
                afloat[k] = afloat[0];
                ++k;
            }
        }
        int l = j > 1 && j <= 4 && i < 8 ? j - 1 : 0;
        ShaderUniform shaderuniform = new ShaderUniform(s, i + l, j, (IShaderManager)this);
        if (i <= 3) {
            shaderuniform.func_148083_a((int)afloat[0], (int)afloat[1], (int)afloat[2], (int)afloat[3]);
        } else if (i <= 7) {
            shaderuniform.func_148092_b(afloat[0], afloat[1], afloat[2], afloat[3]);
        } else {
            shaderuniform.func_148097_a(afloat);
        }
        this.field_216552_h.add(shaderuniform);
    }

    public ShaderLoader func_147989_e() {
        return this.field_216562_r;
    }

    public ShaderLoader func_147994_f() {
        return this.field_216563_s;
    }

    public int func_147986_h() {
        return this.field_216555_k;
    }

    static {
        field_216548_d = -1;
    }
}

