/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.effect;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnGlobalEntityPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class LightningBoltEntity
extends Entity {
    private int field_70262_b;
    public long field_70264_a;
    private int field_70263_c;
    private final boolean field_184529_d;
    @Nullable
    private ServerPlayerEntity field_204810_e;

    public LightningBoltEntity(World worldIn, double x, double y, double z, boolean effectOnlyIn) {
        super(EntityType.field_200728_aG, worldIn);
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.field_70262_b = 2;
        this.field_70264_a = this.field_70146_Z.nextLong();
        this.field_70263_c = this.field_70146_Z.nextInt(3) + 1;
        this.field_184529_d = effectOnlyIn;
        Difficulty difficulty = worldIn.func_175659_aa();
        if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
            this.func_195053_a(4);
        }
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.WEATHER;
    }

    public void func_204809_d(@Nullable ServerPlayerEntity p_204809_1_) {
        this.field_204810_e = p_204809_1_;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70262_b == 2) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        --this.field_70262_b;
        if (this.field_70262_b < 0) {
            if (this.field_70263_c == 0) {
                this.func_70106_y();
            } else if (this.field_70262_b < -this.field_70146_Z.nextInt(10)) {
                --this.field_70263_c;
                this.field_70262_b = 1;
                this.field_70264_a = this.field_70146_Z.nextLong();
                this.func_195053_a(0);
            }
        }
        if (this.field_70262_b >= 0) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175702_c(2);
            } else if (!this.field_184529_d) {
                double d0 = 3.0;
                List<Entity> list = this.field_70170_p.func_175674_a(this, new AxisAlignedBB(this.field_70165_t - 3.0, this.field_70163_u - 3.0, this.field_70161_v - 3.0, this.field_70165_t + 3.0, this.field_70163_u + 6.0 + 3.0, this.field_70161_v + 3.0), Entity::func_70089_S);
                for (Entity entity : list) {
                    if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBoltEntity)this)) continue;
                    entity.func_70077_a(this);
                }
                if (this.field_204810_e != null) {
                    CriteriaTriggers.field_204812_E.func_204814_a(this.field_204810_e, list);
                }
            }
        }
    }

    private void func_195053_a(int extraIgnitions) {
        if (!this.field_184529_d && !this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            BlockState blockstate = Blocks.field_150480_ab.func_176223_P();
            BlockPos blockpos = new BlockPos((Entity)this);
            if (this.field_70170_p.func_180495_p(blockpos).func_196958_f() && blockstate.func_196955_c(this.field_70170_p, blockpos)) {
                this.field_70170_p.func_175656_a(blockpos, blockstate);
            }
            for (int i = 0; i < extraIgnitions; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                if (!this.field_70170_p.func_180495_p(blockpos1).func_196958_f() || !blockstate.func_196955_c(this.field_70170_p, blockpos1)) continue;
                this.field_70170_p.func_175656_a(blockpos1, blockstate);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * LightningBoltEntity.func_184183_bd();
        return distance < d0 * d0;
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnGlobalEntityPacket((Entity)this);
    }
}

