/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public enum DyeColor implements IStringSerializable
{
    WHITE(0, "white", 0xF9FFFE, MaterialColor.field_151666_j, 0xF0F0F0, 0xFFFFFF),
    ORANGE(1, "orange", 16351261, MaterialColor.field_151676_q, 15435844, 16738335),
    MAGENTA(2, "magenta", 13061821, MaterialColor.field_151675_r, 12801229, 0xFF00FF),
    LIGHT_BLUE(3, "light_blue", 3847130, MaterialColor.field_151674_s, 6719955, 10141901),
    YELLOW(4, "yellow", 16701501, MaterialColor.field_151673_t, 14602026, 0xFFFF00),
    LIME(5, "lime", 8439583, MaterialColor.field_151672_u, 4312372, 0xBFFF00),
    PINK(6, "pink", 15961002, MaterialColor.field_151671_v, 14188952, 16738740),
    GRAY(7, "gray", 4673362, MaterialColor.field_151670_w, 0x434343, 0x808080),
    LIGHT_GRAY(8, "light_gray", 0x9D9D97, MaterialColor.field_197656_x, 0xABABAB, 0xD3D3D3),
    CYAN(9, "cyan", 1481884, MaterialColor.field_151679_y, 2651799, 65535),
    PURPLE(10, "purple", 8991416, MaterialColor.field_151678_z, 8073150, 10494192),
    BLUE(11, "blue", 3949738, MaterialColor.field_151649_A, 2437522, 255),
    BROWN(12, "brown", 8606770, MaterialColor.field_151650_B, 5320730, 9127187),
    GREEN(13, "green", 6192150, MaterialColor.field_151651_C, 3887386, 65280),
    RED(14, "red", 11546150, MaterialColor.field_151645_D, 11743532, 0xFF0000),
    BLACK(15, "black", 0x1D1D21, MaterialColor.field_151646_E, 0x1E1B1B, 0);

    private static final DyeColor[] field_196062_q;
    private static final Int2ObjectOpenHashMap<DyeColor> field_196063_r;
    private final int field_196064_s;
    private final String field_176785_v;
    private final MaterialColor field_196065_u;
    private final int field_193351_w;
    private final int field_196066_w;
    private final float[] field_193352_x;
    private final int field_196067_y;
    private final Tag<Item> tag;
    private final int field_218390_z;

    private DyeColor(int p_i50049_3_, String p_i50049_4_, int p_i50049_5_, MaterialColor p_i50049_6_, int p_i50049_7_, int p_i50049_8_) {
        this.field_196064_s = p_i50049_3_;
        this.field_176785_v = p_i50049_4_;
        this.field_193351_w = p_i50049_5_;
        this.field_196065_u = p_i50049_6_;
        this.field_218390_z = p_i50049_8_;
        int i = (p_i50049_5_ & 0xFF0000) >> 16;
        int j = (p_i50049_5_ & 0xFF00) >> 8;
        int k = (p_i50049_5_ & 0xFF) >> 0;
        this.field_196066_w = k << 16 | j << 8 | i << 0;
        this.tag = new ItemTags.Wrapper(new ResourceLocation("forge", "dyes/" + p_i50049_4_));
        this.field_193352_x = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
        this.field_196067_y = p_i50049_7_;
    }

    public int func_196059_a() {
        return this.field_196064_s;
    }

    public String func_176762_d() {
        return this.field_176785_v;
    }

    public int func_196057_c() {
        return this.field_196066_w;
    }

    public float[] func_193349_f() {
        return this.field_193352_x;
    }

    public MaterialColor func_196055_e() {
        return this.field_196065_u;
    }

    public int func_196060_f() {
        return this.field_196067_y;
    }

    public int func_218388_g() {
        return this.field_218390_z;
    }

    public static DyeColor func_196056_a(int p_196056_0_) {
        if (p_196056_0_ < 0 || p_196056_0_ >= field_196062_q.length) {
            p_196056_0_ = 0;
        }
        return field_196062_q[p_196056_0_];
    }

    public static DyeColor func_204271_a(String p_204271_0_, DyeColor p_204271_1_) {
        for (DyeColor dyecolor : DyeColor.values()) {
            if (!dyecolor.field_176785_v.equals(p_204271_0_)) continue;
            return dyecolor;
        }
        return p_204271_1_;
    }

    @Nullable
    public static DyeColor func_196058_b(int p_196058_0_) {
        return (DyeColor)((Object)field_196063_r.get(p_196058_0_));
    }

    public String toString() {
        return this.field_176785_v;
    }

    public String func_176610_l() {
        return this.field_176785_v;
    }

    public int getColorValue() {
        return this.field_193351_w;
    }

    public Tag<Item> getTag() {
        return this.tag;
    }

    @Nullable
    public static DyeColor getColor(ItemStack stack) {
        if (stack.func_77973_b() instanceof DyeItem) {
            return ((DyeItem)stack.func_77973_b()).func_195962_g();
        }
        for (DyeColor color : field_196062_q) {
            if (!stack.func_77973_b().func_206844_a(color.getTag())) continue;
            return color;
        }
        return null;
    }

    static {
        field_196062_q = (DyeColor[])Arrays.stream(DyeColor.values()).sorted(Comparator.comparingInt(DyeColor::func_196059_a)).toArray(DyeColor[]::new);
        field_196063_r = new Int2ObjectOpenHashMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(p_199793_0_ -> p_199793_0_.field_196067_y, p_199794_0_ -> p_199794_0_)));
    }
}

