/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PistonTileEntity
extends TileEntity
implements ITickableTileEntity {
    private BlockState field_200231_a;
    private Direction field_174931_f;
    private boolean field_145875_k;
    private boolean field_145872_l;
    private static final ThreadLocal<Direction> field_190613_i = new ThreadLocal<Direction>(){

        @Override
        protected Direction initialValue() {
            return null;
        }
    };
    private float field_145873_m;
    private float field_145870_n;
    private long field_211147_k;

    public PistonTileEntity() {
        super(TileEntityType.field_200980_k);
    }

    public PistonTileEntity(BlockState pistonStateIn, Direction pistonFacingIn, boolean extendingIn, boolean shouldHeadBeRenderedIn) {
        this();
        this.field_200231_a = pistonStateIn;
        this.field_174931_f = pistonFacingIn;
        this.field_145875_k = extendingIn;
        this.field_145872_l = shouldHeadBeRenderedIn;
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_145868_b() {
        return this.field_145875_k;
    }

    public Direction func_212363_d() {
        return this.field_174931_f;
    }

    public boolean func_145867_d() {
        return this.field_145872_l;
    }

    public float func_145860_a(float ticks) {
        if (ticks > 1.0f) {
            ticks = 1.0f;
        }
        return MathHelper.func_219799_g((float)ticks, (float)this.field_145870_n, (float)this.field_145873_m);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_174929_b(float ticks) {
        return (float)this.field_174931_f.func_82601_c() * this.func_184320_e(this.func_145860_a(ticks));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_174928_c(float ticks) {
        return (float)this.field_174931_f.func_96559_d() * this.func_184320_e(this.func_145860_a(ticks));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_174926_d(float ticks) {
        return (float)this.field_174931_f.func_82599_e() * this.func_184320_e(this.func_145860_a(ticks));
    }

    private float func_184320_e(float p_184320_1_) {
        return this.field_145875_k ? p_184320_1_ - 1.0f : 1.0f - p_184320_1_;
    }

    private BlockState func_190606_j() {
        return !this.func_145868_b() && this.func_145867_d() && this.field_200231_a.func_177230_c() instanceof PistonBlock ? (BlockState)((Object)((BlockState)((Object)Blocks.field_150332_K.func_176223_P().func_206870_a((IProperty)PistonHeadBlock.field_176325_b, (Comparable)(this.field_200231_a.func_177230_c() == Blocks.field_150320_F ? PistonType.STICKY : PistonType.DEFAULT)))).func_206870_a((IProperty)PistonHeadBlock.field_176387_N, this.field_200231_a.func_177229_b((IProperty)PistonBlock.field_176387_N))) : this.field_200231_a;
    }

    private void func_184322_i(float p_184322_1_) {
        List list;
        AxisAlignedBB axisalignedbb;
        List list1;
        Direction direction = this.func_195509_h();
        double d0 = p_184322_1_ - this.field_145873_m;
        VoxelShape voxelshape = this.func_190606_j().func_196952_d((IBlockReader)this.field_145850_b, this.func_174877_v());
        if (!voxelshape.func_197766_b() && !(list1 = this.field_145850_b.func_72839_b(null, this.func_190610_a(axisalignedbb = this.func_190607_a(this.func_191515_a(list = voxelshape.func_197756_d())), direction, d0).func_111270_a(axisalignedbb))).isEmpty()) {
            boolean flag = this.field_200231_a.func_177230_c().isStickyBlock(this.field_200231_a);
            for (int i = 0; i < list1.size(); ++i) {
                AxisAlignedBB axisalignedbb1;
                AxisAlignedBB axisalignedbb2;
                Entity entity = (Entity)((Object)list1.get(i));
                if (entity.func_184192_z() == PushReaction.IGNORE) continue;
                if (flag) {
                    Vec3d vec3d = entity.func_213322_ci();
                    double d1 = vec3d.field_72450_a;
                    double d2 = vec3d.field_72448_b;
                    double d3 = vec3d.field_72449_c;
                    switch (direction.func_176740_k()) {
                        case X: {
                            d1 = direction.func_82601_c();
                            break;
                        }
                        case Y: {
                            d2 = direction.func_96559_d();
                            break;
                        }
                        case Z: {
                            d3 = direction.func_82599_e();
                        }
                    }
                    entity.func_213293_j(d1, d2, d3);
                }
                double d4 = 0.0;
                for (int j = 0; !(j >= list.size() || (axisalignedbb2 = this.func_190610_a(this.func_190607_a((AxisAlignedBB)list.get(j)), direction, d0)).func_72326_a(axisalignedbb1 = entity.func_174813_aQ()) && (d4 = Math.max(d4, this.func_190612_a(axisalignedbb2, direction, axisalignedbb1))) >= d0); ++j) {
                }
                if (d4 <= 0.0) continue;
                d4 = Math.min(d4, d0) + 0.01;
                field_190613_i.set(direction);
                entity.func_213315_a(MoverType.PISTON, new Vec3d(d4 * (double)direction.func_82601_c(), d4 * (double)direction.func_96559_d(), d4 * (double)direction.func_82599_e()));
                field_190613_i.set(null);
                if (this.field_145875_k || !this.field_145872_l) continue;
                this.func_190605_a(entity, direction, d0);
            }
        }
    }

    public Direction func_195509_h() {
        return this.field_145875_k ? this.field_174931_f : this.field_174931_f.func_176734_d();
    }

    private AxisAlignedBB func_191515_a(List<AxisAlignedBB> p_191515_1_) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        for (AxisAlignedBB axisalignedbb : p_191515_1_) {
            d0 = Math.min(axisalignedbb.field_72340_a, d0);
            d1 = Math.min(axisalignedbb.field_72338_b, d1);
            d2 = Math.min(axisalignedbb.field_72339_c, d2);
            d3 = Math.max(axisalignedbb.field_72336_d, d3);
            d4 = Math.max(axisalignedbb.field_72337_e, d4);
            d5 = Math.max(axisalignedbb.field_72334_f, d5);
        }
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    private double func_190612_a(AxisAlignedBB p_190612_1_, Direction facing, AxisAlignedBB p_190612_3_) {
        switch (facing.func_176740_k()) {
            case X: {
                return PistonTileEntity.func_190611_b(p_190612_1_, facing, p_190612_3_);
            }
            default: {
                return PistonTileEntity.func_190608_c(p_190612_1_, facing, p_190612_3_);
            }
            case Z: 
        }
        return PistonTileEntity.func_190604_d(p_190612_1_, facing, p_190612_3_);
    }

    private AxisAlignedBB func_190607_a(AxisAlignedBB p_190607_1_) {
        double d0 = this.func_184320_e(this.field_145873_m);
        return p_190607_1_.func_72317_d((double)this.field_174879_c.func_177958_n() + d0 * (double)this.field_174931_f.func_82601_c(), (double)this.field_174879_c.func_177956_o() + d0 * (double)this.field_174931_f.func_96559_d(), (double)this.field_174879_c.func_177952_p() + d0 * (double)this.field_174931_f.func_82599_e());
    }

    private AxisAlignedBB func_190610_a(AxisAlignedBB p_190610_1_, Direction p_190610_2_, double p_190610_3_) {
        double d0 = p_190610_3_ * (double)p_190610_2_.func_176743_c().func_179524_a();
        double d1 = Math.min(d0, 0.0);
        double d2 = Math.max(d0, 0.0);
        switch (p_190610_2_) {
            case WEST: {
                return new AxisAlignedBB(p_190610_1_.field_72340_a + d1, p_190610_1_.field_72338_b, p_190610_1_.field_72339_c, p_190610_1_.field_72340_a + d2, p_190610_1_.field_72337_e, p_190610_1_.field_72334_f);
            }
            case EAST: {
                return new AxisAlignedBB(p_190610_1_.field_72336_d + d1, p_190610_1_.field_72338_b, p_190610_1_.field_72339_c, p_190610_1_.field_72336_d + d2, p_190610_1_.field_72337_e, p_190610_1_.field_72334_f);
            }
            case DOWN: {
                return new AxisAlignedBB(p_190610_1_.field_72340_a, p_190610_1_.field_72338_b + d1, p_190610_1_.field_72339_c, p_190610_1_.field_72336_d, p_190610_1_.field_72338_b + d2, p_190610_1_.field_72334_f);
            }
            default: {
                return new AxisAlignedBB(p_190610_1_.field_72340_a, p_190610_1_.field_72337_e + d1, p_190610_1_.field_72339_c, p_190610_1_.field_72336_d, p_190610_1_.field_72337_e + d2, p_190610_1_.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(p_190610_1_.field_72340_a, p_190610_1_.field_72338_b, p_190610_1_.field_72339_c + d1, p_190610_1_.field_72336_d, p_190610_1_.field_72337_e, p_190610_1_.field_72339_c + d2);
            }
            case SOUTH: 
        }
        return new AxisAlignedBB(p_190610_1_.field_72340_a, p_190610_1_.field_72338_b, p_190610_1_.field_72334_f + d1, p_190610_1_.field_72336_d, p_190610_1_.field_72337_e, p_190610_1_.field_72334_f + d2);
    }

    private void func_190605_a(Entity p_190605_1_, Direction p_190605_2_, double p_190605_3_) {
        double d1;
        Direction direction;
        double d0;
        AxisAlignedBB axisalignedbb1;
        AxisAlignedBB axisalignedbb = p_190605_1_.func_174813_aQ();
        if (axisalignedbb.func_72326_a(axisalignedbb1 = VoxelShapes.func_197868_b().func_197752_a().func_186670_a(this.field_174879_c)) && Math.abs((d0 = this.func_190612_a(axisalignedbb1, direction = p_190605_2_.func_176734_d(), axisalignedbb) + 0.01) - (d1 = this.func_190612_a(axisalignedbb1, direction, axisalignedbb.func_191500_a(axisalignedbb1)) + 0.01)) < 0.01) {
            d0 = Math.min(d0, p_190605_3_) + 0.01;
            field_190613_i.set(p_190605_2_);
            p_190605_1_.func_213315_a(MoverType.PISTON, new Vec3d(d0 * (double)direction.func_82601_c(), d0 * (double)direction.func_96559_d(), d0 * (double)direction.func_82599_e()));
            field_190613_i.set(null);
        }
    }

    private static double func_190611_b(AxisAlignedBB p_190611_0_, Direction facing, AxisAlignedBB p_190611_2_) {
        return facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? p_190611_0_.field_72336_d - p_190611_2_.field_72340_a : p_190611_2_.field_72336_d - p_190611_0_.field_72340_a;
    }

    private static double func_190608_c(AxisAlignedBB p_190608_0_, Direction facing, AxisAlignedBB p_190608_2_) {
        return facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? p_190608_0_.field_72337_e - p_190608_2_.field_72338_b : p_190608_2_.field_72337_e - p_190608_0_.field_72338_b;
    }

    private static double func_190604_d(AxisAlignedBB p_190604_0_, Direction facing, AxisAlignedBB p_190604_2_) {
        return facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? p_190604_0_.field_72334_f - p_190604_2_.field_72339_c : p_190604_2_.field_72334_f - p_190604_0_.field_72339_c;
    }

    public BlockState func_200230_i() {
        return this.field_200231_a;
    }

    public void func_145866_f() {
        if (this.field_145870_n < 1.0f && this.field_145850_b != null) {
            this.field_145870_n = this.field_145873_m = 1.0f;
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.func_145843_s();
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == Blocks.field_196603_bb) {
                BlockState blockstate = this.field_145872_l ? Blocks.field_150350_a.func_176223_P() : Block.func_199770_b(this.field_200231_a, this.field_145850_b, this.field_174879_c);
                this.field_145850_b.func_180501_a(this.field_174879_c, blockstate, 3);
                this.field_145850_b.func_190524_a(this.field_174879_c, blockstate.func_177230_c(), this.field_174879_c);
            }
        }
    }

    public void func_73660_a() {
        this.field_211147_k = this.field_145850_b.func_82737_E();
        this.field_145870_n = this.field_145873_m;
        if (this.field_145870_n >= 1.0f) {
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.func_145843_s();
            if (this.field_200231_a != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == Blocks.field_196603_bb) {
                BlockState blockstate = Block.func_199770_b(this.field_200231_a, this.field_145850_b, this.field_174879_c);
                if (blockstate.func_196958_f()) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, this.field_200231_a, 84);
                    Block.func_196263_a(this.field_200231_a, blockstate, this.field_145850_b, this.field_174879_c, 3);
                } else {
                    if (blockstate.func_196959_b((IProperty)BlockStateProperties.field_208198_y) && ((Boolean)blockstate.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
                        blockstate = (BlockState)((Object)blockstate.func_206870_a((IProperty)BlockStateProperties.field_208198_y, Boolean.valueOf(false)));
                    }
                    this.field_145850_b.func_180501_a(this.field_174879_c, blockstate, 67);
                    this.field_145850_b.func_190524_a(this.field_174879_c, blockstate.func_177230_c(), this.field_174879_c);
                }
            }
        } else {
            float f = this.field_145873_m + 0.5f;
            this.func_184322_i(f);
            this.field_145873_m = f;
            if (this.field_145873_m >= 1.0f) {
                this.field_145873_m = 1.0f;
            }
        }
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.field_200231_a = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("blockState"));
        this.field_174931_f = Direction.func_82600_a(compound.func_74762_e("facing"));
        this.field_145870_n = this.field_145873_m = compound.func_74760_g("progress");
        this.field_145875_k = compound.func_74767_n("extending");
        this.field_145872_l = compound.func_74767_n("source");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("blockState", NBTUtil.func_190009_a((BlockState)this.field_200231_a));
        compound.func_74768_a("facing", this.field_174931_f.func_176745_a());
        compound.func_74776_a("progress", this.field_145870_n);
        compound.func_74757_a("extending", this.field_145875_k);
        compound.func_74757_a("source", this.field_145872_l);
        return compound;
    }

    public VoxelShape func_195508_a(IBlockReader p_195508_1_, BlockPos p_195508_2_) {
        VoxelShape voxelshape = !this.field_145875_k && this.field_145872_l ? ((BlockState)((Object)this.field_200231_a.func_206870_a((IProperty)PistonBlock.field_176320_b, Boolean.valueOf(true)))).func_196952_d(p_195508_1_, p_195508_2_) : VoxelShapes.func_197880_a();
        Direction direction = field_190613_i.get();
        if ((double)this.field_145873_m < 1.0 && direction == this.func_195509_h()) {
            return voxelshape;
        }
        BlockState blockstate = this.func_145867_d() ? (BlockState)((Object)((BlockState)((Object)Blocks.field_150332_K.func_176223_P().func_206870_a((IProperty)PistonHeadBlock.field_176387_N, (Comparable)((Object)this.field_174931_f)))).func_206870_a((IProperty)PistonHeadBlock.field_176327_M, Boolean.valueOf(this.field_145875_k != 1.0f - this.field_145873_m < 4.0f))) : this.field_200231_a;
        float f = this.func_184320_e(this.field_145873_m);
        double d0 = (float)this.field_174931_f.func_82601_c() * f;
        double d1 = (float)this.field_174931_f.func_96559_d() * f;
        double d2 = (float)this.field_174931_f.func_82599_e() * f;
        return VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)blockstate.func_196952_d(p_195508_1_, p_195508_2_).func_197751_a(d0, d1, d2));
    }

    public long func_211146_k() {
        return this.field_211147_k;
    }
}

