/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.IPlantable;

public abstract class HugeTreesFeature<T extends IFeatureConfig>
extends AbstractTreeFeature<T> {
    protected final int field_76522_a;
    protected final BlockState field_76520_b;
    protected final BlockState field_76521_c;
    protected final int field_150538_d;

    public HugeTreesFeature(Function<Dynamic<?>, ? extends T> configFactoryIn, boolean doBlockNotifyOnPlace, int baseHeightIn, int extraRandomHeightIn, BlockState trunkIn, BlockState leafIn) {
        super(configFactoryIn, doBlockNotifyOnPlace);
        this.field_76522_a = baseHeightIn;
        this.field_150538_d = extraRandomHeightIn;
        this.field_76520_b = trunkIn;
        this.field_76521_c = leafIn;
        this.setSapling((IPlantable)Blocks.field_196674_t);
    }

    protected int func_150533_a(Random rand) {
        int i = rand.nextInt(3) + this.field_76522_a;
        if (this.field_150538_d > 1) {
            i += rand.nextInt(this.field_150538_d);
        }
        return i;
    }

    private boolean func_175926_c(IWorldGenerationBaseReader worldIn, BlockPos leavesPos, int height) {
        boolean flag = true;
        if (leavesPos.func_177956_o() >= 1 && leavesPos.func_177956_o() + height + 1 <= worldIn.getMaxHeight()) {
            for (int i = 0; i <= 1 + height; ++i) {
                int j = 2;
                if (i == 0) {
                    j = 1;
                } else if (i >= 1 + height - 2) {
                    j = 2;
                }
                for (int k = -j; k <= j && flag; ++k) {
                    for (int l = -j; l <= j && flag; ++l) {
                        if (leavesPos.func_177956_o() + i >= 0 && leavesPos.func_177956_o() + i < worldIn.getMaxHeight() && HugeTreesFeature.func_214587_a(worldIn, leavesPos.func_177982_a(k, i, l))) continue;
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }

    private boolean func_202405_b(IWorldGenerationReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        if (HugeTreesFeature.isSoil((IWorldGenerationBaseReader)worldIn, blockpos, this.getSapling()) && pos.func_177956_o() >= 2) {
            this.setDirtAt(worldIn, blockpos, pos);
            this.setDirtAt(worldIn, blockpos.func_177974_f(), pos);
            this.setDirtAt(worldIn, blockpos.func_177968_d(), pos);
            this.setDirtAt(worldIn, blockpos.func_177968_d().func_177974_f(), pos);
            return true;
        }
        return false;
    }

    protected boolean func_203427_a(IWorldGenerationReader worldIn, BlockPos p_203427_2_, int p_203427_3_) {
        return this.func_175926_c((IWorldGenerationBaseReader)worldIn, p_203427_2_, p_203427_3_) && this.func_202405_b(worldIn, p_203427_2_);
    }

    protected void func_222839_a(IWorldGenerationReader worldIn, BlockPos p_222839_2_, int p_222839_3_, MutableBoundingBox p_222839_4_, Set<BlockPos> p_222839_5_) {
        int i = p_222839_3_ * p_222839_3_;
        for (int j = -p_222839_3_; j <= p_222839_3_ + 1; ++j) {
            for (int k = -p_222839_3_; k <= p_222839_3_ + 1; ++k) {
                BlockPos blockpos;
                int i1;
                int l = Math.min(Math.abs(j), Math.abs(j - 1));
                if (l + (i1 = Math.min(Math.abs(k), Math.abs(k - 1))) >= 7 || l * l + i1 * i1 > i || !HugeTreesFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, blockpos = p_222839_2_.func_177982_a(j, 0, k))) continue;
                this.func_208520_a(p_222839_5_, (IWorldWriter)worldIn, blockpos, this.field_76521_c, p_222839_4_);
            }
        }
    }

    protected void func_222838_b(IWorldGenerationReader worldIn, BlockPos p_222838_2_, int p_222838_3_, MutableBoundingBox p_222838_4_, Set<BlockPos> p_222838_5_) {
        int i = p_222838_3_ * p_222838_3_;
        for (int j = -p_222838_3_; j <= p_222838_3_; ++j) {
            for (int k = -p_222838_3_; k <= p_222838_3_; ++k) {
                BlockPos blockpos;
                if (j * j + k * k > i || !HugeTreesFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, blockpos = p_222838_2_.func_177982_a(j, 0, k))) continue;
                this.func_208520_a(p_222838_5_, (IWorldWriter)worldIn, blockpos, this.field_76521_c, p_222838_4_);
            }
        }
    }
}

