/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.ILootFunctionConsumer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.ValidationResults;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTable {
    private static final Logger field_186465_b = LogManager.getLogger();
    public static final LootTable field_186464_a = new LootTable(LootParameterSets.field_216260_a, new LootPool[0], new ILootFunction[0]);
    public static final LootParameterSet field_216126_b = LootParameterSets.field_216266_g;
    private final LootParameterSet field_216127_d;
    private final List<LootPool> field_186466_c;
    private final ILootFunction[] field_216128_f;
    private final BiFunction<ItemStack, LootContext, ItemStack> field_216129_g;
    private boolean isFrozen = false;

    private LootTable(LootParameterSet p_i51265_1_, LootPool[] p_i51265_2_, ILootFunction[] p_i51265_3_) {
        this.field_216127_d = p_i51265_1_;
        this.field_186466_c = Lists.newArrayList((Object[])p_i51265_2_);
        this.field_216128_f = p_i51265_3_;
        this.field_216129_g = LootFunctionManager.func_216241_a((BiFunction[])p_i51265_3_);
    }

    public static Consumer<ItemStack> func_216124_a(Consumer<ItemStack> p_216124_0_) {
        return p_216125_1_ -> {
            if (p_216125_1_.func_190916_E() < p_216125_1_.func_77976_d()) {
                p_216124_0_.accept((ItemStack)((Object)p_216125_1_));
            } else {
                ItemStack itemstack;
                for (int i = p_216125_1_.func_190916_E(); i > 0; i -= itemstack.func_190916_E()) {
                    itemstack = p_216125_1_.func_77946_l();
                    itemstack.func_190920_e(Math.min(p_216125_1_.func_77976_d(), i));
                    p_216124_0_.accept(itemstack);
                }
            }
        };
    }

    public void func_216114_a(LootContext p_216114_1_, Consumer<ItemStack> p_216114_2_) {
        if (p_216114_1_.func_186496_a(this)) {
            Consumer consumer = ILootFunction.func_215858_a(this.field_216129_g, p_216114_2_, (LootContext)p_216114_1_);
            for (LootPool lootpool : this.field_186466_c) {
                lootpool.func_216091_a(consumer, p_216114_1_);
            }
            p_216114_1_.func_186490_b(this);
        } else {
            field_186465_b.warn("Detected infinite loop in loot tables");
        }
    }

    @Deprecated
    public void func_216120_b(LootContext p_216120_1_, Consumer<ItemStack> p_216120_2_) {
        this.func_216114_a(p_216120_1_, LootTable.func_216124_a(p_216120_2_));
    }

    public List<ItemStack> func_216113_a(LootContext p_216113_1_) {
        List list = Lists.newArrayList();
        this.func_216120_b(p_216113_1_, list::add);
        list = ForgeHooks.modifyLoot((List)list, (LootContext)p_216113_1_);
        return list;
    }

    public LootParameterSet func_216122_a() {
        return this.field_216127_d;
    }

    public void func_216117_a(ValidationResults p_216117_1_, Function<ResourceLocation, LootTable> p_216117_2_, Set<ResourceLocation> p_216117_3_, LootParameterSet p_216117_4_) {
        for (int i = 0; i < this.field_186466_c.size(); ++i) {
            this.field_186466_c.get(i).func_216099_a(p_216117_1_.func_216108_b(".pools[" + i + "]"), p_216117_2_, p_216117_3_, p_216117_4_);
        }
        for (int j = 0; j < this.field_216128_f.length; ++j) {
            this.field_216128_f[j].func_215856_a(p_216117_1_.func_216108_b(".functions[" + j + "]"), p_216117_2_, p_216117_3_, p_216117_4_);
        }
    }

    public void func_216118_a(IInventory p_216118_1_, LootContext p_216118_2_) {
        List<ItemStack> list = this.func_216113_a(p_216118_2_);
        Random random = p_216118_2_.func_216032_b();
        List<Integer> list1 = this.func_186459_a(p_216118_1_, random);
        this.func_186463_a(list, list1.size(), random);
        for (ItemStack itemstack : list) {
            if (list1.isEmpty()) {
                field_186465_b.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.func_190926_b()) {
                p_216118_1_.func_70299_a(list1.remove(list1.size() - 1).intValue(), ItemStack.field_190927_a);
                continue;
            }
            p_216118_1_.func_70299_a(list1.remove(list1.size() - 1).intValue(), itemstack);
        }
    }

    private void func_186463_a(List<ItemStack> stacks, int p_186463_2_, Random rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.func_190926_b()) {
                iterator.remove();
                continue;
            }
            if (itemstack.func_190916_E() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (p_186463_2_ - stacks.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)((Object)list.remove(MathHelper.func_76136_a((Random)rand, (int)0, (int)(list.size() - 1))));
            int i = MathHelper.func_76136_a((Random)rand, (int)1, (int)(itemstack2.func_190916_E() / 2));
            ItemStack itemstack1 = itemstack2.func_77979_a(i);
            if (itemstack2.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, rand);
    }

    private List<Integer> func_186459_a(IInventory inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public static Builder func_216119_b() {
        return new Builder();
    }

    public void freeze() {
        this.isFrozen = true;
        this.field_186466_c.forEach(LootPool::freeze);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootTable after being finalized!");
        }
    }

    public LootPool getPool(String name) {
        return this.field_186466_c.stream().filter(e -> name.equals(e.getName())).findFirst().orElse(null);
    }

    public LootPool removePool(String name) {
        this.checkFrozen();
        for (LootPool pool : this.field_186466_c) {
            if (!name.equals(pool.getName())) continue;
            this.field_186466_c.remove(pool);
            return pool;
        }
        return null;
    }

    public void addPool(LootPool pool) {
        this.checkFrozen();
        if (this.field_186466_c.stream().anyMatch(e -> e == pool || e.getName().equals(pool.getName()))) {
            throw new RuntimeException("Attempted to add a duplicate pool to loot table: " + pool.getName());
        }
        this.field_186466_c.add(pool);
    }

    public static class Serializer
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)p_deserialize_1_, (String)"loot table");
            LootPool[] alootpool = (LootPool[])JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"pools", (Object)new LootPool[0], (JsonDeserializationContext)p_deserialize_3_, LootPool[].class);
            LootParameterSet lootparameterset = null;
            if (jsonobject.has("type")) {
                String s = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"type");
                lootparameterset = LootParameterSets.func_216256_a(new ResourceLocation(s));
            }
            ILootFunction[] ailootfunction = (ILootFunction[])JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"functions", (Object)new ILootFunction[0], (JsonDeserializationContext)p_deserialize_3_, ILootFunction[].class);
            return new LootTable(lootparameterset != null ? lootparameterset : LootParameterSets.field_216266_g, alootpool, ailootfunction);
        }

        public JsonElement serialize(LootTable p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject jsonobject = new JsonObject();
            if (p_serialize_1_.field_216127_d != field_216126_b) {
                ResourceLocation resourcelocation = LootParameterSets.func_216257_a(p_serialize_1_.field_216127_d);
                if (resourcelocation != null) {
                    jsonobject.addProperty("type", resourcelocation.toString());
                } else {
                    field_186465_b.warn("Failed to find id for param set " + p_serialize_1_.field_216127_d);
                }
            }
            if (!p_serialize_1_.field_186466_c.isEmpty()) {
                jsonobject.add("pools", p_serialize_3_.serialize((Object)p_serialize_1_.field_186466_c));
            }
            if (!ArrayUtils.isEmpty((Object[])p_serialize_1_.field_216128_f)) {
                jsonobject.add("functions", p_serialize_3_.serialize((Object)p_serialize_1_.field_216128_f));
            }
            return jsonobject;
        }
    }

    public static class Builder
    implements ILootFunctionConsumer<Builder> {
        private final List<LootPool> field_216041_a = Lists.newArrayList();
        private final List<ILootFunction> field_216042_b = Lists.newArrayList();
        private LootParameterSet field_216043_c = field_216126_b;

        public Builder func_216040_a(LootPool.Builder lootPoolIn) {
            this.field_216041_a.add(lootPoolIn.func_216044_b());
            return this;
        }

        public Builder func_216039_a(LootParameterSet parameterSet) {
            this.field_216043_c = parameterSet;
            return this;
        }

        public Builder func_212841_b_(ILootFunction.IBuilder functionBuilder) {
            this.field_216042_b.add(functionBuilder.func_216052_b());
            return this;
        }

        public Builder func_212862_c_() {
            return this;
        }

        public LootTable func_216038_b() {
            return new LootTable(this.field_216043_c, this.field_216041_a.toArray(new LootPool[0]), this.field_216042_b.toArray(new ILootFunction[0]));
        }
    }
}

