/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.geometry.IMultipartModelGeometry;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class CompositeModel
implements IDynamicBakedModel {
    private final ImmutableMap<String, IBakedModel> bakedParts;
    private final boolean isAmbientOcclusion;
    private final boolean isGui3d;
    private final TextureAtlasSprite particle;
    private final ItemOverrideList overrides;
    private final IModelState transforms;

    public CompositeModel(boolean isGui3d, boolean isAmbientOcclusion, TextureAtlasSprite particle, ImmutableMap<String, IBakedModel> bakedParts, IModelState combinedState, ItemOverrideList overrides) {
        this.bakedParts = bakedParts;
        this.isAmbientOcclusion = isAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.particle = particle;
        this.overrides = overrides;
        this.transforms = combinedState;
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Map.Entry entry : this.bakedParts.entrySet()) {
            quads.addAll(((IBakedModel)entry.getValue()).getQuads(state, side, rand, CompositeModelData.get(extraData, (String)entry.getKey())));
        }
        return quads;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IEnviromentBlockReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        CompositeModelData composite = new CompositeModelData();
        for (Map.Entry entry : this.bakedParts.entrySet()) {
            composite.putSubmodelData((String)entry.getKey(), ((IBakedModel)entry.getValue()).getModelData(world, pos, state, (IModelData)new ModelDataWrapper(tileData)));
        }
        return composite;
    }

    public boolean func_177555_b() {
        return this.isAmbientOcclusion;
    }

    public boolean func_177556_c() {
        return this.isGui3d;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, cameraTransformType);
    }

    @Nullable
    public IBakedModel getPart(String name) {
        return (IBakedModel)this.bakedParts.get((Object)name);
    }

    private static class ModelDataWrapper
    extends ModelDataMap {
        private final IModelData parent;

        public ModelDataWrapper(IModelData parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasProperty(ModelProperty<?> prop) {
            return super.hasProperty(prop) || this.parent.hasProperty(prop);
        }

        @Override
        @Nullable
        public <T> T getData(ModelProperty<T> prop) {
            return super.hasProperty(prop) ? super.getData(prop) : this.parent.getData(prop);
        }

        @Override
        @Nullable
        public <T> T setData(ModelProperty<T> prop, T data) {
            return super.setData(prop, data);
        }
    }

    private static class CompositeModelData
    implements IModelData {
        public static final ModelProperty<CompositeModelData> SUBMODEL_DATA = new ModelProperty();
        private final Map<String, IModelData> parts = new HashMap<String, IModelData>();

        private CompositeModelData() {
        }

        public static Optional<CompositeModelData> get(IModelData modelData) {
            return Optional.ofNullable(modelData.getData(SUBMODEL_DATA));
        }

        public static IModelData get(IModelData modelData, String name) {
            return CompositeModelData.get(modelData).map(data -> data.getSubmodelData(name)).orElse(EmptyModelData.INSTANCE);
        }

        public IModelData getSubmodelData(String name) {
            if (this.parts.containsKey(name)) {
                return this.parts.get(name);
            }
            return EmptyModelData.INSTANCE;
        }

        public void putSubmodelData(String name, IModelData data) {
            this.parts.put(name, data);
        }

        @Override
        public boolean hasProperty(ModelProperty<?> prop) {
            return prop == SUBMODEL_DATA;
        }

        @Override
        @Nullable
        public <T> T getData(ModelProperty<T> prop) {
            if (prop == SUBMODEL_DATA) {
                return (T)this;
            }
            return null;
        }

        @Override
        @Nullable
        public <T> T setData(ModelProperty<T> prop, T data) {
            return null;
        }
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            if (!modelContents.has("parts")) {
                throw new RuntimeException("Composite model requires a \"parts\" element.");
            }
            ImmutableMap.Builder parts = ImmutableMap.builder();
            for (Map.Entry part : modelContents.get("parts").getAsJsonObject().entrySet()) {
                ModelRotation sprite = ModelRotation.X0_Y0;
                parts.put(part.getKey(), (Object)new Submodel((String)part.getKey(), (BlockModel)deserializationContext.deserialize((JsonElement)part.getValue(), BlockModel.class), (ISprite)sprite));
            }
            return new Geometry((ImmutableMap<String, Submodel>)parts.build());
        }
    }

    public static class Geometry
    implements IMultipartModelGeometry<Geometry> {
        private final ImmutableMap<String, Submodel> parts;

        Geometry(ImmutableMap<String, Submodel> parts) {
            this.parts = parts;
        }

        @Override
        public Collection<? extends IModelGeometryPart> getParts() {
            return this.parts.values();
        }

        @Override
        public Optional<? extends IModelGeometryPart> getPart(String name) {
            return Optional.ofNullable(this.parts.get((Object)name));
        }

        @Override
        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format, ItemOverrideList overrides) {
            String particleLocation = owner.resolveTexture("particle");
            TextureAtlasSprite particle = spriteGetter.apply(new ResourceLocation(particleLocation));
            ImmutableMap.Builder bakedParts = ImmutableMap.builder();
            for (Map.Entry part : this.parts.entrySet()) {
                Submodel submodel = (Submodel)part.getValue();
                if (!owner.getPartVisibility(submodel)) continue;
                bakedParts.put(part.getKey(), (Object)submodel.bake(bakery, spriteGetter, sprite, format));
            }
            return new CompositeModel(owner.isShadedInGui(), owner.useSmoothLighting(), particle, (ImmutableMap<String, IBakedModel>)bakedParts.build(), owner.getCombinedState(), overrides);
        }

        @Override
        public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            HashSet<ResourceLocation> textures = new HashSet<ResourceLocation>();
            for (Submodel part : this.parts.values()) {
                textures.addAll(part.getTextureDependencies(owner, modelGetter, missingTextureErrors));
            }
            return textures;
        }
    }

    private static class Submodel
    implements IModelGeometryPart {
        private final String name;
        private final BlockModel model;
        private final ISprite sprite;

        private Submodel(String name, BlockModel model, ISprite sprite) {
            this.name = name;
            this.model = model;
            this.sprite = sprite;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
            throw new UnsupportedOperationException("Attempted to call adQuads on a Submodel instance. Please don't.");
        }

        public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
            return this.model.bake(bakery, spriteGetter, (ISprite)new ModelStateComposition(this.sprite.getState(), sprite.getState(), this.sprite.func_188049_c() || sprite.func_188049_c()), format);
        }

        @Override
        public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            return this.model.func_209559_a(modelGetter, missingTextureErrors);
        }
    }
}

