/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.b3d;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.b3d.B3DClip;
import net.minecraftforge.client.model.b3d.B3DModel;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.model.animation.IJoint;
import net.minecraftforge.common.property.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum B3DLoader implements ICustomModelLoader
{
    INSTANCE;

    private static final Logger LOGGER;
    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, B3DModel> cache = new HashMap<ResourceLocation, B3DModel>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
    }

    @Override
    public void func_195410_a(IResourceManager manager) {
        this.manager = manager;
        this.cache.clear();
    }

    @Override
    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b()) && modelLocation.func_110623_a().endsWith(".b3d");
    }

    @Override
    public IUnbakedModel loadModel(ResourceLocation modelLocation) throws Exception {
        B3DModel model;
        ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        if (!this.cache.containsKey(file)) {
            IResource resource = null;
            try {
                try {
                    resource = this.manager.func_199002_a(file);
                }
                catch (FileNotFoundException e) {
                    if (modelLocation.func_110623_a().startsWith("models/block/")) {
                        resource = this.manager.func_199002_a(new ResourceLocation(file.func_110624_b(), "models/item/" + file.func_110623_a().substring("models/block/".length())));
                    }
                    if (modelLocation.func_110623_a().startsWith("models/item/")) {
                        resource = this.manager.func_199002_a(new ResourceLocation(file.func_110624_b(), "models/block/" + file.func_110623_a().substring("models/item/".length())));
                    }
                    throw e;
                }
                B3DModel.Parser parser = new B3DModel.Parser(resource.func_199027_b());
                B3DModel model2 = parser.parse();
                this.cache.put(file, model2);
            }
            catch (IOException e) {
                try {
                    this.cache.put(file, null);
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(resource);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)resource);
        }
        if ((model = this.cache.get(file)) == null) {
            throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + file);
        }
        if (!(model.getRoot().getKind() instanceof B3DModel.Mesh)) {
            return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of(), true, true, 1);
        }
        return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of((Object)model.getRoot().getName()), true, true, 1);
    }

    static {
        LOGGER = LogManager.getLogger();
    }

    private static final class BakedWrapper
    implements IDynamicBakedModel {
        private final B3DModel.Node<?> node;
        private final IModelState state;
        private final boolean smooth;
        private final boolean gui3d;
        private final VertexFormat format;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, TextureAtlasSprite> textures;
        private final LoadingCache<Integer, B3DState> cache;
        private ImmutableList<BakedQuad> quads;

        public BakedWrapper(final B3DModel.Node<?> node, final IModelState state, boolean smooth, boolean gui3d, VertexFormat format, ImmutableSet<String> meshes, ImmutableMap<String, TextureAtlasSprite> textures) {
            this(node, state, smooth, gui3d, format, meshes, textures, (LoadingCache<Integer, B3DState>)CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Integer, B3DState>(){

                public B3DState load(Integer frame) throws Exception {
                    IModelState parent = state;
                    B3DModel.Animation newAnimation = node.getAnimation();
                    if (parent instanceof B3DState) {
                        B3DState ps = (B3DState)parent;
                        parent = ps.getParent();
                    }
                    return new B3DState(newAnimation, frame, frame, 0.0f, parent);
                }
            }));
        }

        public BakedWrapper(B3DModel.Node<?> node, IModelState state, boolean smooth, boolean gui3d, VertexFormat format, ImmutableSet<String> meshes, ImmutableMap<String, TextureAtlasSprite> textures, LoadingCache<Integer, B3DState> cache) {
            this.node = node;
            this.state = state;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.format = format;
            this.meshes = meshes;
            this.textures = textures;
            this.cache = cache;
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
            ImmutableList.Builder builder;
            if (side != null) {
                return ImmutableList.of();
            }
            IModelState modelState = this.state;
            IModelState newState = data.getData(Properties.AnimationProperty);
            if (newState != null) {
                IModelState parent = this.state;
                if (parent instanceof B3DState) {
                    B3DState ps = (B3DState)parent;
                    parent = ps.getParent();
                }
                modelState = parent == null ? newState : new ModelStateComposition(parent, newState);
            }
            if (this.quads == null) {
                builder = ImmutableList.builder();
                this.generateQuads((ImmutableList.Builder<BakedQuad>)builder, this.node, this.state, (ImmutableList<String>)ImmutableList.of());
                this.quads = builder.build();
            }
            if (this.state != modelState) {
                builder = ImmutableList.builder();
                this.generateQuads((ImmutableList.Builder<BakedQuad>)builder, this.node, modelState, (ImmutableList<String>)ImmutableList.of());
                return builder.build();
            }
            return this.quads;
        }

        private void generateQuads(ImmutableList.Builder<BakedQuad> builder, B3DModel.Node<?> node, final IModelState state, ImmutableList<String> path) {
            ImmutableList.Builder pathBuilder = ImmutableList.builder();
            pathBuilder.addAll(path);
            pathBuilder.add((Object)node.getName());
            ImmutableList newPath = pathBuilder.build();
            for (B3DModel.Node child : node.getNodes().values()) {
                this.generateQuads(builder, child, state, (ImmutableList<String>)newPath);
            }
            if (node.getKind() instanceof B3DModel.Mesh && this.meshes.contains((Object)node.getName()) && !state.apply(Optional.of(Models.getHiddenModelPart((ImmutableList<String>)newPath))).isPresent()) {
                B3DModel.Mesh mesh = (B3DModel.Mesh)node.getKind();
                ImmutableList<B3DModel.Face> faces = mesh.bake(new Function<B3DModel.Node<?>, Matrix4f>(){
                    private final TRSRTransformation global;
                    private final LoadingCache<B3DModel.Node<?>, TRSRTransformation> localCache;
                    {
                        this.global = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
                        this.localCache = CacheBuilder.newBuilder().maximumSize(32L).build(new CacheLoader<B3DModel.Node<?>, TRSRTransformation>(){

                            public TRSRTransformation load(B3DModel.Node<?> node) throws Exception {
                                return state.apply(Optional.of(new NodeJoint(node))).orElse(TRSRTransformation.identity());
                            }
                        });
                    }

                    @Override
                    public Matrix4f apply(B3DModel.Node<?> node) {
                        return this.global.compose((TRSRTransformation)this.localCache.getUnchecked(node)).getMatrixVec();
                    }
                });
                for (B3DModel.Face f : faces) {
                    UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(this.format);
                    quadBuilder.setContractUVs(true);
                    quadBuilder.setQuadOrientation(Direction.func_176737_a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z));
                    List<B3DModel.Texture> textures = null;
                    if (f.getBrush() != null) {
                        textures = f.getBrush().getTextures();
                    }
                    TextureAtlasSprite sprite = textures == null || textures.isEmpty() ? (TextureAtlasSprite)this.textures.get((Object)"missingno") : (textures.get(0) == B3DModel.Texture.White ? ModelLoader.White.INSTANCE : (TextureAtlasSprite)this.textures.get((Object)textures.get(0).getPath()));
                    quadBuilder.setTexture(sprite);
                    this.putVertexData(quadBuilder, f.getV1(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV2(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), sprite);
                    builder.add((Object)quadBuilder.build());
                }
            }
        }

        private final void putVertexData(UnpackedBakedQuad.Builder builder, B3DModel.Vertex v, Vector3f faceNormal, TextureAtlasSprite sprite) {
            block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
                switch (this.format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        builder.put(e, v.getPos().x, v.getPos().y, v.getPos().z, 1.0f);
                        continue block6;
                    }
                    case COLOR: {
                        if (v.getColor() != null) {
                            builder.put(e, v.getColor().x, v.getColor().y, v.getColor().z, v.getColor().w);
                            continue block6;
                        }
                        builder.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                        continue block6;
                    }
                    case UV: {
                        if (this.format.func_177348_c(e).func_177369_e() < v.getTexCoords().length) {
                            builder.put(e, sprite.func_94214_a((double)(v.getTexCoords()[0].x * 16.0f)), sprite.func_94207_b((double)(v.getTexCoords()[0].y * 16.0f)), 0.0f, 1.0f);
                            continue block6;
                        }
                        builder.put(e, 0.0f, 0.0f, 0.0f, 1.0f);
                        continue block6;
                    }
                    case NORMAL: {
                        if (v.getNormal() != null) {
                            builder.put(e, v.getNormal().x, v.getNormal().y, v.getNormal().z, 0.0f);
                            continue block6;
                        }
                        builder.put(e, faceNormal.x, faceNormal.y, faceNormal.z, 0.0f);
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean func_177555_b() {
            return this.smooth;
        }

        public boolean func_177556_c() {
            return this.gui3d;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return (TextureAtlasSprite)this.textures.values().asList().get(0);
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.state, cameraTransformType);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }

    private static final class ModelWrapper
    implements IUnbakedModel {
        private final ResourceLocation modelLocation;
        private final B3DModel model;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, String> textures;
        private final boolean smooth;
        private final boolean gui3d;
        private final int defaultKey;

        public ModelWrapper(ResourceLocation modelLocation, B3DModel model, ImmutableSet<String> meshes, boolean smooth, boolean gui3d, int defaultKey) {
            this(modelLocation, model, meshes, smooth, gui3d, defaultKey, ModelWrapper.buildTextures(model.getTextures()));
        }

        public ModelWrapper(ResourceLocation modelLocation, B3DModel model, ImmutableSet<String> meshes, boolean smooth, boolean gui3d, int defaultKey, ImmutableMap<String, String> textures) {
            this.modelLocation = modelLocation;
            this.model = model;
            this.meshes = meshes;
            this.textures = textures;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.defaultKey = defaultKey;
        }

        private static ImmutableMap<String, String> buildTextures(List<B3DModel.Texture> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (B3DModel.Texture t : textures) {
                String path = t.getPath();
                String location = ModelWrapper.getLocation(path);
                if (!location.startsWith("#")) {
                    location = "#" + location;
                }
                builder.put((Object)path, (Object)location);
            }
            return builder.build();
        }

        private static String getLocation(String path) {
            if (path.endsWith(".png")) {
                path = path.substring(0, path.length() - ".png".length());
            }
            return path;
        }

        public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            return this.textures.values().stream().filter(loc -> !loc.startsWith("#")).map(ResourceLocation::new).collect(Collectors.toList());
        }

        public Collection<ResourceLocation> func_187965_e() {
            return Collections.emptyList();
        }

        @Nullable
        public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            TextureAtlasSprite missing = spriteGetter.apply(new ResourceLocation("missingno"));
            for (Map.Entry e : this.textures.entrySet()) {
                if (((String)e.getValue()).startsWith("#")) {
                    LOGGER.fatal("unresolved texture '{}' for b3d model '{}'", e.getValue(), (Object)this.modelLocation);
                    builder.put(e.getKey(), (Object)missing);
                    continue;
                }
                builder.put(e.getKey(), (Object)spriteGetter.apply(new ResourceLocation((String)e.getValue())));
            }
            builder.put((Object)"missingno", (Object)missing);
            return new BakedWrapper(this.model.getRoot(), sprite.getState(), this.smooth, this.gui3d, format, this.meshes, (ImmutableMap<String, TextureAtlasSprite>)builder.build());
        }

        public ModelWrapper retexture(ImmutableMap<String, String> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry e : this.textures.entrySet()) {
                String path = (String)e.getKey();
                String loc = ModelWrapper.getLocation(path);
                if (loc.startsWith("#") && (textures.containsKey((Object)loc) || textures.containsKey((Object)loc.substring(1)))) {
                    String alt = loc.substring(1);
                    String newLoc = (String)textures.get((Object)loc);
                    if (newLoc == null) {
                        newLoc = (String)textures.get((Object)alt);
                    }
                    if (newLoc == null) {
                        newLoc = path.substring(1);
                    }
                    builder.put(e.getKey(), (Object)newLoc);
                    continue;
                }
                builder.put(e);
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.smooth, this.gui3d, this.defaultKey, (ImmutableMap<String, String>)builder.build());
        }

        public ModelWrapper process(ImmutableMap<String, String> data) {
            JsonElement e;
            ImmutableSet newMeshes = this.meshes;
            int newDefaultKey = this.defaultKey;
            boolean hasChanged = false;
            if (data.containsKey((Object)"mesh")) {
                e = new JsonParser().parse((String)data.get((Object)"mesh"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
                    return new ModelWrapper(this.modelLocation, this.model, (ImmutableSet<String>)ImmutableSet.of((Object)e.getAsString()), this.smooth, this.gui3d, this.defaultKey, this.textures);
                }
                if (e.isJsonArray()) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (JsonElement s : e.getAsJsonArray()) {
                        if (s.isJsonPrimitive() && s.getAsJsonPrimitive().isString()) {
                            builder.add((Object)s.getAsString());
                            continue;
                        }
                        LOGGER.fatal("unknown mesh definition '{}' in array for b3d model '{}'", (Object)s.toString(), (Object)this.modelLocation);
                        return this;
                    }
                    newMeshes = builder.build();
                    hasChanged = true;
                } else {
                    LOGGER.fatal("unknown mesh definition '{}' for b3d model '{}'", (Object)e.toString(), (Object)this.modelLocation);
                    return this;
                }
            }
            if (data.containsKey((Object)"key")) {
                e = new JsonParser().parse((String)data.get((Object)"key"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                    newDefaultKey = e.getAsNumber().intValue();
                    hasChanged = true;
                } else {
                    LOGGER.fatal("unknown keyframe definition '{}' for b3d model '{}'", (Object)e.toString(), (Object)this.modelLocation);
                    return this;
                }
            }
            return hasChanged ? new ModelWrapper(this.modelLocation, this.model, newMeshes, this.smooth, this.gui3d, newDefaultKey, this.textures) : this;
        }

        public Optional<IClip> getClip(String name) {
            if (name.equals("main")) {
                return Optional.of(B3DClip.INSTANCE);
            }
            return Optional.empty();
        }

        public IModelState getDefaultState() {
            return new B3DState(this.model.getRoot().getAnimation(), this.defaultKey, this.defaultKey, 0.0f);
        }

        public ModelWrapper smoothLighting(boolean value) {
            if (value == this.smooth) {
                return this;
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, value, this.gui3d, this.defaultKey, this.textures);
        }

        public ModelWrapper gui3d(boolean value) {
            if (value == this.gui3d) {
                return this;
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.smooth, value, this.defaultKey, this.textures);
        }
    }

    static final class NodeJoint
    implements IJoint {
        private final B3DModel.Node<?> node;

        public NodeJoint(B3DModel.Node<?> node) {
            this.node = node;
        }

        @Override
        public TRSRTransformation getInvBindPose() {
            Matrix4f m = new TRSRTransformation(this.node.getPos(), this.node.getRot(), this.node.getScale(), null).getMatrixVec();
            m.invert();
            TRSRTransformation pose = new TRSRTransformation(m);
            if (this.node.getParent() != null) {
                TRSRTransformation parent = new NodeJoint(this.node.getParent()).getInvBindPose();
                pose = pose.compose(parent);
            }
            return pose;
        }

        public Optional<NodeJoint> getParent() {
            if (this.node.getParent() == null) {
                return Optional.empty();
            }
            return Optional.of(new NodeJoint(this.node.getParent()));
        }

        public B3DModel.Node<?> getNode() {
            return this.node;
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeJoint other = (NodeJoint)obj;
            return Objects.equal(this.node, other.node);
        }
    }

    public static final class B3DState
    implements IModelState {
        @Nullable
        private final B3DModel.Animation animation;
        private final int frame;
        private final int nextFrame;
        private final float progress;
        @Nullable
        private final IModelState parent;
        private static LoadingCache<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, TRSRTransformation> cache = CacheBuilder.newBuilder().maximumSize(16384L).expireAfterAccess(2L, TimeUnit.MINUTES).build(new CacheLoader<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, TRSRTransformation>(){

            public TRSRTransformation load(Triple<B3DModel.Animation, B3DModel.Node<?>, Integer> key) throws Exception {
                return B3DState.getNodeMatrix((B3DModel.Animation)key.getLeft(), (B3DModel.Node)key.getMiddle(), (Integer)key.getRight());
            }
        });

        public B3DState(@Nullable B3DModel.Animation animation, int frame) {
            this(animation, frame, frame, 0.0f);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, IModelState parent) {
            this(animation, frame, frame, 0.0f, parent);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, int nextFrame, float progress) {
            this(animation, frame, nextFrame, progress, null);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, int nextFrame, float progress, @Nullable IModelState parent) {
            this.animation = animation;
            this.frame = frame;
            this.nextFrame = nextFrame;
            this.progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
            this.parent = this.getParent(parent);
        }

        @Nullable
        private IModelState getParent(@Nullable IModelState parent) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof B3DState) {
                return ((B3DState)parent).parent;
            }
            return parent;
        }

        @Nullable
        public B3DModel.Animation getAnimation() {
            return this.animation;
        }

        public int getFrame() {
            return this.frame;
        }

        public int getNextFrame() {
            return this.nextFrame;
        }

        public float getProgress() {
            return this.progress;
        }

        @Nullable
        public IModelState getParent() {
            return this.parent;
        }

        @Override
        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            TRSRTransformation nodeTransform;
            if (!part.isPresent()) {
                if (this.parent != null) {
                    return this.parent.apply(part);
                }
                return Optional.empty();
            }
            if (!(part.get() instanceof NodeJoint)) {
                return Optional.empty();
            }
            B3DModel.Node<?> node = ((NodeJoint)part.get()).getNode();
            if ((double)this.progress < 1.0E-5 || this.frame == this.nextFrame) {
                nodeTransform = this.getNodeMatrix(node, this.frame);
            } else if ((double)this.progress > 0.99999) {
                nodeTransform = this.getNodeMatrix(node, this.nextFrame);
            } else {
                nodeTransform = this.getNodeMatrix(node, this.frame);
                nodeTransform = nodeTransform.slerp(this.getNodeMatrix(node, this.nextFrame), this.progress);
            }
            if (this.parent != null && node.getParent() == null) {
                return Optional.of(this.parent.apply(part).orElse(TRSRTransformation.identity()).compose(nodeTransform));
            }
            return Optional.of(nodeTransform);
        }

        public TRSRTransformation getNodeMatrix(B3DModel.Node<?> node) {
            return this.getNodeMatrix(node, this.frame);
        }

        public TRSRTransformation getNodeMatrix(B3DModel.Node<?> node, int frame) {
            return (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)this.animation, node, (Object)frame));
        }

        public static TRSRTransformation getNodeMatrix(@Nullable B3DModel.Animation animation, B3DModel.Node<?> node, int frame) {
            TRSRTransformation ret = TRSRTransformation.identity();
            B3DModel.Key key = null;
            if (animation != null) {
                key = (B3DModel.Key)animation.getKeys().get((Object)frame, node);
            } else if (node.getAnimation() != null) {
                key = (B3DModel.Key)node.getAnimation().getKeys().get((Object)frame, node);
            }
            if (key != null) {
                B3DModel.Node<B3DModel.IKind<?>> parent = node.getParent();
                if (parent != null) {
                    TRSRTransformation pm = (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)animation, node.getParent(), (Object)frame));
                    ret = ret.compose(pm);
                    ret = ret.compose(new TRSRTransformation(parent.getPos(), parent.getRot(), parent.getScale(), null));
                }
                ret = ret.compose(new TRSRTransformation(key.getPos(), key.getRot(), key.getScale(), null));
                TRSRTransformation invBind = new NodeJoint(node).getInvBindPose();
                ret = ret.compose(invBind);
            } else {
                B3DModel.Node<B3DModel.IKind<?>> parent = node.getParent();
                if (parent != null) {
                    TRSRTransformation pm = (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)animation, node.getParent(), (Object)frame));
                    ret = ret.compose(pm);
                    ret = ret.compose(new TRSRTransformation(parent.getPos(), parent.getRot(), parent.getScale(), null));
                }
                ret = ret.compose(new TRSRTransformation(node.getPos(), node.getRot(), node.getScale(), null));
                TRSRTransformation invBind = new NodeJoint(node).getInvBindPose();
                ret = ret.compose(invBind);
            }
            return ret;
        }
    }
}

