/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class UnpackedBakedQuad
extends BakedQuad {
    protected final float[][][] unpackedData;
    protected final VertexFormat format;
    protected boolean packed = false;

    public UnpackedBakedQuad(float[][][] unpackedData, int tint, Direction orientation, TextureAtlasSprite texture, boolean applyDiffuseLighting, VertexFormat format) {
        super(new int[format.func_177338_f()], tint, orientation, texture, applyDiffuseLighting, format);
        this.unpackedData = unpackedData;
        this.format = format;
    }

    public int[] func_178209_a() {
        if (!this.packed) {
            this.packed = true;
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < this.format.func_177345_h(); ++e) {
                    LightUtil.pack(this.unpackedData[v][e], this.field_178215_a, this.format, v, e);
                }
            }
        }
        return this.field_178215_a;
    }

    public void pipe(IVertexConsumer consumer) {
        int[] eMap = LightUtil.mapFormats(consumer.getVertexFormat(), this.format);
        if (this.func_178212_b()) {
            consumer.setQuadTint(this.func_178211_c());
        }
        consumer.setTexture(this.field_187509_d);
        consumer.setApplyDiffuseLighting(this.applyDiffuseLighting);
        consumer.setQuadOrientation(this.func_178210_d());
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < consumer.getVertexFormat().func_177345_h(); ++e) {
                if (eMap[e] != this.format.func_177345_h()) {
                    consumer.put(e, this.unpackedData[v][eMap[e]]);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static class Builder
    implements IVertexConsumer {
        private final VertexFormat format;
        private final float[][][] unpackedData;
        private int tint = -1;
        private Direction orientation;
        private TextureAtlasSprite texture;
        private boolean applyDiffuseLighting = true;
        private int vertices = 0;
        private int elements = 0;
        private boolean full = false;
        private boolean contractUVs = false;
        private final float eps = 0.00390625f;

        public Builder(VertexFormat format) {
            this.format = format;
            this.unpackedData = new float[4][format.func_177345_h()][4];
        }

        @Override
        public VertexFormat getVertexFormat() {
            return this.format;
        }

        public void setContractUVs(boolean value) {
            this.contractUVs = value;
        }

        @Override
        public void setQuadTint(int tint) {
            this.tint = tint;
        }

        @Override
        public void setQuadOrientation(Direction orientation) {
            this.orientation = orientation;
        }

        @Override
        public void setTexture(TextureAtlasSprite texture) {
            this.texture = texture;
        }

        @Override
        public void setApplyDiffuseLighting(boolean diffuse) {
            this.applyDiffuseLighting = diffuse;
        }

        @Override
        public void put(int element, float ... data) {
            for (int i = 0; i < 4; ++i) {
                this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
            }
            ++this.elements;
            if (this.elements == this.format.func_177345_h()) {
                ++this.vertices;
                this.elements = 0;
            }
            if (this.vertices == 4) {
                this.full = true;
            }
        }

        public UnpackedBakedQuad build() {
            if (!this.full) {
                throw new IllegalStateException("not enough data");
            }
            if (this.texture == null) {
                throw new IllegalStateException("texture not set");
            }
            if (this.contractUVs) {
                int i;
                int v;
                VertexFormatElement e;
                int uve;
                float tY;
                float tX = (float)this.texture.func_94211_a() / (this.texture.func_94212_f() - this.texture.func_94209_e());
                float tS = tX > (tY = (float)this.texture.func_94216_b() / (this.texture.func_94210_h() - this.texture.func_94206_g())) ? tX : tY;
                float ep = 1.0f / (tS * 256.0f);
                for (uve = 0; uve < this.format.func_177345_h() && ((e = this.format.func_177348_c(uve)).func_177375_c() != VertexFormatElement.Usage.UV || e.func_177369_e() != 0); ++uve) {
                }
                if (uve == this.format.func_177345_h()) {
                    throw new IllegalStateException("Can't contract UVs: format doesn't contain UVs");
                }
                float[] uvc = new float[4];
                for (v = 0; v < 4; ++v) {
                    for (i = 0; i < 4; ++i) {
                        int n = i;
                        uvc[n] = uvc[n] + this.unpackedData[v][uve][i] / 4.0f;
                    }
                }
                for (v = 0; v < 4; ++v) {
                    for (i = 0; i < 4; ++i) {
                        float uo = this.unpackedData[v][uve][i];
                        float un = uo * 0.99609375f + uvc[i] * 0.00390625f;
                        float ud = uo - un;
                        float aud = ud;
                        if (aud < 0.0f) {
                            aud = -aud;
                        }
                        if (aud < ep) {
                            float udc = uo - uvc[i];
                            if (udc < 0.0f) {
                                udc = -udc;
                            }
                            un = udc < 2.0f * ep ? (uo + uvc[i]) / 2.0f : uo + (ud < 0.0f ? ep : -ep);
                        }
                        this.unpackedData[v][uve][i] = un;
                    }
                }
            }
            return new UnpackedBakedQuad(this.unpackedData, this.tint, this.orientation, this.texture, this.applyDiffuseLighting, this.format);
        }
    }
}

