/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class VillagerTradingManager {
    private static final Map<VillagerProfession, Int2ObjectMap<VillagerTrades.ITrade[]>> VANILLA_TRADES = new HashMap<VillagerProfession, Int2ObjectMap<VillagerTrades.ITrade[]>>();
    private static final Int2ObjectMap<VillagerTrades.ITrade[]> WANDERER_TRADES = new Int2ObjectOpenHashMap();

    static void loadTrades(FMLServerAboutToStartEvent e) {
        VillagerTradingManager.postWandererEvent();
        VillagerTradingManager.postVillagerEvents();
    }

    private static void postWandererEvent() {
        NonNullList generic = NonNullList.func_191196_a();
        NonNullList rare = NonNullList.func_191196_a();
        Arrays.stream((Object[])WANDERER_TRADES.get(1)).forEach(((List)generic)::add);
        Arrays.stream((Object[])WANDERER_TRADES.get(2)).forEach(((List)rare)::add);
        MinecraftForge.EVENT_BUS.post((Event)new WandererTradesEvent((List<VillagerTrades.ITrade>)generic, (List<VillagerTrades.ITrade>)rare));
        VillagerTrades.field_221240_b.put(1, (Object)generic.toArray(new VillagerTrades.ITrade[0]));
        VillagerTrades.field_221240_b.put(2, (Object)rare.toArray(new VillagerTrades.ITrade[0]));
    }

    private static void postVillagerEvents() {
        for (VillagerProfession prof : ForgeRegistries.PROFESSIONS) {
            Int2ObjectMap<VillagerTrades.ITrade[]> trades = VANILLA_TRADES.getOrDefault(prof, (Int2ObjectMap<VillagerTrades.ITrade[]>)new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap mutableTrades = new Int2ObjectOpenHashMap();
            for (int i = 1; i < 6; ++i) {
                mutableTrades.put(i, (Object)NonNullList.func_191196_a());
            }
            trades.int2ObjectEntrySet().forEach(arg_0 -> VillagerTradingManager.lambda$postVillagerEvents$3((Int2ObjectMap)mutableTrades, arg_0));
            MinecraftForge.EVENT_BUS.post((Event)new VillagerTradesEvent((Int2ObjectMap<List<VillagerTrades.ITrade>>)mutableTrades, prof));
            Int2ObjectOpenHashMap newTrades = new Int2ObjectOpenHashMap();
            mutableTrades.int2ObjectEntrySet().forEach(arg_0 -> VillagerTradingManager.lambda$postVillagerEvents$4((Int2ObjectMap)newTrades, arg_0));
            VillagerTrades.field_221239_a.put(prof, newTrades);
        }
    }

    private static /* synthetic */ void lambda$postVillagerEvents$4(Int2ObjectMap newTrades, Int2ObjectMap.Entry e) {
        VillagerTrades.ITrade[] cfr_ignored_0 = (VillagerTrades.ITrade[])newTrades.put(e.getIntKey(), (Object)((List)e.getValue()).toArray(new VillagerTrades.ITrade[0]));
    }

    private static /* synthetic */ void lambda$postVillagerEvents$3(Int2ObjectMap mutableTrades, Int2ObjectMap.Entry e) {
        Arrays.stream((Object[])e.getValue()).forEach(((List)mutableTrades.get(e.getIntKey()))::add);
    }

    private static /* synthetic */ void lambda$null$0(Int2ObjectMap copy, Int2ObjectMap.Entry ent) {
        VillagerTrades.ITrade[] cfr_ignored_0 = (VillagerTrades.ITrade[])copy.put(ent.getIntKey(), (Object)Arrays.copyOf((Object[])ent.getValue(), ((VillagerTrades.ITrade[])ent.getValue()).length));
    }

    static {
        VillagerTrades.field_221239_a.entrySet().forEach(e -> {
            Int2ObjectOpenHashMap copy = new Int2ObjectOpenHashMap();
            ((Int2ObjectMap)e.getValue()).int2ObjectEntrySet().forEach(arg_0 -> VillagerTradingManager.lambda$null$0((Int2ObjectMap)copy, arg_0));
            VANILLA_TRADES.put((VillagerProfession)e.getKey(), (Int2ObjectMap<VillagerTrades.ITrade[]>)copy);
        });
        VillagerTrades.field_221240_b.int2ObjectEntrySet().forEach(e -> {
            VillagerTrades.ITrade[] cfr_ignored_0 = (VillagerTrades.ITrade[])WANDERER_TRADES.put(e.getIntKey(), (Object)Arrays.copyOf((Object[])e.getValue(), ((VillagerTrades.ITrade[])e.getValue()).length));
        });
    }
}

