/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.dimension.NetherDimension;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public interface IForgeDimension {
    default public Dimension getDimension() {
        return (Dimension)this;
    }

    public World getWorld();

    default public ICapabilityProvider initCapabilities() {
        return null;
    }

    default public double getMovementFactor() {
        if (this.getDimension() instanceof NetherDimension) {
            return 8.0;
        }
        return 1.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public IRenderHandler getSkyRenderer();

    @OnlyIn(value=Dist.CLIENT)
    public void setSkyRenderer(IRenderHandler var1);

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public IRenderHandler getCloudRenderer();

    @OnlyIn(value=Dist.CLIENT)
    public void setCloudRenderer(IRenderHandler var1);

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public IRenderHandler getWeatherRenderer();

    @OnlyIn(value=Dist.CLIENT)
    public void setWeatherRenderer(IRenderHandler var1);

    default public void getLightmapColors(float partialTicks, float sunBrightness, float skyLight, float blockLight, float[] colors) {
    }

    public void resetRainAndThunder();

    default public boolean canDoLightning(Chunk chunk) {
        return true;
    }

    default public boolean canDoRainSnowIce(Chunk chunk) {
        return true;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    default public MusicTicker.MusicType getMusicType() {
        return null;
    }

    default public SleepResult canSleepAt(PlayerEntity player, BlockPos pos) {
        return this.getDimension().func_76567_e() && this.getWorld().func_180494_b(pos) != Biomes.field_76778_j ? SleepResult.ALLOW : SleepResult.BED_EXPLODES;
    }

    default public Biome getBiome(BlockPos pos) {
        return this.getWorld().getBiomeBody(pos);
    }

    default public boolean isDaytime() {
        return this.getWorld().func_175657_ab() < 4;
    }

    default public float getSunBrightness(float partialTicks) {
        return this.getWorld().getSunBrightnessBody(partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public Vec3d getSkyColor(BlockPos cameraPos, float partialTicks) {
        return this.getWorld().getSkyColorBody(cameraPos, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public Vec3d getCloudColor(float partialTicks) {
        return this.getWorld().getCloudColorBody(partialTicks);
    }

    default public float getCurrentMoonPhaseFactor(long time) {
        return Dimension.field_111203_a[this.getDimension().func_76559_b(time)];
    }

    @OnlyIn(value=Dist.CLIENT)
    default public float getStarBrightness(float partialTicks) {
        return this.getWorld().getStarBrightnessBody(partialTicks);
    }

    default public void setAllowedSpawnTypes(boolean allowHostile, boolean allowPeaceful) {
    }

    default public void calculateInitialWeather() {
        this.getWorld().calculateInitialWeatherBody();
    }

    default public void updateWeather(Runnable defaultLogic) {
        defaultLogic.run();
    }

    default public long getSeed() {
        return this.getWorld().func_72912_H().func_76063_b();
    }

    default public long getWorldTime() {
        return this.getWorld().func_72912_H().func_76073_f();
    }

    default public void setWorldTime(long time) {
        this.getWorld().func_72912_H().func_76068_b(time);
    }

    default public BlockPos getSpawnPoint() {
        WorldInfo info = this.getWorld().func_72912_H();
        return new BlockPos(info.func_76079_c(), info.func_76075_d(), info.func_76074_e());
    }

    default public void setSpawnPoint(BlockPos pos) {
        this.getWorld().func_72912_H().func_176143_a(pos);
    }

    default public boolean canMineBlock(PlayerEntity player, BlockPos pos) {
        return this.getWorld().canMineBlockBody(player, pos);
    }

    default public boolean isHighHumidity(BlockPos pos) {
        return this.getWorld().func_180494_b(pos).func_76736_e();
    }

    default public int getHeight() {
        return 256;
    }

    default public int getActualHeight() {
        return this.getDimension().func_177495_o() ? 128 : 256;
    }

    default public double getHorizon() {
        return this.getWorld().func_72912_H().func_76067_t().getHorizon(this.getWorld());
    }

    default public int getSeaLevel() {
        return 63;
    }

    default public boolean shouldMapSpin(String entity, double x, double z, double rotation) {
        return this.getDimension().func_186058_p() == DimensionType.field_223228_b_;
    }

    default public DimensionType getRespawnDimension(ServerPlayerEntity player) {
        return player.getSpawnDimension();
    }

    public static enum SleepResult {
        ALLOW,
        DENY,
        BED_EXPLODES;

    }
}

