/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class WorldPersistenceHooks {
    private static List<WorldPersistenceHook> worldPersistenceHooks = new ArrayList<WorldPersistenceHook>();

    public static void addHook(WorldPersistenceHook hook) {
        worldPersistenceHooks.add(hook);
    }

    public static void handleWorldDataSave(SaveHandler handler, WorldInfo worldInfo, CompoundNBT tagCompound) {
        worldPersistenceHooks.forEach(wac -> tagCompound.func_218657_a(wac.getModId(), (INBT)wac.getDataForWriting(handler, worldInfo)));
    }

    public static void handleWorldDataLoad(SaveHandler handler, WorldInfo worldInfo, CompoundNBT tagCompound) {
        if (EffectiveSide.get() == LogicalSide.SERVER) {
            worldPersistenceHooks.forEach(wac -> wac.readData(handler, worldInfo, tagCompound.func_74775_l(wac.getModId())));
        }
    }

    public static void confirmBackupLevelDatUse(SaveHandler handler) {
    }

    public static interface WorldPersistenceHook {
        public String getModId();

        public CompoundNBT getDataForWriting(SaveHandler var1, WorldInfo var2);

        public void readData(SaveHandler var1, WorldInfo var2, CompoundNBT var3);
    }
}

