/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui;

import com.google.common.base.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ErrorScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.client.ClientHooks;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadingErrorScreen
extends ErrorScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path modsDir;
    private final Path logFile;
    private final List<ModLoadingException> modLoadErrors;
    private final List<ModLoadingWarning> modLoadWarnings;
    private LoadingEntryList entryList;
    private String errorHeader;
    private String warningHeader;

    public LoadingErrorScreen(LoadingFailedException loadingException, List<ModLoadingWarning> warnings) {
        super((ITextComponent)new StringTextComponent("Loading Error"), null);
        this.modLoadWarnings = warnings;
        this.modLoadErrors = loadingException == null ? Collections.emptyList() : loadingException.getErrors();
        this.modsDir = FMLPaths.MODSDIR.get();
        this.logFile = FMLPaths.GAMEDIR.get().resolve(Paths.get("logs", "latest.log"));
    }

    public void init() {
        super.init();
        this.buttons.clear();
        this.children.clear();
        this.errorHeader = TextFormatting.RED + ForgeI18n.parseMessage("fml.loadingerrorscreen.errorheader", this.modLoadErrors.size()) + TextFormatting.RESET;
        this.warningHeader = TextFormatting.YELLOW + ForgeI18n.parseMessage("fml.loadingerrorscreen.warningheader", this.modLoadErrors.size()) + TextFormatting.RESET;
        int yOffset = this.modLoadErrors.isEmpty() ? 46 : 38;
        this.addButton((Widget)new GuiButtonExt(50, this.height - yOffset, this.width / 2 - 55, 20, ForgeI18n.parseMessage("fml.button.open.mods.folder", new Object[0]), b -> Util.func_110647_a().func_195641_a(this.modsDir.toFile())));
        this.addButton((Widget)new GuiButtonExt(this.width / 2 + 5, this.height - yOffset, this.width / 2 - 55, 20, ForgeI18n.parseMessage("fml.button.open.file", this.logFile.getFileName()), b -> Util.func_110647_a().func_195641_a(this.logFile.toFile())));
        if (this.modLoadErrors.isEmpty()) {
            this.addButton((Widget)new GuiButtonExt(this.width / 4, this.height - 24, this.width / 2, 20, ForgeI18n.parseMessage("fml.button.continue.launch", new Object[0]), b -> {
                ClientHooks.logMissingTextureErrors();
                this.minecraft.func_147108_a(null);
            }));
        }
        this.entryList = new LoadingEntryList(this, this.modLoadErrors, this.modLoadWarnings);
        this.children.add(this.entryList);
        this.setFocused((IGuiEventListener)this.entryList);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.entryList.render(mouseX, mouseY, partialTicks);
        this.drawMultiLineCenteredString(this.font, this.modLoadErrors.isEmpty() ? this.warningHeader : this.errorHeader, this.width / 2, 10);
        this.buttons.forEach(button -> button.render(mouseX, mouseY, partialTicks));
    }

    private void drawMultiLineCenteredString(FontRenderer fr, String str, int x, int y) {
        for (String s : fr.func_78271_c(str, this.width)) {
            fr.func_175063_a(s, (float)((double)x - (double)fr.func_78256_a(s) / 2.0), (float)y, 0xFFFFFF);
            fr.getClass();
            y += 9;
        }
    }

    public static class LoadingEntryList
    extends ExtendedList<LoadingMessageEntry> {
        LoadingEntryList(LoadingErrorScreen parent, List<ModLoadingException> errors, List<ModLoadingWarning> warnings) {
            boolean both;
            Minecraft minecraft = parent.minecraft;
            int n = parent.width;
            int n2 = parent.height;
            int n3 = parent.height - 50;
            ((LoadingErrorScreen)parent).minecraft.field_71466_p.getClass();
            super(minecraft, n, n2, 35, n3, 2 * 9 + 8);
            boolean bl = both = !errors.isEmpty() && !warnings.isEmpty();
            if (both) {
                this.addEntry((AbstractList.AbstractListEntry)new LoadingMessageEntry(parent.errorHeader, true));
            }
            errors.forEach(e -> this.addEntry((AbstractList.AbstractListEntry)new LoadingMessageEntry(e.formatToString())));
            if (both) {
                int maxChars = (this.width - 10) / ((LoadingErrorScreen)parent).minecraft.field_71466_p.func_78256_a("-");
                this.addEntry((AbstractList.AbstractListEntry)new LoadingMessageEntry("\n" + Strings.repeat((String)"-", (int)maxChars) + "\n"));
                this.addEntry((AbstractList.AbstractListEntry)new LoadingMessageEntry(parent.warningHeader, true));
            }
            warnings.forEach(w -> this.addEntry((AbstractList.AbstractListEntry)new LoadingMessageEntry(w.formatToString())));
        }

        protected int getScrollbarPosition() {
            return this.getRight() - 6;
        }

        public int getRowWidth() {
            return this.width;
        }

        public class LoadingMessageEntry
        extends ExtendedList.AbstractListEntry<LoadingMessageEntry> {
            private final String message;
            private final boolean center;

            LoadingMessageEntry(String message) {
                this(message, false);
            }

            LoadingMessageEntry(String message, boolean center) {
                this.message = Objects.requireNonNull(message);
                this.center = center;
            }

            public void render(int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                List strings = font.func_78271_c(this.message, LoadingEntryList.this.width);
                int y = top + 2;
                for (int i = 0; i < Math.min(strings.size(), 2); ++i) {
                    if (this.center) {
                        font.func_211126_b((String)strings.get(i), (float)left + (float)LoadingEntryList.this.width / 2.0f - (float)font.func_78256_a((String)strings.get(i)) / 2.0f, (float)y, 0xFFFFFF);
                    } else {
                        font.func_211126_b((String)strings.get(i), (float)(left + 5), (float)y, 0xFFFFFF);
                    }
                    font.getClass();
                    y += 9;
                }
            }
        }
    }
}

