/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.packs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackFileNotFoundException;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.packs.DelegatableResourcePack;

public class DelegatingResourcePack
extends ResourcePack {
    private final List<DelegatableResourcePack> delegates = new ArrayList<DelegatableResourcePack>();
    private final String name;
    private final PackMetadataSection packInfo;

    public DelegatingResourcePack(String id, String name, PackMetadataSection packInfo) {
        this(id, name, packInfo, Collections.emptyList());
    }

    public DelegatingResourcePack(String id, String name, PackMetadataSection packInfo, List<DelegatableResourcePack> packs) {
        super(new File(id));
        this.name = name;
        this.packInfo = packInfo;
        packs.forEach(this::addDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelegate(DelegatableResourcePack pack) {
        List<DelegatableResourcePack> list = this.delegates;
        synchronized (list) {
            this.delegates.add(pack);
        }
    }

    public String func_195762_a() {
        return this.name;
    }

    public <T> T func_195760_a(IMetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer.func_110483_a().equals("pack")) {
            return (T)this.packInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ResourceLocation> func_195758_a(ResourcePackType type, String pathIn, int maxDepth, Predicate<String> filter) {
        List<DelegatableResourcePack> list = this.delegates;
        synchronized (list) {
            return this.delegates.stream().flatMap(r -> r.func_195758_a(type, pathIn, maxDepth, filter).stream()).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> func_195759_a(ResourcePackType type) {
        List<DelegatableResourcePack> list = this.delegates;
        synchronized (list) {
            return this.delegates.stream().flatMap(r -> r.func_195759_a(type).stream()).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        List<DelegatableResourcePack> list = this.delegates;
        synchronized (list) {
            for (ResourcePack resourcePack : this.delegates) {
                resourcePack.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream func_195766_a(String resourcePath) throws IOException {
        if (!resourcePath.equals("pack.png")) {
            List<DelegatableResourcePack> list = this.delegates;
            synchronized (list) {
                for (DelegatableResourcePack pack : this.delegates) {
                    if (!pack.func_195768_c(resourcePath)) continue;
                    return pack.func_195766_a(resourcePath);
                }
            }
        }
        throw new ResourcePackFileNotFoundException(this.field_195771_a, resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean func_195768_c(String resourcePath) {
        List<DelegatableResourcePack> list = this.delegates;
        synchronized (list) {
            for (DelegatableResourcePack pack : this.delegates) {
                if (!pack.func_195768_c(resourcePath)) continue;
                return true;
            }
        }
        return false;
    }
}

