/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class NoteBlock
extends Block {
    public static final EnumProperty<NoteBlockInstrument> field_196483_a = BlockStateProperties.field_208143_ar;
    public static final BooleanProperty field_196484_b = BlockStateProperties.field_208194_u;
    public static final IntegerProperty field_196485_c = BlockStateProperties.field_208134_ai;

    public NoteBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_196483_a, (Comparable)NoteBlockInstrument.HARP))).func_206870_a((IProperty)field_196485_c, Integer.valueOf(0)))).func_206870_a((IProperty)field_196484_b, Boolean.valueOf(false))));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_196483_a, (Comparable)NoteBlockInstrument.func_208087_a((BlockState)context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b()))));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN ? (BlockState)((Object)stateIn.func_206870_a((IProperty)field_196483_a, (Comparable)NoteBlockInstrument.func_208087_a((BlockState)facingState))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)field_196484_b)) {
            if (flag) {
                this.func_196482_a(worldIn, pos);
            }
            worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((IProperty)field_196484_b, Boolean.valueOf(flag))), 3);
        }
    }

    private void func_196482_a(World worldIn, BlockPos pos) {
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175641_c(pos, this, 0, 0);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (p_225533_2_.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        int _new = ForgeHooks.onNoteChange((World)p_225533_2_, (BlockPos)p_225533_3_, (BlockState)p_225533_1_, (int)((Integer)p_225533_1_.func_177229_b((IProperty)field_196485_c)), (int)((Integer)((BlockState)((Object)p_225533_1_.func_177231_a((IProperty)field_196485_c))).func_177229_b((IProperty)field_196485_c)));
        if (_new == -1) {
            return ActionResultType.FAIL;
        }
        p_225533_1_ = (BlockState)((Object)p_225533_1_.func_206870_a((IProperty)field_196485_c, Integer.valueOf(_new)));
        p_225533_1_ = (BlockState)((Object)p_225533_1_.func_177231_a((IProperty)field_196485_c));
        p_225533_2_.func_180501_a(p_225533_3_, p_225533_1_, 3);
        this.func_196482_a(p_225533_2_, p_225533_3_);
        p_225533_4_.func_195066_a(Stats.field_188087_U);
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            this.func_196482_a(worldIn, pos);
            player.func_195066_a(Stats.field_188086_T);
        }
    }

    @Override
    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        NoteBlockEvent.Play e = new NoteBlockEvent.Play(worldIn, pos, state, ((Integer)state.func_177229_b((IProperty)field_196485_c)).intValue(), (NoteBlockInstrument)state.func_177229_b((IProperty)field_196483_a));
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        state = (BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_196485_c, Integer.valueOf(e.getVanillaNoteId())))).func_206870_a((IProperty)field_196483_a, (Comparable)e.getInstrument()));
        int i = (Integer)state.func_177229_b((IProperty)field_196485_c);
        float f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
        worldIn.func_184133_a(null, pos, ((NoteBlockInstrument)state.func_177229_b((IProperty)field_196483_a)).func_208088_a(), SoundCategory.RECORDS, 3.0f, f);
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197597_H, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, (double)i / 24.0, 0.0, 0.0);
        return true;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_196483_a, field_196484_b, field_196485_c});
    }
}

