/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class RedstoneDiodeBlock
extends HorizontalBlock {
    protected static final VoxelShape field_196347_b = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    public static final BooleanProperty field_196348_c = BlockStateProperties.field_208194_u;

    protected RedstoneDiodeBlock(Block.Properties builder) {
        super(builder);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return field_196347_b;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return RedstoneDiodeBlock.func_220064_c((IBlockReader)((Object)worldIn), (BlockPos)pos.func_177977_b());
    }

    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        if (!this.func_176405_b(p_225534_2_, p_225534_3_, p_225534_1_)) {
            boolean flag = (Boolean)p_225534_1_.func_177229_b((IProperty)field_196348_c);
            boolean flag1 = this.func_176404_e(p_225534_2_, p_225534_3_, p_225534_1_);
            if (flag && !flag1) {
                p_225534_2_.func_180501_a(p_225534_3_, (BlockState)((Object)p_225534_1_.func_206870_a((IProperty)field_196348_c, Boolean.valueOf(false))), 2);
            } else if (!flag) {
                p_225534_2_.func_180501_a(p_225534_3_, (BlockState)((Object)p_225534_1_.func_206870_a((IProperty)field_196348_c, Boolean.valueOf(true))), 2);
                if (!flag1) {
                    p_225534_2_.func_205220_G_().func_205362_a(p_225534_3_, (Object)this, this.func_196346_i(p_225534_1_), TickPriority.VERY_HIGH);
                }
            }
        }
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.func_177229_b((IProperty)field_196348_c)).booleanValue()) {
            return 0;
        }
        return blockState.func_177229_b((IProperty)field_185512_D) == side ? this.func_176408_a(blockAccess, pos, blockState) : 0;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.func_196955_c(worldIn, pos)) {
            this.func_176398_g(worldIn, pos, state);
        } else {
            TileEntity tileentity = state.hasTileEntity() ? worldIn.func_175625_s(pos) : null;
            RedstoneDiodeBlock.func_220059_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)tileentity);
            worldIn.func_217377_a(pos, false);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)((Object)this));
            }
        }
    }

    protected void func_176398_g(World worldIn, BlockPos pos, BlockState state) {
        boolean flag1;
        boolean flag;
        if (!this.func_176405_b(worldIn, pos, state) && (flag = ((Boolean)state.func_177229_b((IProperty)field_196348_c)).booleanValue()) != (flag1 = this.func_176404_e(worldIn, pos, state)) && !worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            TickPriority tickpriority = TickPriority.HIGH;
            if (this.func_176402_i((IBlockReader)((Object)worldIn), pos, state)) {
                tickpriority = TickPriority.EXTREMELY_HIGH;
            } else if (flag) {
                tickpriority = TickPriority.VERY_HIGH;
            }
            worldIn.func_205220_G_().func_205362_a(pos, (Object)this, this.func_196346_i(state), tickpriority);
        }
    }

    public boolean func_176405_b(IWorldReader worldIn, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean func_176404_e(World worldIn, BlockPos pos, BlockState state) {
        return this.func_176397_f(worldIn, pos, state) > 0;
    }

    protected int func_176397_f(World worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)((Object)state.func_177229_b((IProperty)field_185512_D));
        BlockPos blockpos = pos.func_177972_a(direction);
        int i = worldIn.func_175651_c(blockpos, direction);
        if (i >= 15) {
            return i;
        }
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return Math.max(i, blockstate.func_177230_c() == Blocks.field_150488_af ? (Integer)blockstate.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O) : 0);
    }

    protected int func_176407_c(IWorldReader worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)((Object)state.func_177229_b((IProperty)field_185512_D));
        Direction direction1 = direction.func_176746_e();
        Direction direction2 = direction.func_176735_f();
        return Math.max(this.func_176401_c(worldIn, pos.func_177972_a(direction1), direction1), this.func_176401_c(worldIn, pos.func_177972_a(direction2), direction2));
    }

    protected int func_176401_c(IWorldReader worldIn, BlockPos pos, Direction side) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        if (this.func_185545_A(blockstate)) {
            if (block == Blocks.field_150451_bX) {
                return 15;
            }
            return block == Blocks.field_150488_af ? ((Integer)blockstate.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O)).intValue() : worldIn.func_175627_a(pos, side);
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)((Object)context.func_195992_f().func_176734_d())));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.func_176404_e(worldIn, pos, state)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.func_176400_h(worldIn, pos, state);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            this.func_176400_h(worldIn, pos, state);
        }
    }

    protected void func_176400_h(World worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)((Object)state.func_177229_b((IProperty)field_185512_D));
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        if (ForgeEventFactory.onNeighborNotify((World)worldIn, (BlockPos)pos, (BlockState)worldIn.func_180495_p(pos), EnumSet.of(direction.func_176734_d()), (boolean)false).isCanceled()) {
            return;
        }
        worldIn.func_190524_a(blockpos, (Block)((Object)this), pos);
        worldIn.func_175695_a(blockpos, (Block)((Object)this), direction);
    }

    protected boolean func_185545_A(BlockState state) {
        return state.func_185897_m();
    }

    protected int func_176408_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return 15;
    }

    public static boolean func_185546_B(BlockState state) {
        return state.func_177230_c() instanceof RedstoneDiodeBlock;
    }

    public boolean func_176402_i(IBlockReader worldIn, BlockPos pos, BlockState state) {
        Direction direction = ((Direction)((Object)state.func_177229_b((IProperty)field_185512_D))).func_176734_d();
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        return RedstoneDiodeBlock.func_185546_B(blockstate) && blockstate.func_177229_b((IProperty)field_185512_D) != direction;
    }

    protected abstract int func_196346_i(BlockState var1);
}

