/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockModelDefinition;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.multipart.Multipart;
import net.minecraft.client.renderer.model.multipart.Selector;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.BellTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ConduitTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EnchantmentTableTileEntityRenderer;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelBakery {
    public static final Material field_207763_a = new Material(AtlasTexture.field_110575_b, new ResourceLocation("block/fire_0"));
    public static final Material field_207764_b = new Material(AtlasTexture.field_110575_b, new ResourceLocation("block/fire_1"));
    public static final Material field_207766_d = new Material(AtlasTexture.field_110575_b, new ResourceLocation("block/lava_flow"));
    public static final Material field_207768_f = new Material(AtlasTexture.field_110575_b, new ResourceLocation("block/water_flow"));
    public static final Material field_207769_g = new Material(AtlasTexture.field_110575_b, new ResourceLocation("block/water_overlay"));
    public static final Material field_229315_f_ = new Material(AtlasTexture.field_110575_b, new ResourceLocation("entity/banner_base"));
    public static final Material field_229316_g_ = new Material(AtlasTexture.field_110575_b, new ResourceLocation("entity/shield_base"));
    public static final Material field_229317_h_ = new Material(AtlasTexture.field_110575_b, new ResourceLocation("entity/shield_base_nopattern"));
    public static final List<ResourceLocation> field_229318_i_ = IntStream.range(0, 10).mapToObj(p_229323_0_ -> new ResourceLocation("block/destroy_stage_" + p_229323_0_)).collect(Collectors.toList());
    public static final List<ResourceLocation> field_229319_j_ = field_229318_i_.stream().map(p_229351_0_ -> new ResourceLocation("textures/" + p_229351_0_.func_110623_a() + ".png")).collect(Collectors.toList());
    public static final List<RenderType> field_229320_k_ = field_229319_j_.stream().map(RenderType::func_228656_k_).collect(Collectors.toList());
    protected static final Set<Material> field_177602_b = (Set)Util.func_200696_a((Object)Sets.newHashSet(), p_229337_0_ -> {
        p_229337_0_.add(field_207768_f);
        p_229337_0_.add(field_207766_d);
        p_229337_0_.add(field_207769_g);
        p_229337_0_.add(field_207763_a);
        p_229337_0_.add(field_207764_b);
        p_229337_0_.add(BellTileEntityRenderer.field_217653_c);
        p_229337_0_.add(ConduitTileEntityRenderer.field_205118_a);
        p_229337_0_.add(ConduitTileEntityRenderer.field_205119_d);
        p_229337_0_.add(ConduitTileEntityRenderer.field_205120_e);
        p_229337_0_.add(ConduitTileEntityRenderer.field_205121_f);
        p_229337_0_.add(ConduitTileEntityRenderer.field_207746_g);
        p_229337_0_.add(ConduitTileEntityRenderer.field_207747_h);
        p_229337_0_.add(EnchantmentTableTileEntityRenderer.field_147540_b);
        p_229337_0_.add(field_229315_f_);
        p_229337_0_.add(field_229316_g_);
        p_229337_0_.add(field_229317_h_);
        for (ResourceLocation resourcelocation : field_229318_i_) {
            p_229337_0_.add(new Material(AtlasTexture.field_110575_b, resourcelocation));
        }
        p_229337_0_.add(new Material(AtlasTexture.field_110575_b, PlayerContainer.field_226616_d_));
        p_229337_0_.add(new Material(AtlasTexture.field_110575_b, PlayerContainer.field_226617_e_));
        p_229337_0_.add(new Material(AtlasTexture.field_110575_b, PlayerContainer.field_226618_f_));
        p_229337_0_.add(new Material(AtlasTexture.field_110575_b, PlayerContainer.field_226619_g_));
        p_229337_0_.add(new Material(AtlasTexture.field_110575_b, PlayerContainer.field_226620_h_));
        Atlases.func_228775_a_(p_229337_0_::add);
    });
    private static final Logger field_177603_c = LogManager.getLogger();
    public static final ModelResourceLocation field_177604_a = new ModelResourceLocation("builtin/missing", "missing");
    private static final String field_229321_r_ = field_177604_a.toString();
    @VisibleForTesting
    public static final String field_188641_d = ("{    'textures': {       'particle': '" + MissingTextureSprite.func_195675_b().func_110623_a() + "',       'missingno': '" + MissingTextureSprite.func_195675_b().func_110623_a() + "'    },    'elements': [         {  'from': [ 0, 0, 0 ],            'to': [ 16, 16, 16 ],            'faces': {                'down':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'down',  'texture': '#missingno' },                'up':    { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'up',    'texture': '#missingno' },                'north': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'north', 'texture': '#missingno' },                'south': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'south', 'texture': '#missingno' },                'west':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'west',  'texture': '#missingno' },                'east':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'east',  'texture': '#missingno' }            }        }    ]}").replace('\'', '\"');
    private static final Map<String, String> field_177600_d = Maps.newHashMap((Map)ImmutableMap.of((Object)"missing", (Object)field_188641_d));
    private static final Splitter field_209611_w = Splitter.on((char)',');
    private static final Splitter field_209612_x = Splitter.on((char)'=').limit(2);
    protected static final BlockModel field_177606_o = (BlockModel)Util.func_200696_a((Object)BlockModel.func_178294_a("{}"), p_229347_0_ -> {
        p_229347_0_.field_178317_b = "generation marker";
    });
    protected static final BlockModel field_177616_r = (BlockModel)Util.func_200696_a((Object)BlockModel.func_178294_a("{}"), p_229332_0_ -> {
        p_229332_0_.field_178317_b = "block entity marker";
    });
    private static final StateContainer<Block, BlockState> field_209613_y = new StateContainer.Builder((Object)Blocks.field_150350_a).func_206894_a(new IProperty[]{BooleanProperty.func_177716_a((String)"map")}).func_206893_a(BlockState::new);
    private static final ItemModelGenerator field_217854_z = new ItemModelGenerator();
    private static final Map<ResourceLocation, StateContainer<Block, BlockState>> field_209607_C = ImmutableMap.of((Object)new ResourceLocation("item_frame"), field_209613_y);
    protected final IResourceManager field_177598_f;
    @Nullable
    private SpriteMap field_229322_z_;
    private final BlockColors field_225365_D;
    private final Set<ResourceLocation> field_217848_D = Sets.newHashSet();
    private final BlockModelDefinition.ContainerHolder field_209610_F = new BlockModelDefinition.ContainerHolder();
    private final Map<ResourceLocation, IUnbakedModel> field_217849_F = Maps.newHashMap();
    private final Map<Triple<ResourceLocation, TransformationMatrix, Boolean>, IBakedModel> field_217850_G = Maps.newHashMap();
    private final Map<ResourceLocation, IUnbakedModel> field_217851_H = Maps.newHashMap();
    private final Map<ResourceLocation, IBakedModel> field_217852_I = Maps.newHashMap();
    private Map<ResourceLocation, Pair<AtlasTexture, AtlasTexture.SheetData>> field_217853_J;
    private int field_225366_L = 1;
    private final Object2IntMap<BlockState> field_225367_M = (Object2IntMap)Util.func_200696_a((Object)new Object2IntOpenHashMap(), p_229336_0_ -> p_229336_0_.defaultReturnValue(-1));

    public ModelBakery(IResourceManager p_i226056_1_, BlockColors p_i226056_2_, IProfiler p_i226056_3_, int p_i226056_4_) {
        this(p_i226056_1_, p_i226056_2_, true);
        this.processLoading(p_i226056_3_, p_i226056_4_);
    }

    protected ModelBakery(IResourceManager p_i226056_1_, BlockColors p_i226056_2_, boolean vanillaBakery) {
        this.field_177598_f = p_i226056_1_;
        this.field_225365_D = p_i226056_2_;
    }

    protected void processLoading(IProfiler p_i226056_3_, int p_i226056_4_) {
        p_i226056_3_.func_76320_a("missing_model");
        try {
            this.field_217849_F.put(field_177604_a, this.func_177594_c(field_177604_a));
            this.func_217843_a(field_177604_a);
        }
        catch (IOException ioexception) {
            field_177603_c.error("Error loading missing model, should never happen :(", (Throwable)ioexception);
            throw new RuntimeException(ioexception);
        }
        p_i226056_3_.func_219895_b("static_definitions");
        field_209607_C.forEach((p_229344_1_, p_229344_2_) -> p_229344_2_.func_177619_a().forEach(p_229343_2_ -> this.func_217843_a(BlockModelShapes.func_209553_a(p_229344_1_, p_229343_2_))));
        p_i226056_3_.func_219895_b("blocks");
        for (Block block : Registry.field_212618_g) {
            block.func_176194_O().func_177619_a().forEach(p_229326_1_ -> this.func_217843_a(BlockModelShapes.func_209554_c(p_229326_1_)));
        }
        p_i226056_3_.func_219895_b("items");
        for (ResourceLocation resourcelocation : Registry.field_212630_s.func_148742_b()) {
            this.func_217843_a(new ModelResourceLocation(resourcelocation, "inventory"));
        }
        p_i226056_3_.func_219895_b("special");
        this.func_217843_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory"));
        for (ResourceLocation rl : this.getSpecialModels()) {
            this.addModelToCache(rl);
        }
        p_i226056_3_.func_219895_b("textures");
        LinkedHashSet set = Sets.newLinkedHashSet();
        Set set1 = this.field_217851_H.values().stream().flatMap(p_229342_2_ -> p_229342_2_.func_225614_a_(this::func_209597_a, set).stream()).collect(Collectors.toSet());
        set1.addAll(field_177602_b);
        ForgeHooksClient.gatherFluidTextures(set1);
        set.stream().filter(p_229346_0_ -> !((String)p_229346_0_.getSecond()).equals(field_229321_r_)).forEach(p_229330_0_ -> field_177603_c.warn("Unable to resolve texture reference: {} in {}", p_229330_0_.getFirst(), p_229330_0_.getSecond()));
        Map<ResourceLocation, List<Material>> map = set1.stream().collect(Collectors.groupingBy(Material::func_229310_a_));
        p_i226056_3_.func_219895_b("stitching");
        this.field_217853_J = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, List<Material>> entry : map.entrySet()) {
            AtlasTexture atlastexture = new AtlasTexture(entry.getKey());
            AtlasTexture.SheetData atlastexture$sheetdata = atlastexture.func_229220_a_(this.field_177598_f, entry.getValue().stream().map(Material::func_229313_b_), p_i226056_3_, p_i226056_4_);
            this.field_217853_J.put(entry.getKey(), (Pair<AtlasTexture, AtlasTexture.SheetData>)Pair.of((Object)atlastexture, (Object)atlastexture$sheetdata));
        }
        p_i226056_3_.func_76319_b();
    }

    public SpriteMap func_229333_a_(TextureManager p_229333_1_, IProfiler p_229333_2_) {
        p_229333_2_.func_76320_a("atlas");
        for (Pair<AtlasTexture, AtlasTexture.SheetData> pair : this.field_217853_J.values()) {
            AtlasTexture atlastexture = (AtlasTexture)pair.getFirst();
            AtlasTexture.SheetData atlastexture$sheetdata = (AtlasTexture.SheetData)pair.getSecond();
            atlastexture.func_215260_a(atlastexture$sheetdata);
            p_229333_1_.func_229263_a_(atlastexture.func_229223_g_(), atlastexture);
            p_229333_1_.func_110577_a(atlastexture.func_229223_g_());
            atlastexture.func_229221_b_(atlastexture$sheetdata);
        }
        this.field_229322_z_ = new SpriteMap((Collection)this.field_217853_J.values().stream().map(Pair::getFirst).collect(Collectors.toList()));
        p_229333_2_.func_219895_b("baking");
        this.field_217851_H.keySet().forEach(p_229350_1_ -> {
            IBakedModel ibakedmodel = null;
            try {
                ibakedmodel = this.func_217845_a((ResourceLocation)p_229350_1_, (IModelTransform)ModelRotation.X0_Y0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                field_177603_c.warn("Unable to bake model: '{}': {}", p_229350_1_, (Object)exception);
            }
            if (ibakedmodel != null) {
                this.field_217852_I.put((ResourceLocation)p_229350_1_, ibakedmodel);
            }
        });
        p_229333_2_.func_76319_b();
        return this.field_229322_z_;
    }

    private static Predicate<BlockState> func_209605_a(StateContainer<Block, BlockState> containerIn, String variantIn) {
        HashMap map = Maps.newHashMap();
        for (String s : field_209611_w.split((CharSequence)variantIn)) {
            Iterator iterator = field_209612_x.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String s1 = (String)iterator.next();
            IProperty iproperty = containerIn.func_185920_a(s1);
            if (iproperty != null && iterator.hasNext()) {
                String s2 = (String)iterator.next();
                Object comparable = ModelBakery.func_209592_a(iproperty, s2);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + iproperty.func_177700_c());
                }
                map.put(iproperty, comparable);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        Block block = (Block)((Object)containerIn.func_177622_c());
        return p_229325_2_ -> {
            if (p_229325_2_ != null && block == p_229325_2_.func_177230_c()) {
                for (Map.Entry entry : map.entrySet()) {
                    if (Objects.equals(p_229325_2_.func_177229_b((IProperty)entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    @Nullable
    static <T extends Comparable<T>> T func_209592_a(IProperty<T> property, String value) {
        return (T)property.func_185929_b(value).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUnbakedModel func_209597_a(ResourceLocation modelLocation) {
        if (this.field_217849_F.containsKey(modelLocation)) {
            return this.field_217849_F.get(modelLocation);
        }
        if (this.field_217848_D.contains(modelLocation)) {
            throw new IllegalStateException("Circular reference while loading " + modelLocation);
        }
        this.field_217848_D.add(modelLocation);
        IUnbakedModel iunbakedmodel = this.field_217849_F.get((Object)field_177604_a);
        while (!this.field_217848_D.isEmpty()) {
            ResourceLocation resourcelocation = this.field_217848_D.iterator().next();
            try {
                if (this.field_217849_F.containsKey(resourcelocation)) continue;
                this.func_209598_b(resourcelocation);
            }
            catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                field_177603_c.warn(modelbakery$blockstatedefinitionexception.getMessage());
                this.field_217849_F.put(resourcelocation, iunbakedmodel);
            }
            catch (Exception exception) {
                field_177603_c.warn("Unable to load model: '{}' referenced from: {}: {}", (Object)resourcelocation, (Object)modelLocation, (Object)exception);
                this.field_217849_F.put(resourcelocation, iunbakedmodel);
            }
            finally {
                this.field_217848_D.remove(resourcelocation);
            }
        }
        return this.field_217849_F.getOrDefault(modelLocation, iunbakedmodel);
    }

    private void func_209598_b(ResourceLocation blockstateLocation) throws Exception {
        if (!(blockstateLocation instanceof ModelResourceLocation)) {
            this.func_209593_a(blockstateLocation, this.func_177594_c(blockstateLocation));
        } else {
            ModelResourceLocation modelresourcelocation = (ModelResourceLocation)blockstateLocation;
            if (Objects.equals(modelresourcelocation.func_177518_c(), "inventory")) {
                ResourceLocation resourcelocation2 = new ResourceLocation(blockstateLocation.func_110624_b(), "item/" + blockstateLocation.func_110623_a());
                BlockModel blockmodel = this.func_177594_c(resourcelocation2);
                this.func_209593_a(modelresourcelocation, blockmodel);
                this.field_217849_F.put(resourcelocation2, blockmodel);
            } else {
                ResourceLocation resourcelocation = new ResourceLocation(blockstateLocation.func_110624_b(), blockstateLocation.func_110623_a());
                StateContainer statecontainer = Optional.ofNullable(field_209607_C.get(resourcelocation)).orElseGet(() -> ((Block)((Object)((Object)Registry.field_212618_g.func_82594_a(resourcelocation)))).func_176194_O());
                this.field_209610_F.func_209573_a(statecontainer);
                ImmutableList list = ImmutableList.copyOf(this.field_225365_D.func_225310_a((Block)((Object)statecontainer.func_177622_c())));
                ImmutableList immutablelist = statecontainer.func_177619_a();
                HashMap map = Maps.newHashMap();
                immutablelist.forEach(p_229340_2_ -> {
                    BlockState blockstate = map.put(BlockModelShapes.func_209553_a(resourcelocation, p_229340_2_), p_229340_2_);
                });
                HashMap map1 = Maps.newHashMap();
                ResourceLocation resourcelocation1 = new ResourceLocation(blockstateLocation.func_110624_b(), "blockstates/" + blockstateLocation.func_110623_a() + ".json");
                IUnbakedModel iunbakedmodel = this.field_217849_F.get((Object)field_177604_a);
                ModelListWrapper modelbakery$modellistwrapper = new ModelListWrapper((List<IUnbakedModel>)ImmutableList.of((Object)iunbakedmodel), (List<Object>)ImmutableList.of());
                Pair pair = Pair.of((Object)iunbakedmodel, () -> modelbakery$modellistwrapper);
                try {
                    List lvt_13_5_ = this.field_177598_f.func_199004_b(resourcelocation1).stream().map(p_229345_1_ -> {
                        try (InputStream inputstream = p_229345_1_.func_199027_b();){
                            Pair pair2;
                            Pair pair = pair2 = Pair.of((Object)p_229345_1_.func_199026_d(), (Object)BlockModelDefinition.func_209577_a((BlockModelDefinition.ContainerHolder)this.field_209610_F, (Reader)new InputStreamReader(inputstream, StandardCharsets.UTF_8)));
                            return pair;
                        }
                        catch (Exception exception1) {
                            throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s' in resourcepack: '%s': %s", p_229345_1_.func_199029_a(), p_229345_1_.func_199026_d(), exception1.getMessage()));
                        }
                    }).collect(Collectors.toList());
                    for (Pair pair1 : lvt_13_5_) {
                        Multipart multipart;
                        BlockModelDefinition blockmodeldefinition = (BlockModelDefinition)pair1.getSecond();
                        IdentityHashMap map2 = Maps.newIdentityHashMap();
                        if (blockmodeldefinition.func_188002_b()) {
                            multipart = blockmodeldefinition.func_188001_c();
                            immutablelist.forEach(arg_0 -> ModelBakery.lambda$loadBlockstate$19(map2, multipart, (List)list, arg_0));
                        } else {
                            multipart = null;
                        }
                        blockmodeldefinition.func_209578_a().forEach((arg_0, arg_1) -> ModelBakery.lambda$loadBlockstate$23(immutablelist, statecontainer, map2, (List)list, multipart, pair, blockmodeldefinition, resourcelocation1, pair1, arg_0, arg_1));
                        map1.putAll(map2);
                    }
                }
                catch (IOException ioexception) {
                    field_177603_c.warn("Exception loading blockstate definition: {}: {}", (Object)resourcelocation1, (Object)ioexception);
                }
                catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                    throw modelbakery$blockstatedefinitionexception;
                }
                catch (Exception exception) {
                    throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s': %s", resourcelocation1, exception));
                }
                finally {
                    HashMap map3 = Maps.newHashMap();
                    map.forEach((p_229341_5_, p_229341_6_) -> {
                        Pair pair2 = (Pair)map1.get(p_229341_6_);
                        if (pair2 == null) {
                            field_177603_c.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)resourcelocation1, (Object)p_229341_5_);
                            pair2 = pair;
                        }
                        this.func_209593_a((ResourceLocation)p_229341_5_, (IUnbakedModel)pair2.getFirst());
                        try {
                            ModelListWrapper modelbakery$modellistwrapper1 = (ModelListWrapper)((Supplier)pair2.getSecond()).get();
                            map3.computeIfAbsent(modelbakery$modellistwrapper1, p_229334_0_ -> Sets.newIdentityHashSet()).add(p_229341_6_);
                        }
                        catch (Exception exception1) {
                            field_177603_c.warn("Exception evaluating model definition: '{}'", (Object)p_229341_5_, (Object)exception1);
                        }
                    });
                    map3.forEach((p_229335_1_, p_229335_2_) -> {
                        Iterator iterator = p_229335_2_.iterator();
                        while (iterator.hasNext()) {
                            BlockState blockstate = (BlockState)((Object)((Object)iterator.next()));
                            if (blockstate.func_185901_i() == BlockRenderType.MODEL) continue;
                            iterator.remove();
                            this.field_225367_M.put((Object)blockstate, 0);
                        }
                        if (p_229335_2_.size() > 1) {
                            this.func_225352_a((Iterable<BlockState>)p_229335_2_);
                        }
                    });
                }
            }
        }
    }

    private void func_209593_a(ResourceLocation p_209593_1_, IUnbakedModel p_209593_2_) {
        this.field_217849_F.put(p_209593_1_, p_209593_2_);
        this.field_217848_D.addAll(p_209593_2_.func_187965_e());
    }

    private void addModelToCache(ResourceLocation p_217843_1_) {
        IUnbakedModel iunbakedmodel = this.func_209597_a(p_217843_1_);
        this.field_217849_F.put(p_217843_1_, iunbakedmodel);
        this.field_217851_H.put(p_217843_1_, iunbakedmodel);
    }

    private void func_217843_a(ModelResourceLocation p_217843_1_) {
        IUnbakedModel iunbakedmodel = this.func_209597_a(p_217843_1_);
        this.field_217849_F.put(p_217843_1_, iunbakedmodel);
        this.field_217851_H.put(p_217843_1_, iunbakedmodel);
    }

    private void func_225352_a(Iterable<BlockState> p_225352_1_) {
        int i = this.field_225366_L++;
        p_225352_1_.forEach(p_229324_2_ -> this.field_225367_M.put((Object)p_229324_2_, i));
    }

    @Nullable
    @Deprecated
    public IBakedModel func_217845_a(ResourceLocation p_217845_1_, IModelTransform p_217845_2_) {
        return this.getBakedModel(p_217845_1_, p_217845_2_, arg_0 -> ((SpriteMap)this.field_229322_z_).func_229151_a_(arg_0));
    }

    @Nullable
    public IBakedModel getBakedModel(ResourceLocation p_217845_1_, IModelTransform p_217845_2_, Function<Material, TextureAtlasSprite> textureGetter) {
        BlockModel blockmodel;
        Triple triple = Triple.of((Object)p_217845_1_, (Object)p_217845_2_.func_225615_b_(), (Object)p_217845_2_.func_188049_c());
        if (this.field_217850_G.containsKey(triple)) {
            return this.field_217850_G.get(triple);
        }
        if (this.field_229322_z_ == null) {
            throw new IllegalStateException("bake called too early");
        }
        IUnbakedModel iunbakedmodel = this.func_209597_a(p_217845_1_);
        if (iunbakedmodel instanceof BlockModel && (blockmodel = (BlockModel)iunbakedmodel).func_178310_f() == field_177606_o) {
            return field_217854_z.func_209579_a(textureGetter, blockmodel).func_228813_a_(this, blockmodel, textureGetter, p_217845_2_, p_217845_1_);
        }
        IBakedModel ibakedmodel = iunbakedmodel.func_225613_a_(this, textureGetter, p_217845_2_, p_217845_1_);
        this.field_217850_G.put((Triple<ResourceLocation, TransformationMatrix, Boolean>)triple, ibakedmodel);
        return ibakedmodel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockModel func_177594_c(ResourceLocation location) throws IOException {
        BlockModel lvt_5_2_;
        IResource iresource;
        Reader reader;
        block8: {
            String s;
            block9: {
                BlockModel lvt_5_2_2;
                reader = null;
                iresource = null;
                s = location.func_110623_a();
                if ("builtin/generated".equals(s)) break block8;
                if (!"builtin/entity".equals(s)) break block9;
                BlockModel blockModel = lvt_5_2_2 = field_177616_r;
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(iresource);
                return blockModel;
            }
            if (s.startsWith("builtin/")) {
                String s2 = s.substring("builtin/".length());
                String s1 = field_177600_d.get(s2);
                if (s1 == null) {
                    throw new FileNotFoundException(location.toString());
                }
                reader = new StringReader(s1);
            } else {
                iresource = this.field_177598_f.func_199002_a(new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json"));
                reader = new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8);
            }
            BlockModel lvt_5_2_3 = BlockModel.func_178307_a(reader);
            lvt_5_2_3.field_178317_b = location.toString();
            BlockModel blockModel = lvt_5_2_3;
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((Closeable)iresource);
            return blockModel;
        }
        try {
            lvt_5_2_ = field_177606_o;
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(iresource);
        }
        return lvt_5_2_;
    }

    public Map<ResourceLocation, IBakedModel> func_217846_a() {
        return this.field_217852_I;
    }

    public Object2IntMap<BlockState> func_225354_b() {
        return this.field_225367_M;
    }

    public Set<ResourceLocation> getSpecialModels() {
        return Collections.emptySet();
    }

    public SpriteMap getSpriteMap() {
        return this.field_229322_z_;
    }

    private static /* synthetic */ void lambda$loadBlockstate$23(ImmutableList immutablelist, StateContainer statecontainer, Map map2, List list, Multipart multipart, Pair pair, BlockModelDefinition blockmodeldefinition, ResourceLocation resourcelocation1, Pair pair1, String p_229329_9_, VariantList p_229329_10_) {
        try {
            immutablelist.stream().filter(ModelBakery.func_209605_a((StateContainer<Block, BlockState>)statecontainer, p_229329_9_)).forEach(p_229338_6_ -> {
                Pair pair2 = map2.put(p_229338_6_, Pair.of((Object)p_229329_10_, () -> ModelListWrapper.func_225336_a(p_229338_6_, (IUnbakedModel)p_229329_10_, list)));
                if (pair2 != null && pair2.getFirst() != multipart) {
                    map2.put(p_229338_6_, pair);
                    throw new RuntimeException("Overlapping definition with: " + (String)blockmodeldefinition.func_209578_a().entrySet().stream().filter(p_229331_1_ -> p_229331_1_.getValue() == pair2.getFirst()).findFirst().get().getKey());
                }
            });
        }
        catch (Exception exception1) {
            field_177603_c.warn("Exception loading blockstate definition: '{}' in resourcepack: '{}' for variant: '{}': {}", (Object)resourcelocation1, pair1.getFirst(), (Object)p_229329_9_, (Object)exception1.getMessage());
        }
    }

    private static /* synthetic */ void lambda$loadBlockstate$19(Map map2, Multipart multipart, List list, BlockState p_229339_3_) {
        Pair pair2 = map2.put(p_229339_3_, Pair.of((Object)multipart, () -> ModelListWrapper.func_225335_a(p_229339_3_, multipart, list)));
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ModelListWrapper {
        private final List<IUnbakedModel> field_225339_a;
        private final List<Object> field_225340_b;

        public ModelListWrapper(List<IUnbakedModel> p_i51613_1_, List<Object> p_i51613_2_) {
            this.field_225339_a = p_i51613_1_;
            this.field_225340_b = p_i51613_2_;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof ModelListWrapper)) {
                return false;
            }
            ModelListWrapper modelbakery$modellistwrapper = (ModelListWrapper)p_equals_1_;
            return Objects.equals(this.field_225339_a, modelbakery$modellistwrapper.field_225339_a) && Objects.equals(this.field_225340_b, modelbakery$modellistwrapper.field_225340_b);
        }

        public int hashCode() {
            return 31 * this.field_225339_a.hashCode() + this.field_225340_b.hashCode();
        }

        public static ModelListWrapper func_225335_a(BlockState p_225335_0_, Multipart p_225335_1_, Collection<IProperty<?>> p_225335_2_) {
            StateContainer<Block, BlockState> statecontainer = p_225335_0_.func_177230_c().func_176194_O();
            List list = (List)p_225335_1_.func_188136_a().stream().filter(p_225338_2_ -> p_225338_2_.func_188166_a(statecontainer).test(p_225335_0_)).map(Selector::func_188165_a).collect(ImmutableList.toImmutableList());
            List<Object> list1 = ModelListWrapper.func_225337_a(p_225335_0_, p_225335_2_);
            return new ModelListWrapper(list, list1);
        }

        public static ModelListWrapper func_225336_a(BlockState p_225336_0_, IUnbakedModel p_225336_1_, Collection<IProperty<?>> p_225336_2_) {
            List<Object> list = ModelListWrapper.func_225337_a(p_225336_0_, p_225336_2_);
            return new ModelListWrapper((List<IUnbakedModel>)ImmutableList.of((Object)p_225336_1_), list);
        }

        private static List<Object> func_225337_a(BlockState p_225337_0_, Collection<IProperty<?>> p_225337_1_) {
            return (List)p_225337_1_.stream().map(arg_0 -> ((BlockState)p_225337_0_).func_177229_b(arg_0)).collect(ImmutableList.toImmutableList());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class BlockStateDefinitionException
    extends RuntimeException {
        public BlockStateDefinitionException(String message) {
            super(message);
        }
    }
}

